/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.rusefi.ConnectivityContext;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IniNotFoundException;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.BinaryProtocolExecutor;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.CalibrationsUpdater;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.ComposedTuneMigrator;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import com.rusefi.ui.basic.MigrateSettingsCheckboxState;
import com.rusefi.util.TuneBackupUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class CalibrationsHelper {
    private static final Logging log = Logging.getLogging(CalibrationsHelper.class);
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
    private static final String RUSEFI_FORCE_CALIBRATIONS_RESTORE = System.getenv("RUSEFI_FORCE_CALIBRATIONS_RESTORE");

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("File name and port are expected as command line arguments!");
        } else {
            String port = args[1];
            String destinationFileName = args[0];
            Optional<CalibrationsInfo> calibrationsInfo = CalibrationsHelper.readAndBackupCurrentCalibrations(port, UpdateOperationCallbacks.CONSOLE, destinationFileName);
            if (!calibrationsInfo.isPresent()) {
                System.err.printf("Failed to read current calibrations from %s port%n", port);
            } else {
                CalibrationsHelper.backUpCalibrationsInfo(calibrationsInfo.get(), destinationFileName + "_", UpdateOperationCallbacks.CONSOLE);
            }
        }
    }

    public static boolean updateFirmwareAndRestorePreviousCalibrations(String ecuPort, UpdateOperationCallbacks callbacks, Supplier<Boolean> updateFirmware, ConnectivityContext connectivityContext) {
        AutoupdateUtil.assertNotAwtThread();
        String timestampFileNameComponent = DATE_FORMAT.format(new Date());
        Optional<CalibrationsInfo> prevCalibrations = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "backup_from_ecu"), connectivityContext);
        if (!prevCalibrations.isPresent()) {
            callbacks.logLine("Failed to back up current tune from ECU...");
            return false;
        }
        if (!updateFirmware.get().booleanValue()) {
            return false;
        }
        Optional<CalibrationsInfo> updatedCalibrations = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "after_firmware_update"), connectivityContext);
        if (!updatedCalibrations.isPresent()) {
            callbacks.logLine("Failed to back up tune from ECU after firmware update...");
            return false;
        }
        Optional<CalibrationsInfo> mergedCalibrations = CalibrationsHelper.mergeCalibrations(prevCalibrations.get().getIniFile(), prevCalibrations.get().generateMsq(), updatedCalibrations.get(), callbacks, Collections.emptySet());
        if (mergedCalibrations.isPresent() && MigrateSettingsCheckboxState.isMigrationNeeded) {
            if (!CalibrationsHelper.backUpCalibrationsInfo(mergedCalibrations.get(), CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "merged_to_write"), callbacks)) {
                callbacks.logLine("Failed to back up merged tune before writing to ECU...");
                return false;
            }
            if (!CalibrationsUpdater.INSTANCE.updateCalibrations(ecuPort, mergedCalibrations.get().getImage().getConfigurationImage(), callbacks, connectivityContext)) {
                callbacks.logLine("Failed to write merged tune to ECU...");
                return false;
            }
            Optional<CalibrationsInfo> mergedTuneFromEcu = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "merged_from_ecu"), connectivityContext);
            if (!mergedTuneFromEcu.isPresent()) {
                callbacks.logLine("Failed to back up merged tune from ECU...");
                return false;
            }
        }
        return true;
    }

    public static boolean importTune(String ecuPort, Msq msqToImport, UpdateOperationCallbacks callbacks, ConnectivityContext connectivityContext) {
        IniFileModel iniFileToImport;
        AutoupdateUtil.assertNotAwtThread();
        String signature = msqToImport.versionInfo.getSignature();
        try {
            iniFileToImport = BinaryProtocol.iniFileProvider.provide(signature);
        }
        catch (IniNotFoundException e) {
            callbacks.logLine(String.format("We failed to get .ini file for signature `%s`", signature));
            return false;
        }
        String timestampFileNameComponent = DATE_FORMAT.format(new Date());
        if (!CalibrationsHelper.backupTune(iniFileToImport, msqToImport, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "tune_to_import"), callbacks)) {
            callbacks.logLine("Failed to back up tune to import...");
            return false;
        }
        Optional<CalibrationsInfo> prevTune = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "backup_from_ecu"), connectivityContext);
        if (!prevTune.isPresent()) {
            callbacks.logLine("Failed to back up current tune from ECU...");
            return false;
        }
        Optional<CalibrationsInfo> mergedTune = CalibrationsHelper.mergeCalibrations(iniFileToImport, msqToImport, prevTune.get(), callbacks, new HashSet<String>(Collections.singletonList("vinNumber")));
        if (mergedTune.isPresent()) {
            if (!CalibrationsHelper.backUpCalibrationsInfo(mergedTune.get(), CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "merged_to_write"), callbacks)) {
                callbacks.logLine("Failed to back up merged tune...");
                return false;
            }
            if (!CalibrationsUpdater.INSTANCE.updateCalibrations(ecuPort, mergedTune.get().getImage().getConfigurationImage(), callbacks, connectivityContext)) {
                callbacks.logLine("Failed to write merged tune to ECU...");
                return false;
            }
            Optional<CalibrationsInfo> mergedTuneFromEcu = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFileNameComponent, "merged_from_ecu"), connectivityContext);
            if (!mergedTuneFromEcu.isPresent()) {
                callbacks.logLine("Failed to back up merged tune from ECU...");
                return false;
            }
        }
        return true;
    }

    static String getFileNameWithoutExtension(String timestampNameComponent, String fileNameComponent) {
        return String.format("%s%s_%s", "state/", timestampNameComponent, fileNameComponent);
    }

    private static Optional<CalibrationsInfo> readCalibrationsInfo(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks) {
        try {
            IniFileModel iniFile;
            String signature = BinaryProtocol.getSignature(binaryProtocol.getStream());
            if (signature == null) {
                callbacks.logLine("No response from " + binaryProtocol.getStream());
                return Optional.empty();
            }
            callbacks.logLine(String.format("Received a signature %s", signature));
            try {
                iniFile = BinaryProtocol.iniFileProvider.provide(signature);
            }
            catch (IniNotFoundException e) {
                throw new RuntimeException(e);
            }
            Objects.requireNonNull(iniFile);
            int pageSize = iniFile.getMetaInfo().getPageSize(0);
            callbacks.logLine(String.format("Page size is %d", pageSize));
            ConfigurationImageMetaVersion0_0 meta = ConfigurationImageMetaVersion0_0.getMeta(iniFile);
            callbacks.logLine("Reading current calibrations...");
            ConfigurationImageWithMeta image = binaryProtocol.readFullImageFromController(meta);
            return Optional.of(new CalibrationsInfo(iniFile, image));
        }
        catch (IOException e) {
            log.error("Failed to read meta:", e);
            callbacks.logLine("Failed to read meta");
            return Optional.empty();
        }
    }

    private static boolean backupTune(IniFileModel ini, Msq msq, String fileName, UpdateOperationCallbacks callbacks) {
        try {
            String iniFileName = String.format("%s.ini", fileName);
            Path iniFilePath = Paths.get(ini.getIniFilePath(), new String[0]);
            callbacks.logLine(String.format("Backing up ini-file `%s`...", iniFilePath));
            Files.copy(iniFilePath, Paths.get(iniFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            callbacks.logLine(String.format("`%s` ini-file is backed up as `%s`", iniFilePath.getFileName(), iniFileName));
            String msqFileName = String.format("%s.msq", fileName);
            callbacks.logLine(String.format("Backing up msq-file to %s...", msqFileName));
            msq.writeXmlFile(msqFileName);
            callbacks.logLine(String.format("msq-file is backed up as `%s`", msqFileName));
            return true;
        }
        catch (Exception e) {
            log.error("Backing up tune failed:", e);
            callbacks.logLine("Backing up tune failed: " + e);
            return false;
        }
    }

    public static boolean backUpCalibrationsInfo(CalibrationsInfo calibrationsInfo, String fileName, UpdateOperationCallbacks callbacks) {
        try {
            String iniFileName = String.format("%s.ini", fileName);
            IniFileModel ini = calibrationsInfo.getIniFile();
            Path iniFilePath = Paths.get(ini.getIniFilePath(), new String[0]);
            callbacks.logLine(String.format("Backing up current ini-file `%s`...", iniFilePath));
            Files.copy(iniFilePath, Paths.get(iniFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            callbacks.logLine(String.format("`%s` ini-file is backed up as `%s`", iniFilePath.getFileName(), iniFileName));
            String zipFileName = String.format("%s.zip", fileName);
            String msqFileName = String.format("%s.msq", fileName);
            callbacks.logLine(String.format("Backing up calibrations to files `%s` and `%s`...", zipFileName, msqFileName));
            TuneBackupUtil.saveConfigurationImageToFiles(calibrationsInfo.getImage(), ini, zipFileName, msqFileName);
            callbacks.logLine(String.format("Calibrations are backed up to files `%s` and `%s`", zipFileName, msqFileName));
            return true;
        }
        catch (Exception e) {
            log.error("Backing up calibrations failed:", e);
            callbacks.logLine("Backing up current calibrations failed: " + e);
            return false;
        }
    }

    public static Optional<CalibrationsInfo> readCurrentCalibrations(String port, UpdateOperationCallbacks callbacks, ConnectivityContext connectivityContext) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(port, callbacks, binaryProtocol -> {
            try {
                return CalibrationsHelper.readCalibrationsInfo(binaryProtocol, callbacks);
            }
            catch (Exception e) {
                log.error("Failed to read current calibrations:", e);
                callbacks.logLine("Failed to read current calibrations");
                return Optional.empty();
            }
        }, Optional.empty(), connectivityContext, "readCalibrationsInfo");
    }

    public static Optional<CalibrationsInfo> readCurrentCalibrationsWithoutSuspendingPortScanner(String port, UpdateOperationCallbacks callbacks) {
        return BinaryProtocolExecutor.execute(port, callbacks, binaryProtocol -> {
            try {
                return CalibrationsHelper.readCalibrationsInfo(binaryProtocol, callbacks);
            }
            catch (Exception e) {
                log.error("Failed to read current calibrations:", e);
                callbacks.logLine("Failed to read current calibrations");
                return Optional.empty();
            }
        }, Optional.empty(), true, "readCalibrationsInfo");
    }

    public static Optional<CalibrationsInfo> readAndBackupCurrentCalibrationsWithSuspendedPortScanner(String ecuPort, UpdateOperationCallbacks callbacks, String backupFileName, ConnectivityContext connectivityContext) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(ecuPort, callbacks, binaryProtocol -> CalibrationsHelper.readAndBackupCurrentCalibrations(binaryProtocol, callbacks, backupFileName), Optional.empty(), connectivityContext, "readAndBackupCurrentCalibrations");
    }

    private static Optional<CalibrationsInfo> readAndBackupCurrentCalibrations(String ecuPort, UpdateOperationCallbacks callbacks, String backupFileName) {
        return BinaryProtocolExecutor.execute(ecuPort, callbacks, binaryProtocol -> CalibrationsHelper.readAndBackupCurrentCalibrations(binaryProtocol, callbacks, backupFileName), Optional.empty(), false, "readAndBackupCurrentCalibrations");
    }

    private static Optional<CalibrationsInfo> readAndBackupCurrentCalibrations(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks, String backupFileName) {
        try {
            CalibrationsInfo receivedCalibrations;
            Optional<CalibrationsInfo> calibrationsInfo = CalibrationsHelper.readCalibrationsInfo(binaryProtocol, callbacks);
            if (calibrationsInfo.isPresent() && CalibrationsHelper.backUpCalibrationsInfo(receivedCalibrations = calibrationsInfo.get(), backupFileName, callbacks)) {
                return calibrationsInfo;
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("Back up current calibrations failed:", e);
            callbacks.logLine("Back up current calibrations failed");
            return Optional.empty();
        }
    }

    public static Optional<CalibrationsInfo> mergeCalibrations(IniFileModel prevIniFile, Msq prevMsq, CalibrationsInfo newCalibrations, UpdateOperationCallbacks callbacks, Set<String> additionalIniFieldsToIgnore) {
        Optional<CalibrationsInfo> result = Optional.empty();
        IniFileModel newIniFile = newCalibrations.getIniFile();
        Msq newMsq = newCalibrations.generateMsq();
        TuneMigrationContext context = new TuneMigrationContext(prevIniFile, prevMsq, newIniFile, newMsq, callbacks, additionalIniFieldsToIgnore);
        ComposedTuneMigrator.INSTANCE.migrateTune(context);
        Set<Map.Entry<String, Constant>> valuesToUpdate = context.getMigratedConstants().entrySet();
        if (!valuesToUpdate.isEmpty()) {
            ConfigurationImage mergedImage = newCalibrations.getImage().getConfigurationImage().clone();
            for (Map.Entry<String, Constant> valueToUpdate : valuesToUpdate) {
                String migratedFieldName = valueToUpdate.getKey();
                Constant migratedValue = valueToUpdate.getValue();
                Optional<IniField> fieldToUpdate = newIniFile.findIniField(migratedFieldName);
                if (fieldToUpdate.isPresent()) {
                    try {
                        fieldToUpdate.get().setValue(mergedImage, migratedValue);
                    }
                    catch (Throwable e) {
                        log.error(String.format("We failed to set value %s for ini-field %s", migratedValue, fieldToUpdate), e);
                        throw new IllegalStateException("Unexpected during " + migratedValue, e);
                    }
                    callbacks.logLine(String.format("To restore previous calibrations we are going to update the field `%s` with a value `%s`", migratedFieldName, migratedValue.getValue()));
                    continue;
                }
                if (null == migratedValue) {
                    log.info(String.format("Disappeared `%s` field has been already migrated by one of migrators", migratedFieldName));
                    continue;
                }
                callbacks.logLine(String.format("WARNING!!! To restore previous calibrations we want to update the field `%s` with a value `%s`, but this field has disappeared in updated .ini file", migratedFieldName, migratedValue.getValue()));
            }
            result = Optional.of(new CalibrationsInfo(newIniFile, new ConfigurationImageWithMeta(newCalibrations.getImage().getMeta(), mergedImage.getContent())));
        } else if ("true".equalsIgnoreCase(RUSEFI_FORCE_CALIBRATIONS_RESTORE)) {
            callbacks.logLine("It looks like we do not need to update previous calibrations, but for debugging we are going to rewrite to ECU new calibrations again.");
            result = Optional.of(newCalibrations);
        } else {
            callbacks.logLine("It looks like we do not need to update any fields to restore previous calibrations.");
        }
        return result;
    }
}

