/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.can.PCanIoStream;
import com.rusefi.tools.CANConnectorStartup;
import com.rusefi.ui.StatusConsumer;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PcanConnectorUI {
    private static final Logging log = Logging.getLogging(PcanConnectorUI.class);

    public static void show() {
        FrameHelper frame = new FrameHelper(3);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Running PCAN connector for TS: RX on " + Integer.toString(0x300100, 16)), "North");
        JTextArea logTextArea = new JTextArea();
        JPanel panelForScroll = new JPanel(new BorderLayout());
        panelForScroll.add((Component)logTextArea, "Center");
        JScrollPane scrollPane = new JScrollPane(panelForScroll, 22, 30);
        panel.add((Component)scrollPane, "Center");
        StatusConsumer statusConsumer = (string, breakLineOnTextArea, sendToLogger) -> SwingUtilities.invokeLater(() -> {
            if (sendToLogger) {
                log.info(string);
            }
            String stringForTextArea = string;
            if (breakLineOnTextArea) {
                stringForTextArea = stringForTextArea + "\r\n";
            }
            logTextArea.append(stringForTextArea);
            UiUtils.trueLayout(logTextArea);
        });
        new NamedThreadFactory("PCAN-connector").newThread(() -> {
            PCanIoStream stream = PCanIoStream.createStream(statusConsumer);
            try {
                if (stream != null) {
                    CANConnectorStartup.start(stream, statusConsumer);
                }
            }
            catch (IOException e) {
                statusConsumer.append("Error " + e);
            }
        }).start();
        frame.showFrame(panel);
    }
}

