/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BrushedMetalFilter;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.HsbColor;
import eu.hansolo.steelseries.tools.LinenFilter;
import eu.hansolo.steelseries.tools.Orientation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public final class Util
extends Enum<Util> {
    public static final /* enum */ Util INSTANCE = new Util();
    private final float INT_TO_FLOAT_CONST = 0.003921569f;
    private final Pattern NUMBERS_ONLY = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    private final Matcher MATCHES_NUMBERS = this.NUMBERS_ONLY.matcher("");
    private Font digitalFont = null;
    private final Font STANDARD_FONT = new Font("Verdana", 1, 24);
    private final Rectangle2D TEXT_BOUNDARY = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    private static final /* synthetic */ Util[] $VALUES;

    public static Util[] values() {
        return (Util[])$VALUES.clone();
    }

    public static Util valueOf(String name) {
        return Enum.valueOf(Util.class, name);
    }

    private Util() {
        try {
            this.digitalFont = Font.createFont(0, ((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/steelseries/resources/digital.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.digitalFont);
        }
        catch (FontFormatException fontFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Shape rotateTextAroundCenter(Graphics2D G2, String TEXT, int TEXT_POSITION_X, int TEXT_POSITION_Y, double ROTATION_ANGLE) {
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        TextLayout TEXT_LAYOUT = new TextLayout(TEXT, G2.getFont(), RENDER_CONTEXT);
        this.MATCHES_NUMBERS.reset(TEXT);
        float DESCENT = this.MATCHES_NUMBERS.matches() ? TEXT_LAYOUT.getDescent() : 0.0f;
        Rectangle2D TEXT_BOUNDS = TEXT_LAYOUT.getBounds();
        this.TEXT_BOUNDARY.setRect(TEXT_BOUNDS.getMinX(), TEXT_BOUNDS.getMinY(), TEXT_BOUNDS.getWidth(), TEXT_BOUNDS.getHeight() + (double)(DESCENT / 2.0f));
        GlyphVector GLYPH_VECTOR = G2.getFont().createGlyphVector(RENDER_CONTEXT, TEXT);
        Shape GLYPH = GLYPH_VECTOR.getOutline((int)(-this.TEXT_BOUNDARY.getCenterX()), 2 * (int)this.TEXT_BOUNDARY.getCenterY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.translate((double)TEXT_POSITION_X, (double)TEXT_POSITION_Y + this.TEXT_BOUNDARY.getHeight());
        G2.rotate(ROTATION_ANGLE, -this.TEXT_BOUNDARY.getCenterX() + this.TEXT_BOUNDARY.getWidth() / 2.0, this.TEXT_BOUNDARY.getCenterY() - (this.TEXT_BOUNDARY.getHeight() + (double)DESCENT) / 2.0);
        G2.fill(GLYPH);
        G2.setTransform(OLD_TRANSFORM);
        return GLYPH;
    }

    public Point2D getCenteredTextPosition(Graphics2D G2, Rectangle2D BOUNDARY, String TEXT) {
        return this.getCenteredTextPosition(G2, BOUNDARY, G2.getFont(), TEXT);
    }

    public Point2D getCenteredTextPosition(Graphics2D G2, Rectangle2D BOUNDARY, Font FONT, String TEXT) {
        double CENTER_X = BOUNDARY.getWidth() / 2.0;
        double CENTER_Y = BOUNDARY.getHeight() / 2.0;
        FontRenderContext RENDER_CONTEXT = G2.getFontRenderContext();
        TextLayout LAYOUT = new TextLayout(TEXT, FONT, RENDER_CONTEXT);
        Rectangle2D TEXT_BOUNDS = LAYOUT.getBounds();
        double TEXT_X = CENTER_X - TEXT_BOUNDS.getWidth() / 2.0;
        double TEXT_Y = CENTER_Y - TEXT_BOUNDS.getHeight() / 2.0 + TEXT_BOUNDS.getHeight();
        return new Point2D.Double(TEXT_X, TEXT_Y);
    }

    public BufferedImage getScaledInstance(BufferedImage IMAGE, int TARGET_WIDTH, int TARGET_HEIGHT, Object HINT) {
        int TYPE = IMAGE.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = IMAGE;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int WIDTH = TARGET_WIDTH;
        int HEIGHT = TARGET_HEIGHT;
        int previewWidth = ret.getWidth();
        int previewHeight = ret.getHeight();
        if (scratchImage == null) {
            scratchImage = new BufferedImage(WIDTH, HEIGHT, TYPE);
            g2 = scratchImage.createGraphics();
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, HINT);
        g2.drawImage(ret, 0, 0, WIDTH, HEIGHT, 0, 0, previewWidth, previewHeight, null);
        ret = scratchImage;
        g2.dispose();
        if (TARGET_WIDTH != ret.getWidth() || TARGET_HEIGHT != ret.getHeight()) {
            scratchImage = new BufferedImage(TARGET_WIDTH, TARGET_HEIGHT, TYPE);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public BufferedImage createReflectionImage(BufferedImage SOURCE_IMAGE) {
        return this.createReflectionImage(SOURCE_IMAGE, 0.5f, 0.7f);
    }

    public BufferedImage createReflectionImage(BufferedImage SOURCE_IMAGE, float OPACITY, float FADE_OUT_HEIGHT) {
        BufferedImage REFLECTION_IMAGE = new BufferedImage(SOURCE_IMAGE.getWidth(), SOURCE_IMAGE.getHeight(), 2);
        BufferedImage BLURED_REFLECTION_IMAGE = new BufferedImage(SOURCE_IMAGE.getWidth(), SOURCE_IMAGE.getHeight(), 2);
        Graphics2D G2 = REFLECTION_IMAGE.createGraphics();
        G2.translate(0, SOURCE_IMAGE.getHeight());
        G2.scale(1.0, -1.0);
        G2.drawRenderedImage(SOURCE_IMAGE, null);
        G2.setComposite(AlphaComposite.getInstance(6));
        G2.setPaint(new GradientPaint(0.0f, (float)SOURCE_IMAGE.getHeight() * FADE_OUT_HEIGHT, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, SOURCE_IMAGE.getHeight(), new Color(0.0f, 0.0f, 0.0f, OPACITY)));
        G2.fillRect(0, 0, SOURCE_IMAGE.getWidth(), SOURCE_IMAGE.getHeight());
        G2.dispose();
        float[] data = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
        Kernel KERNEL = new Kernel(3, 3, data);
        ConvolveOp CONVOLE = new ConvolveOp(KERNEL, 1, null);
        CONVOLE.filter(REFLECTION_IMAGE, BLURED_REFLECTION_IMAGE);
        return BLURED_REFLECTION_IMAGE;
    }

    public BufferedImage createBrushMetalTexture(Color COLOR, int WIDTH, int HEIGHT) {
        return this.createBrushMetalTexture(COLOR, WIDTH, HEIGHT, 5, 0.1f, true, 0.3f);
    }

    public BufferedImage createBrushMetalTexture(Color COLOR, int WIDTH, int HEIGHT, int RADIUS, float AMOUNT, boolean MONOCHROME, float SHINE) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage IMAGE = this.createImage(WIDTH, HEIGHT, 3);
        BrushedMetalFilter metalBrush = new BrushedMetalFilter();
        if (COLOR != null) {
            metalBrush.setColor(COLOR.getRGB());
        }
        metalBrush.setAmount(AMOUNT);
        metalBrush.setMonochrome(MONOCHROME);
        metalBrush.setShine(SHINE);
        metalBrush.setRadius(RADIUS);
        return metalBrush.filter(IMAGE, IMAGE);
    }

    public BufferedImage createLinenTexture(Color COLOR, int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage IMAGE1 = this.createImage(WIDTH, HEIGHT, 3);
        BufferedImage IMAGE2 = this.createImage(WIDTH, HEIGHT, 3);
        LinenFilter linenBrush = new LinenFilter();
        if (COLOR != null) {
            linenBrush.setColor(COLOR.getRGB());
        }
        AlphaComposite COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
        BufferedImage RESULT = this.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = RESULT.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        linenBrush.setShine(0.25f);
        linenBrush.setAmount(0.65f);
        linenBrush.setRadius(60);
        G2.drawImage((Image)linenBrush.filter(IMAGE1, IMAGE1), 0, 0, null);
        G2.setComposite(COMPOSITE);
        linenBrush.setOrientation(Orientation.VERTICAL);
        linenBrush.setAmount(0.7f);
        linenBrush.setRadius(55);
        G2.drawImage((Image)linenBrush.filter(IMAGE2, IMAGE2), 0, 0, null);
        G2.dispose();
        return RESULT;
    }

    public BufferedImage create_STAINLESS_STEEL_PLATE_Texture(int SIZE) {
        if (SIZE <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = this.createImage(SIZE, SIZE, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Ellipse2D.Double STEEL_CIRCLE = new Ellipse2D.Double(0.0, 0.0, (double)SIZE / 2.0, (double)SIZE / 2.0);
        Point2D.Double CENTER = new Point2D.Double(STEEL_CIRCLE.getCenterX(), STEEL_CIRCLE.getCenterY());
        float[] FRACTIONS = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
        Color[] COLORS = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
        ConicalGradientPaint GRADIENT = new ConicalGradientPaint(false, CENTER, -0.45f, FRACTIONS, COLORS);
        double TRANSLATE_STEP = (double)SIZE / 4.0;
        G2.translate(-TRANSLATE_STEP, -TRANSLATE_STEP);
        AffineTransform OLD = G2.getTransform();
        for (int y = 0; y < 5; ++y) {
            int amount;
            if (y % 2 == 0) {
                amount = 3;
                G2.translate(0.0, TRANSLATE_STEP * (double)y);
            } else {
                amount = 2;
                G2.translate(TRANSLATE_STEP, TRANSLATE_STEP * (double)y);
            }
            for (int x = 0; x < amount; ++x) {
                G2.setPaint(GRADIENT);
                G2.fill(STEEL_CIRCLE);
                G2.translate((double)SIZE / 2.0, 0.0);
            }
            G2.setTransform(OLD);
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create_CARBON_Texture(int SIZE) {
        if (SIZE <= 0) {
            return this.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = this.createImage(SIZE, SIZE, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Rectangle2D.Double RULB = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double RULB_START = new Point2D.Double(0.0, ((Rectangle2D)RULB).getBounds2D().getMinY());
        Point2D.Double RULB_STOP = new Point2D.Double(0.0, ((Rectangle2D)RULB).getBounds2D().getMaxY());
        float[] RULB_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RULB_COLORS = new Color[]{new Color(35, 35, 35, 255), new Color(23, 23, 23, 255)};
        LinearGradientPaint RULB_GRADIENT = new LinearGradientPaint(RULB_START, RULB_STOP, RULB_FRACTIONS, RULB_COLORS);
        G2.setPaint(RULB_GRADIENT);
        G2.fill(RULB);
        Rectangle2D.Double RULF = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.08333333333333333, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.3333333333333333, (double)IMAGE_HEIGHT * 0.4166666666666667);
        Point2D.Double RULF_START = new Point2D.Double(0.0, ((Rectangle2D)RULF).getBounds2D().getMinY());
        Point2D.Double RULF_STOP = new Point2D.Double(0.0, ((Rectangle2D)RULF).getBounds2D().getMaxY());
        float[] RULF_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RULF_COLORS = new Color[]{new Color(38, 38, 38, 255), new Color(30, 30, 30, 255)};
        LinearGradientPaint RULF_GRADIENT = new LinearGradientPaint(RULF_START, RULF_STOP, RULF_FRACTIONS, RULF_COLORS);
        G2.setPaint(RULF_GRADIENT);
        G2.fill(RULF);
        Rectangle2D.Double RLRB = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double RLRB_START = new Point2D.Double(0.0, ((Rectangle2D)RLRB).getBounds2D().getMinY());
        Point2D.Double RLRB_STOP = new Point2D.Double(0.0, ((Rectangle2D)RLRB).getBounds2D().getMaxY());
        float[] RLRB_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RLRB_COLORS = new Color[]{new Color(35, 35, 35, 255), new Color(23, 23, 23, 255)};
        LinearGradientPaint RLRB_GRADIENT = new LinearGradientPaint(RLRB_START, RLRB_STOP, RLRB_FRACTIONS, RLRB_COLORS);
        G2.setPaint(RLRB_GRADIENT);
        G2.fill(RLRB);
        Rectangle2D.Double RLRF = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.5833333333333334, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.3333333333333333, (double)IMAGE_HEIGHT * 0.4166666666666667);
        Point2D.Double RLRF_START = new Point2D.Double(0.0, ((Rectangle2D)RLRF).getBounds2D().getMinY());
        Point2D.Double RLRF_STOP = new Point2D.Double(0.0, ((Rectangle2D)RLRF).getBounds2D().getMaxY());
        float[] RLRF_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RLRF_COLORS = new Color[]{new Color(38, 38, 38, 255), new Color(30, 30, 30, 255)};
        LinearGradientPaint RLRF_GRADIENT = new LinearGradientPaint(RLRF_START, RLRF_STOP, RLRF_FRACTIONS, RLRF_COLORS);
        G2.setPaint(RLRF_GRADIENT);
        G2.fill(RLRF);
        Rectangle2D.Double RURB = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double RURB_START = new Point2D.Double(0.0, ((Rectangle2D)RURB).getBounds2D().getMinY());
        Point2D.Double RURB_STOP = new Point2D.Double(0.0, ((Rectangle2D)RURB).getBounds2D().getMaxY());
        float[] RURB_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RURB_COLORS = new Color[]{new Color(48, 48, 48, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint RURB_GRADIENT = new LinearGradientPaint(RURB_START, RURB_STOP, RURB_FRACTIONS, RURB_COLORS);
        G2.setPaint(RURB_GRADIENT);
        G2.fill(RURB);
        Rectangle2D.Double RURF = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.5833333333333334, (double)IMAGE_HEIGHT * 0.08333333333333333, (double)IMAGE_WIDTH * 0.3333333333333333, (double)IMAGE_HEIGHT * 0.4166666666666667);
        Point2D.Double RURF_START = new Point2D.Double(0.0, ((Rectangle2D)RURF).getBounds2D().getMinY());
        Point2D.Double RURF_STOP = new Point2D.Double(0.0, ((Rectangle2D)RURF).getBounds2D().getMaxY());
        float[] RURF_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RURF_COLORS = new Color[]{new Color(53, 53, 53, 255), new Color(45, 45, 45, 255)};
        LinearGradientPaint RURF_GRADIENT = new LinearGradientPaint(RURF_START, RURF_STOP, RURF_FRACTIONS, RURF_COLORS);
        G2.setPaint(RURF_GRADIENT);
        G2.fill(RURF);
        Rectangle2D.Double RLLB = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double RLLB_START = new Point2D.Double(0.0, ((Rectangle2D)RLLB).getBounds2D().getMinY());
        Point2D.Double RLLB_STOP = new Point2D.Double(0.0, ((Rectangle2D)RLLB).getBounds2D().getMaxY());
        float[] RLLB_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RLLB_COLORS = new Color[]{new Color(48, 48, 48, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint RLLB_GRADIENT = new LinearGradientPaint(RLLB_START, RLLB_STOP, RLLB_FRACTIONS, RLLB_COLORS);
        G2.setPaint(RLLB_GRADIENT);
        G2.fill(RLLB);
        Rectangle2D.Double RLLF = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.08333333333333333, (double)IMAGE_HEIGHT * 0.5833333333333334, (double)IMAGE_WIDTH * 0.3333333333333333, (double)IMAGE_HEIGHT * 0.4166666666666667);
        Point2D.Double RLLF_START = new Point2D.Double(0.0, ((Rectangle2D)RLLF).getBounds2D().getMinY());
        Point2D.Double RLLF_STOP = new Point2D.Double(0.0, ((Rectangle2D)RLLF).getBounds2D().getMaxY());
        float[] RLLF_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] RLLF_COLORS = new Color[]{new Color(53, 53, 53, 255), new Color(45, 45, 45, 255)};
        LinearGradientPaint RLLF_GRADIENT = new LinearGradientPaint(RLLF_START, RLLF_STOP, RLLF_FRACTIONS, RLLF_COLORS);
        G2.setPaint(RLLF_GRADIENT);
        G2.fill(RLLF);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create_PUNCHED_SHEET_Image(int SIZE, Color TEXTURE_COLOR) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (SIZE <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(SIZE, SIZE, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Rectangle2D.Double BACK = new Rectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        G2.setColor(TEXTURE_COLOR);
        G2.fill(BACK);
        Color DARK = TEXTURE_COLOR.darker().darker();
        float[] FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(68, 68, 68, 255)};
        Ellipse2D.Double ULB = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.06666667014360428, (double)IMAGE_WIDTH * (double)0.4f, (double)IMAGE_HEIGHT * (double)0.4f);
        Point2D.Double ULB_START = new Point2D.Double(0.0, ULB.getBounds2D().getMinY());
        Point2D.Double ULB_STOP = new Point2D.Double(0.0, ULB.getBounds2D().getMaxY());
        LinearGradientPaint ULB_GRADIENT = new LinearGradientPaint(ULB_START, ULB_STOP, FRACTIONS, COLORS);
        G2.setPaint(ULB_GRADIENT);
        G2.fill(ULB);
        Ellipse2D.Double ULF = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * (double)0.4f, (double)IMAGE_HEIGHT * (double)0.4f);
        G2.setColor(DARK);
        G2.fill(ULF);
        Ellipse2D.Double LRB = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46666666865348816, (double)IMAGE_HEIGHT * 0.5333333611488342, (double)IMAGE_WIDTH * (double)0.4f, (double)IMAGE_HEIGHT * 0.3999999761581421);
        Point2D.Double LRB_START = new Point2D.Double(0.0, LRB.getBounds2D().getMinY());
        Point2D.Double LRB_STOP = new Point2D.Double(0.0, LRB.getBounds2D().getMaxY());
        LinearGradientPaint LRB_GRADIENT = new LinearGradientPaint(LRB_START, LRB_STOP, FRACTIONS, COLORS);
        G2.setPaint(LRB_GRADIENT);
        G2.fill(LRB);
        Ellipse2D.Double LRF = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46666666865348816, (double)IMAGE_HEIGHT * 0.46666666865348816, (double)IMAGE_WIDTH * (double)0.4f, (double)IMAGE_HEIGHT * (double)0.4f);
        G2.setColor(DARK);
        G2.fill(LRF);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create_NOISE_Image(int WIDTH, int HEIGHT, Color COLOR) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Color DARK_NOISE = COLOR.darker();
        Color BRIGHT_NOISE = COLOR.brighter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        for (int y = 0; y < IMAGE_HEIGHT; ++y) {
            for (int x = 0; x < IMAGE_WIDTH; ++x) {
                Color noiseColor = BW_RND.nextBoolean() ? BRIGHT_NOISE : DARK_NOISE;
                int noiseAlpha = 90 + ALPHA_RND.nextInt(90) - 45;
                G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                G2.drawLine(x, y, x, y);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return gfxConf.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        return gfxConf.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
    }

    public Color setAlpha(Color COLOR, float ALPHA) {
        if (ALPHA > 1.0f) {
            return this.setAlpha(COLOR, 255);
        }
        if (ALPHA < 0.0f) {
            return this.setAlpha(COLOR, 0);
        }
        return this.setAlpha(COLOR, (int)Math.ceil(255.0f * ALPHA));
    }

    public Color setAlpha(Color COLOR, int ALPHA) {
        return new Color(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), ALPHA);
    }

    public Color getColorFromFraction(Color SOURCE_COLOR, Color DESTINATION_COLOR, int RANGE, int CURRENT_FRACTION) {
        float SOURCE_RED = (float)SOURCE_COLOR.getRed() * 0.003921569f;
        float SOURCE_GREEN = (float)SOURCE_COLOR.getGreen() * 0.003921569f;
        float SOURCE_BLUE = (float)SOURCE_COLOR.getBlue() * 0.003921569f;
        float SOURCE_ALPHA = (float)SOURCE_COLOR.getAlpha() * 0.003921569f;
        float DESTINATION_RED = (float)DESTINATION_COLOR.getRed() * 0.003921569f;
        float DESTINATION_GREEN = (float)DESTINATION_COLOR.getGreen() * 0.003921569f;
        float DESTINATION_BLUE = (float)DESTINATION_COLOR.getBlue() * 0.003921569f;
        float DESTINATION_ALPHA = (float)DESTINATION_COLOR.getAlpha() * 0.003921569f;
        float RED_DELTA = DESTINATION_RED - SOURCE_RED;
        float GREEN_DELTA = DESTINATION_GREEN - SOURCE_GREEN;
        float BLUE_DELTA = DESTINATION_BLUE - SOURCE_BLUE;
        float ALPHA_DELTA = DESTINATION_ALPHA - SOURCE_ALPHA;
        float RED_FRACTION = RED_DELTA / (float)RANGE;
        float GREEN_FRACTION = GREEN_DELTA / (float)RANGE;
        float BLUE_FRACTION = BLUE_DELTA / (float)RANGE;
        float ALPHA_FRACTION = ALPHA_DELTA / (float)RANGE;
        return new Color(SOURCE_RED + RED_FRACTION * (float)CURRENT_FRACTION, SOURCE_GREEN + GREEN_FRACTION * (float)CURRENT_FRACTION, SOURCE_BLUE + BLUE_FRACTION * (float)CURRENT_FRACTION, SOURCE_ALPHA + ALPHA_FRACTION * (float)CURRENT_FRACTION);
    }

    public Color interpolateColor(Color COLOR1, Color COLOR2, float FRACTION) {
        assert (Float.compare(FRACTION, 0.0f) >= 0 && Float.compare(FRACTION, 1.0f) <= 0);
        float RED1 = (float)COLOR1.getRed() * 0.003921569f;
        float GREEN1 = (float)COLOR1.getGreen() * 0.003921569f;
        float BLUE1 = (float)COLOR1.getBlue() * 0.003921569f;
        float ALPHA1 = (float)COLOR1.getAlpha() * 0.003921569f;
        float RED2 = (float)COLOR2.getRed() * 0.003921569f;
        float GREEN2 = (float)COLOR2.getGreen() * 0.003921569f;
        float BLUE2 = (float)COLOR2.getBlue() * 0.003921569f;
        float ALPHA2 = (float)COLOR2.getAlpha() * 0.003921569f;
        float DELTA_RED = RED2 - RED1;
        float DELTA_GREEN = GREEN2 - GREEN1;
        float DELTA_BLUE = BLUE2 - BLUE1;
        float DELTA_ALPHA = ALPHA2 - ALPHA1;
        float red = RED1 + DELTA_RED * FRACTION;
        float green = GREEN1 + DELTA_GREEN * FRACTION;
        float blue = BLUE1 + DELTA_BLUE * FRACTION;
        float alpha = ALPHA1 + DELTA_ALPHA * FRACTION;
        float f = red < 0.0f ? 0.0f : (red = red > 1.0f ? 1.0f : red);
        float f2 = green < 0.0f ? 0.0f : (green = green > 1.0f ? 1.0f : green);
        float f3 = blue < 0.0f ? 0.0f : (blue = blue > 1.0f ? 1.0f : blue);
        alpha = alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 1.0f : alpha);
        return new Color(red, green, blue, alpha);
    }

    public Color bilinearInterpolateColor(Color COLOR_UL, Color COLOR_UR, Color COLOR_LL, Color COLOR_LR, float FRACTION_X, float FRACTION_Y) {
        Color INTERPOLATED_COLOR_X1 = this.interpolateColor(COLOR_UL, COLOR_UR, FRACTION_X);
        Color INTERPOLATED_COLOR_X2 = this.interpolateColor(COLOR_LL, COLOR_LR, FRACTION_X);
        return this.interpolateColor(INTERPOLATED_COLOR_X1, INTERPOLATED_COLOR_X2, FRACTION_Y);
    }

    public Color setHue(Color COLOR, float HUE) {
        float[] HSB_VALUES = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        return Color.getHSBColor(HUE, HSB_VALUES[1], HSB_VALUES[2]);
    }

    public Color setSaturation(Color COLOR, float SATURATION) {
        float[] HSB_VALUES = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        return Color.getHSBColor(HSB_VALUES[0], SATURATION, HSB_VALUES[2]);
    }

    public Color setBrightness(Color COLOR, float BRIGHTNESS) {
        float[] HSB_VALUES = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        return Color.getHSBColor(HSB_VALUES[0], HSB_VALUES[1], BRIGHTNESS);
    }

    public Color setHueSaturation(Color COLOR, float HUE, float SATURATION) {
        float[] HSB_VALUES = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        return Color.getHSBColor(HUE, SATURATION, HSB_VALUES[2]);
    }

    public Color setSaturationBrightness(Color COLOR, float SATURATION, float BRIGHTNESS) {
        float[] HSB_VALUES = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        return Color.getHSBColor(HSB_VALUES[0], SATURATION, BRIGHTNESS);
    }

    public Color darker(Color COLOR, double FRACTION) {
        int red = (int)Math.round((double)COLOR.getRed() * (1.0 - FRACTION));
        int green = (int)Math.round((double)COLOR.getGreen() * (1.0 - FRACTION));
        int blue = (int)Math.round((double)COLOR.getBlue() * (1.0 - FRACTION));
        int n = red < 0 ? 0 : (red = red > 255 ? 255 : red);
        int n2 = green < 0 ? 0 : (green = green > 255 ? 255 : green);
        blue = blue < 0 ? 0 : (blue > 255 ? 255 : blue);
        return new Color(red, green, blue, COLOR.getAlpha());
    }

    public Color lighter(Color COLOR, double FRACTION) {
        int red = (int)Math.round((double)COLOR.getRed() * (1.0 + FRACTION));
        int green = (int)Math.round((double)COLOR.getGreen() * (1.0 + FRACTION));
        int blue = (int)Math.round((double)COLOR.getBlue() * (1.0 + FRACTION));
        int n = red < 0 ? 0 : (red = red > 255 ? 255 : red);
        int n2 = green < 0 ? 0 : (green = green > 255 ? 255 : green);
        blue = blue < 0 ? 0 : (blue > 255 ? 255 : blue);
        return new Color(red, green, blue, COLOR.getAlpha());
    }

    public double colorDistance(Color COLOR1, Color COLOR2) {
        double FACTOR = 0.00392156862745098;
        double DELTA_R = (double)(COLOR2.getRed() - COLOR1.getRed()) * 0.00392156862745098;
        double DELTA_G = (double)(COLOR2.getGreen() - COLOR1.getGreen()) * 0.00392156862745098;
        double DELTA_B = (double)(COLOR2.getBlue() - COLOR1.getBlue()) * 0.00392156862745098;
        return Math.sqrt(DELTA_R * DELTA_R + DELTA_G * DELTA_G + DELTA_B * DELTA_B);
    }

    public boolean isDark(Color COLOR) {
        double DISTANCE_TO_WHITE = this.colorDistance(COLOR, Color.WHITE);
        double DISTANCE_TO_BLACK = this.colorDistance(COLOR, Color.BLACK);
        return DISTANCE_TO_BLACK < DISTANCE_TO_WHITE;
    }

    public boolean isMonochrome(Color COLOR) {
        return COLOR.getRed() == COLOR.getGreen() && COLOR.getGreen() == COLOR.getBlue();
    }

    public Font getDigitalFont() {
        if (this.digitalFont == null) {
            this.digitalFont = this.STANDARD_FONT;
        }
        return this.digitalFont.deriveFont(24).deriveFont(0);
    }

    public Font getStandardFont() {
        return this.STANDARD_FONT;
    }

    public void savePngImage(BufferedImage IMAGE, String FILE_NAME) {
        try {
            ImageIO.write((RenderedImage)IMAGE, "png", new File(FILE_NAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double logOfBase(double base, double num) {
        return Math.log(num) / Math.log(base);
    }

    public LinkedList<Color> createShades(float INTENSITY, Color COLOR) {
        int i;
        float[] HSB = Color.RGBtoHSB(COLOR.getRed(), COLOR.getGreen(), COLOR.getBlue(), null);
        float SATURATION_STEPSIZE = HSB[1] / INTENSITY;
        float BRIGHTNESS_STEPSIZE = HSB[2] / INTENSITY;
        LinkedList<Color> colorShades = new LinkedList<Color>();
        for (i = 4; i > 0; --i) {
            colorShades.add(new HsbColor.Builder(COLOR).saturation(HSB[1] - (float)i * SATURATION_STEPSIZE).build().getColor());
        }
        colorShades.add(COLOR);
        for (i = 4; i > 0; --i) {
            colorShades.add(new HsbColor.Builder(COLOR).brightness(HSB[2] - (float)i * BRIGHTNESS_STEPSIZE).build().getColor());
        }
        return colorShades;
    }

    public String valueToScientificText(String UNIT, int PRECISION, double VALUE) {
        String formatedResult;
        int precision = PRECISION < 0 ? 0 : PRECISION;
        String format = "%." + precision + "f";
        String formatAlt = "%." + precision + "e";
        double[] divisor = new double[]{100.0, 10.0, 1000.0, 100.0, 10.0};
        String[] PREFIX = new String[]{" y", " y", " y", " z", " z", " z", " a", " a", " a", " t", "  t", " t", " f", " f", " f", " n", " n", " n", " \u00b5", " \u00b5", " \u00b5", " m", " m", " m", " ", " ", " ", " k", " k", " k", " M", " M", " M", " G", " G", " G", " T", " T", " T", " P", " P", " P", " E", " E", " E", " Z", " Z", " Z", " Y", " Y", " Y"};
        if (VALUE != 0.0) {
            double y = VALUE < 0.0 ? Math.log10(-VALUE) : Math.log10(VALUE);
            int decade = (int)Math.round(y);
            double m = y - (double)decade;
            double mantisse = 1000.0 * Math.pow(10.0, m);
            int deca = decade % 3 + 2;
            formatedResult = decade >= -24 && decade <= 24 ? String.format(format, mantisse) + PREFIX[decade + 24] + UNIT : String.format(formatAlt, mantisse /= divisor[deca]);
        } else {
            formatedResult = "0" + UNIT;
        }
        if (VALUE < 0.0) {
            formatedResult = '-' + formatedResult;
        }
        return formatedResult;
    }

    static {
        $VALUES = new Util[]{INSTANCE};
    }
}

