/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.GetConfigValueConsumer;
import com.rusefi.output.HashUtil;
import com.rusefi.output.PerFieldWithStructuresIterator;
import com.rusefi.output.variables.VariableRecord;
import com.rusefi.parse.TypesHelper;
import com.rusefi.util.LazyFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GetOutputValueConsumer
implements ConfigurationConsumer {
    private final List<VariableRecord> getterPairs = new ArrayList<VariableRecord>();
    private final String fileName;
    private final LazyFile.LazyFileFactory fileFactory;
    public String currentSectionPrefix = "engine->outputChannels";
    public boolean moduleMode;
    public String currentEngineModule;
    public String conditional;
    public Boolean isPtr = false;

    public GetOutputValueConsumer(String fileName, LazyFile.LazyFileFactory fileFactory) {
        this.fileName = fileName;
        this.fileFactory = fileFactory;
    }

    @Override
    public void handleEndStruct(ReaderState state, ConfigStructure structure) throws IOException {
        if (state.isStackEmpty()) {
            PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(state, structure.getTsFields(), "", (readerState, cf, prefix) -> this.processOutput(cf, prefix), ".");
            iterator.loop();
        }
    }

    private String processOutput(ConfigField cf, String prefix) {
        if (cf.getName().contains("unused") || cf.getName().contains("alignmentFill_at_")) {
            return "";
        }
        if (cf.isArray() || cf.isFromIterate() || cf.isDirective()) {
            return "";
        }
        if (!TypesHelper.isPrimitive(cf.getTypeName()) && !TypesHelper.isBoolean(cf.getTypeName())) {
            return "";
        }
        String userName = prefix + cf.getName();
        String javaName = this.moduleMode ? "engine->module<" + this.currentEngineModule + ">()->" + prefix : this.currentSectionPrefix + (this.isPtr != false ? "->" : ".") + prefix;
        this.getterPairs.add(new VariableRecord(userName, javaName + cf.getName(), null, this.conditional));
        return "";
    }

    @Override
    public void endFile() throws IOException {
        GetConfigValueConsumer.writeStringToFile(this.fileName, this.getContent(), this.fileFactory);
    }

    public String getContent() {
        StringBuilder switchBody = new StringBuilder();
        StringBuilder getterBody = GetOutputValueConsumer.getGetters(switchBody, this.getterPairs);
        String fullSwitch = GetOutputValueConsumer.wrapSwitchStatement(switchBody);
        return "#if !EFI_UNIT_TEST\n" + GetConfigValueConsumer.getHeader(this.getClass()) + "float getOutputValueByName(const char *name) {\n" + fullSwitch + getterBody + "\treturn EFI_ERROR_CODE;\n}\n#endif\n";
    }

    @NotNull
    static String wrapSwitchStatement(StringBuilder switchBody) {
        Object fullSwitch = switchBody.length() == 0 ? "" : "\tint hash = djb2lowerCase(name);\n\tswitch(hash) {\n" + switchBody + "\t}\n";
        return fullSwitch;
    }

    @NotNull
    static StringBuilder getGetters(StringBuilder switchBody, List<VariableRecord> getterPairs) {
        HashMap<Integer, AtomicInteger> hashConflicts = GetOutputValueConsumer.getHashConflicts(getterPairs);
        StringBuilder getterBody = new StringBuilder();
        for (VariableRecord pair : getterPairs) {
            String returnLine = "\t\treturn " + pair.getFullName() + ";\n";
            String conditional = pair.getConditional();
            Object before = conditional == null ? "" : "#if " + conditional + "\n";
            String after = conditional == null ? "" : "#endif\n";
            int hash = HashUtil.hash(pair.getUserName());
            if (hashConflicts.get(hash).get() == 1) {
                switchBody.append("// " + pair.getUserName() + "\n");
                switchBody.append((String)before);
                switchBody.append("\t\tcase " + hash + ":\n");
                switchBody.append("\t" + returnLine);
                switchBody.append(after);
                continue;
            }
            getterBody.append(GetConfigValueConsumer.getCompareName(pair.getUserName()));
            getterBody.append(returnLine);
        }
        return getterBody;
    }

    @NotNull
    static HashMap<Integer, AtomicInteger> getHashConflicts(List<VariableRecord> getterPairs) {
        HashMap<Integer, AtomicInteger> hashConflicts = new HashMap<Integer, AtomicInteger>();
        for (VariableRecord pair : getterPairs) {
            hashConflicts.computeIfAbsent(HashUtil.hash(pair.getUserName()), integer -> new AtomicInteger(0)).incrementAndGet();
        }
        return hashConflicts;
    }
}

