/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.platform.linux;

import java.io.IOException;

public class LinuxNativeOperationException
extends IOException {
    public static final int EBADF = 9;
    public static final int EAGAIN = 11;
    public static final int ENODEV = 19;
    private final int errorNumber;
    private final String errorString;

    public LinuxNativeOperationException(String message, int errorNumber, String errorString) {
        super(LinuxNativeOperationException.makeSuperMessage(message, errorNumber, errorString));
        this.errorNumber = errorNumber;
        this.errorString = errorString;
    }

    private static String makeSuperMessage(String message, int errorNumber, String errorString) {
        if (errorNumber == 0) {
            return message;
        }
        return message + " - errorNumber=" + errorNumber + ", errorMessage='" + errorString + '\'';
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public boolean isBadFD() {
        return this.getErrorNumber() == 9;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public boolean mayTryAgain() {
        if (this.errorNumber == 0) {
            return false;
        }
        return this.isTemporary();
    }

    private boolean isTemporary() {
        switch (this.errorNumber) {
            case 11: {
                return true;
            }
        }
        return false;
    }
}

