/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.BackgroundImageFactory;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.DesignSet;
import eu.hansolo.steelseries.tools.DisabledImageFactory;
import eu.hansolo.steelseries.tools.ForegroundImageFactory;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.FrameImageFactory;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.KnobImageFactory;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LcdImageFactory;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.LedImageFactory;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerImageFactory;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.ThresholdType;
import eu.hansolo.steelseries.tools.TickmarkImageFactory;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractGauge
extends JComponent
implements ComponentListener,
ActionListener,
Serializable {
    private static final long serialVersionUID = 31269L;
    public static final String VALUE_PROPERTY = "value";
    private PropertyChangeSupport propertyChangeSupport;
    protected static final Util UTIL = Util.INSTANCE;
    protected static final FrameImageFactory FRAME_FACTORY = FrameImageFactory.INSTANCE;
    protected static final BackgroundImageFactory BACKGROUND_FACTORY = BackgroundImageFactory.INSTANCE;
    protected static final GlowImageFactory GLOW_FACTORY = GlowImageFactory.INSTANCE;
    protected static final TickmarkImageFactory TICKMARK_FACTORY = TickmarkImageFactory.INSTANCE;
    protected static final LcdImageFactory LCD_FACTORY = LcdImageFactory.INSTANCE;
    protected static final LedImageFactory LED_FACTORY = LedImageFactory.INSTANCE;
    protected static final KnobImageFactory KNOB_FACTORY = KnobImageFactory.INSTANCE;
    protected static final PointerImageFactory POINTER_FACTORY = PointerImageFactory.INSTANCE;
    protected static final ForegroundImageFactory FOREGROUND_FACTORY = ForegroundImageFactory.INSTANCE;
    protected static final DisabledImageFactory DISABLED_FACTORY = DisabledImageFactory.INSTANCE;
    private boolean initialized = false;
    private volatile Model model;
    private DesignSet design1;
    private DesignSet design2;
    private DesignSet activeDesign;
    private ChangeEvent changeEvent;
    private final EventListenerList LISTENER_LIST = new EventListenerList();
    protected static final String THRESHOLD_PROPERTY = "threshold";
    private final Timer GLOW_PULSE;
    private float glowAlpha = 1.0f;
    private double glowAlphaIncrement = -0.1;
    private double glowAlphaCounter = 1.0;
    private BufferedImage ledImageOff;
    private BufferedImage ledImageOn;
    private BufferedImage currentLedImage;
    private final Timer LED_BLINKING_TIMER;
    private boolean ledBlinking = false;
    private boolean ledOn = false;
    private BufferedImage userLedImageOff;
    private BufferedImage userLedImageOn;
    private BufferedImage currentUserLedImage;
    private final Timer USER_LED_BLINKING_TIMER;
    private boolean userLedBlinking = false;
    private boolean userLedOn = false;
    private final Timer PEAK_TIMER;
    private boolean customTickmarkLabelsEnabled = false;
    private ArrayList<Double> customTickmarkLabels;
    private String title = "Title";
    private String unitString = "unit";
    private Font titleAndUnitFont;
    private long stdTimeToValue = 800L;
    private long rtzTimeToValue = 800L;
    private long rtzTimeBackToZero = 1200L;
    private Orientation orientation;

    public AbstractGauge() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.model = new Model();
        this.design1 = new DesignSet.Builder().frameDesign(FrameDesign.METAL).frameEffect(FrameEffect.NONE).backgroundColor(BackgroundColor.DARK_GRAY).textureColor(new Color(0x686868)).color(ColorDef.RED).ledColor(LedColor.RED_LED).userLedColor(LedColor.RED_LED).lcdColor(LcdColor.STANDARD_LCD).glowColor(new Color(51, 255, 255)).build();
        this.design2 = new DesignSet.Builder().frameDesign(FrameDesign.METAL).frameEffect(FrameEffect.NONE).backgroundColor(BackgroundColor.WHITE).textureColor(new Color(0xC3C3C3)).color(ColorDef.RED).ledColor(LedColor.RED_LED).userLedColor(LedColor.RED_LED).lcdColor(LcdColor.STANDARD_LCD).glowColor(new Color(51, 255, 255)).build();
        this.activeDesign = this.design1;
        this.GLOW_PULSE = new Timer(50, this);
        this.ledImageOff = this.create_LED_Image(200, 0, this.model.getLedColor());
        this.ledImageOn = this.create_LED_Image(200, 1, this.model.getLedColor());
        this.currentLedImage = this.ledImageOff;
        this.LED_BLINKING_TIMER = new Timer(500, this);
        this.userLedImageOff = this.create_LED_Image(200, 0, this.model.getLedColor());
        this.userLedImageOn = this.create_LED_Image(200, 1, this.model.getLedColor());
        this.currentUserLedImage = this.userLedImageOff;
        this.USER_LED_BLINKING_TIMER = new Timer(500, this);
        this.PEAK_TIMER = new Timer(1000, this);
        this.customTickmarkLabels = new ArrayList(10);
        this.titleAndUnitFont = new Font("Verdana", 0, 10);
        this.orientation = Orientation.NORTH;
        this.addComponentListener(this);
    }

    public abstract AbstractGauge init(int var1, int var2);

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean INITIALIZED) {
        this.initialized = INITIALIZED;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model MODEL) {
        this.model = MODEL;
        this.reInitialize();
    }

    public double getValue() {
        return this.model.getValue();
    }

    public void setValue(double VALUE) {
        if (this.isEnabled()) {
            if (!this.isLogScale()) {
                this.model.setValue(VALUE);
            } else if (VALUE > 0.0) {
                this.model.setValue(VALUE);
            } else {
                this.model.setValue(1.0);
            }
            if (!this.isAutoResetToZero()) {
                if (!this.model.isThresholdBehaviourInverted()) {
                    if (Double.compare(this.model.getValue(), this.model.getThreshold()) >= 0) {
                        if (!this.LED_BLINKING_TIMER.isRunning()) {
                            this.LED_BLINKING_TIMER.start();
                            this.propertyChangeSupport.firePropertyChange(THRESHOLD_PROPERTY, false, true);
                        }
                    } else {
                        this.LED_BLINKING_TIMER.stop();
                        this.setCurrentLedImage(this.getLedImageOff());
                    }
                } else if (Double.compare(this.model.getValue(), this.model.getThreshold()) <= 0) {
                    if (!this.LED_BLINKING_TIMER.isRunning()) {
                        this.LED_BLINKING_TIMER.start();
                        this.propertyChangeSupport.firePropertyChange(THRESHOLD_PROPERTY, false, true);
                    }
                } else {
                    this.LED_BLINKING_TIMER.stop();
                    this.setCurrentLedImage(this.getLedImageOff());
                }
            }
            if (this.model.getValue() > this.model.getOldValue() + this.model.getRange() * this.model.getRedrawFactor() || this.model.getValue() < this.model.getOldValue() - this.model.getRange() * this.model.getRedrawFactor()) {
                this.repaint(this.getInnerBounds());
            }
            this.fireStateChanged();
            this.propertyChangeSupport.firePropertyChange(VALUE_PROPERTY, this.model.getOldValue(), this.model.getValue());
        }
    }

    public double getMinValue() {
        return this.model.getNiceMinValue();
    }

    public void setMinValue(double MIN_VALUE) {
        this.model.setMinValue(MIN_VALUE);
        this.reInitialize();
    }

    public double getMaxValue() {
        return this.model.getNiceMaxValue();
    }

    public void setMaxValue(double MAX_VALUE) {
        this.model.setMaxValue(MAX_VALUE);
        this.reInitialize();
    }

    public double getPeakValue() {
        return this.model.getPeakValue();
    }

    public void setPeakValue(double PEAK_VALUE) {
        this.model.setPeakValue(PEAK_VALUE);
    }

    public boolean isPeakValueVisible() {
        return this.model.isPeakValueVisible();
    }

    public void setPeakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        this.model.setPeakValueVisible(PEAK_VALUE_VISIBLE);
    }

    public boolean isAutoResetToZero() {
        return this.model.isAutoResetToZero();
    }

    public void setAutoResetToZero(boolean AUTO_RESET_TO_ZERO) {
        this.model.setAutoResetToZero(AUTO_RESET_TO_ZERO);
        if (this.model.isAutoResetToZero()) {
            this.setThresholdVisible(false);
            this.setLedVisible(false);
        }
    }

    public double getThreshold() {
        return this.model.getThreshold();
    }

    public void setThreshold(double THRESHOLD) {
        this.model.setThreshold(THRESHOLD);
        this.repaint(this.getInnerBounds());
    }

    public boolean isThresholdVisible() {
        return this.model.isThresholdVisible();
    }

    public void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.model.setThresholdVisible(THRESHOLD_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    public boolean isThresholdBehaviourInverted() {
        return this.model.isThresholdBehaviourInverted();
    }

    public void setThresholdBehaviourInverted(boolean THRESHOLD_BEHAVIOUR_INVERTED) {
        this.model.setThresholdBehaviourInverted(THRESHOLD_BEHAVIOUR_INVERTED);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLedVisible() {
        return this.model.isLedVisible();
    }

    public void setLedVisible(boolean LED_VISIBLE) {
        this.model.setLedVisible(LED_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    public boolean isUserLedVisible() {
        return this.model.isUserLedVisible();
    }

    public void setUserLedVisible(boolean USER_LED_VISIBLE) {
        this.model.setUserLedVisible(USER_LED_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    public DesignSet getDesign1() {
        return this.design1;
    }

    public void setDesign1(DesignSet DESIGN1) {
        this.design1 = DESIGN1;
    }

    public DesignSet getDesign2() {
        return this.design2;
    }

    public void setDesign2(DesignSet DESIGN2) {
        this.design2 = DESIGN2;
    }

    public DesignSet getActiveDesign() {
        return this.activeDesign;
    }

    public void setActiveDesign(DesignSet DESIGN_SET) {
        this.activeDesign = DESIGN_SET;
        if (DESIGN_SET.getOuterFrameColor() != null) {
            this.model.setOuterFrameColor(DESIGN_SET.getOuterFrameColor());
        }
        if (DESIGN_SET.getInnerFrameColor() != null) {
            this.model.setInnerFrameColor(DESIGN_SET.getInnerFrameColor());
        }
        if (DESIGN_SET.getFrameDesign() != null) {
            this.model.setFrameDesign(DESIGN_SET.getFrameDesign());
        }
        if (DESIGN_SET.getFrameEffect() != null) {
            this.model.setFrameEffect(DESIGN_SET.getFrameEffect());
        }
        if (DESIGN_SET.getTextureColor() != null) {
            this.model.setTextureColor(DESIGN_SET.getTextureColor());
        }
        if (DESIGN_SET.getBackgroundColor() != null) {
            this.model.setBackgroundColor(DESIGN_SET.getBackgroundColor());
        }
        if (DESIGN_SET.getColor() != null) {
            this.model.setPointerColor(DESIGN_SET.getColor());
            this.model.setValueColor(DESIGN_SET.getColor());
        }
        if (DESIGN_SET.getLedColor() != null) {
            this.model.setLedColor(DESIGN_SET.getLedColor());
            boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.recreateLedImages(this.getHeight());
                    break;
                }
                case VERTICAL: {
                    this.recreateLedImages(this.getWidth());
                    break;
                }
                default: {
                    this.recreateLedImages();
                }
            }
            if (this.currentLedImage != null) {
                this.currentLedImage.flush();
            }
            BufferedImage bufferedImage = this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        }
        if (DESIGN_SET.getUserLedColor() != null) {
            this.model.setUserLedColor(DESIGN_SET.getUserLedColor());
            boolean USER_LED_WAS_ON = this.currentUserLedImage.equals(this.userLedImageOn);
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    this.recreateUserLedImages(this.getHeight());
                    break;
                }
                case VERTICAL: {
                    this.recreateUserLedImages(this.getWidth());
                    break;
                }
                default: {
                    this.recreateUserLedImages();
                }
            }
            if (this.currentUserLedImage != null) {
                this.currentUserLedImage.flush();
            }
            BufferedImage bufferedImage = this.currentUserLedImage = USER_LED_WAS_ON ? this.userLedImageOn : this.userLedImageOff;
        }
        if (DESIGN_SET.getLcdColor() != null) {
            this.model.setLcdColor(DESIGN_SET.getLcdColor());
        }
        if (DESIGN_SET.getGlowColor() != null) {
            this.model.setGlowColor(DESIGN_SET.getGlowColor());
        }
        if (DESIGN_SET.getColor() != null) {
            this.model.setPointerColor(DESIGN_SET.getColor());
        }
        if (DESIGN_SET.getKnobStyle() != null) {
            this.model.setKnobStyle(DESIGN_SET.getKnobStyle());
        }
        if (DESIGN_SET.getColor() != null) {
            this.model.setValueColor(DESIGN_SET.getColor());
        }
        this.reInitialize();
    }

    abstract void toggleDesign();

    abstract Point2D getLedPosition();

    abstract void setLedPosition(double var1, double var3);

    abstract Point2D getUserLedPosition();

    abstract void setUserLedPosition(double var1, double var3);

    public LedColor getLedColor() {
        return this.model.getLedColor();
    }

    public void setLedColor(LedColor LED_COLOR) {
        this.model.setLedColor(LED_COLOR);
        boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateLedImages();
            }
        }
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomLedColor() {
        return this.model.getCustomLedColor().COLOR;
    }

    public void setCustomLedColor(Color COLOR) {
        this.model.setCustomLedColor(new CustomLedColor(COLOR));
        boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateLedImages();
            }
        }
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        this.repaint(this.getInnerBounds());
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean LED_BLINKING) {
        this.ledBlinking = LED_BLINKING;
        if (LED_BLINKING) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    protected BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    protected void recreateLedImages() {
        this.recreateLedImages(this.getInnerBounds().width);
    }

    protected void recreateLedImages(int SIZE) {
        if (this.ledImageOff != null) {
            this.ledImageOff.flush();
        }
        this.ledImageOff = this.create_LED_Image(SIZE, 0, this.model.getLedColor());
        if (this.ledImageOn != null) {
            this.ledImageOn.flush();
        }
        this.ledImageOn = this.create_LED_Image(SIZE, 1, this.model.getLedColor());
    }

    protected BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    protected void setCurrentLedImage(BufferedImage CURRENT_LED_IMAGE) {
        if (this.currentLedImage != null) {
            this.currentLedImage.flush();
        }
        this.currentLedImage = CURRENT_LED_IMAGE;
        this.repaint(this.getInnerBounds());
    }

    protected boolean isLedOn() {
        return this.ledOn;
    }

    public LedColor getUserLedColor() {
        return this.model.getUserLedColor();
    }

    public void setUserLedColor(LedColor LED_COLOR) {
        this.model.setUserLedColor(LED_COLOR);
        boolean LED_WAS_ON = this.currentUserLedImage.equals(this.userLedImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateUserLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateUserLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateUserLedImages();
            }
        }
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = LED_WAS_ON ? this.userLedImageOn : this.userLedImageOff;
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomUserLedColor() {
        return this.model.getCustomUserLedColor().COLOR;
    }

    public void setCustomUserLedColor(Color COLOR) {
        this.model.setCustomUserLedColor(new CustomLedColor(COLOR));
        boolean LED_WAS_ON = this.currentUserLedImage.equals(this.ledImageOn);
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                this.recreateUserLedImages(this.getHeight());
                break;
            }
            case VERTICAL: {
                this.recreateUserLedImages(this.getWidth());
                break;
            }
            default: {
                this.recreateUserLedImages();
            }
        }
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = LED_WAS_ON ? this.userLedImageOn : this.userLedImageOff;
        this.repaint(this.getInnerBounds());
    }

    public boolean isUserLedBlinking() {
        return this.userLedBlinking;
    }

    public void setUserLedBlinking(boolean USER_LED_BLINKING) {
        this.userLedBlinking = USER_LED_BLINKING;
        if (USER_LED_BLINKING) {
            this.USER_LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentUserLedImage(this.getUserLedImageOff());
            this.USER_LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getUserLedImageOn() {
        return this.userLedImageOn;
    }

    protected BufferedImage getUserLedImageOff() {
        return this.userLedImageOff;
    }

    protected void recreateUserLedImages() {
        this.recreateUserLedImages(this.getInnerBounds().width);
    }

    protected void recreateUserLedImages(int SIZE) {
        if (this.userLedImageOff != null) {
            this.userLedImageOff.flush();
        }
        this.userLedImageOff = this.create_LED_Image(SIZE, 0, this.model.getUserLedColor());
        if (this.userLedImageOn != null) {
            this.userLedImageOn.flush();
        }
        this.userLedImageOn = this.create_LED_Image(SIZE, 1, this.model.getUserLedColor());
    }

    protected BufferedImage getCurrentUserLedImage() {
        return this.currentUserLedImage;
    }

    protected void setCurrentUserLedImage(BufferedImage CURRENT_USER_LED_IMAGE) {
        if (this.currentUserLedImage != null) {
            this.currentUserLedImage.flush();
        }
        this.currentUserLedImage = CURRENT_USER_LED_IMAGE;
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public boolean isUserLedOn() {
        return this.userLedOn;
    }

    public void setUserLedOn(boolean USER_LED_ON) {
        this.userLedOn = USER_LED_ON;
        if (this.userLedOn) {
            this.setCurrentUserLedImage(this.userLedImageOn);
        } else {
            this.setCurrentUserLedImage(this.userLedImageOff);
        }
    }

    public double getMinMeasuredValue() {
        return this.model.getMinMeasuredValue();
    }

    protected void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.model.setMinMeasuredValue(MIN_MEASURED_VALUE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public boolean isMinMeasuredValueVisible() {
        return this.model.isMinMeasuredValueVisible();
    }

    public void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.model.setMinMeasuredValueVisible(MIN_MEASURED_VALUE_VISIBLE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public void resetMinMeasuredValue() {
        this.model.resetMinMeasuredValue();
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public void resetMinMeasuredValue(double VALUE) {
        this.model.resetMinMeasuredValue(VALUE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public double getMaxMeasuredValue() {
        return this.model.getMaxMeasuredValue();
    }

    protected void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.model.setMaxMeasuredValue(MAX_MEASURED_VALUE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.model.isMaxMeasuredValueVisible();
    }

    public void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.model.setMaxMeasuredValueVisible(MAX_MEASURED_VALUE_VISIBLE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public void resetMaxMeasuredValue() {
        this.model.resetMaxMeasuredValue();
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public void resetMaxMeasuredValue(double VALUE) {
        this.model.resetMaxMeasuredValue(VALUE);
        SwingUtilities.invokeLater(() -> this.repaint(this.getInnerBounds()));
    }

    public long getStdTimeToValue() {
        return this.stdTimeToValue;
    }

    public void setStdTimeToValue(long STD_TIME_TO_VALUE) {
        this.stdTimeToValue = STD_TIME_TO_VALUE < 250L ? 250L : (STD_TIME_TO_VALUE > 5000L ? 5000L : STD_TIME_TO_VALUE);
    }

    public long getRtzTimeToValue() {
        return this.rtzTimeToValue;
    }

    public void setRtzTimeToValue(long RTZ_TIME_TO_VALUE) {
        this.rtzTimeToValue = RTZ_TIME_TO_VALUE < 250L ? 250L : (RTZ_TIME_TO_VALUE > 5000L ? 5000L : RTZ_TIME_TO_VALUE);
    }

    public long getRtzTimeBackToZero() {
        return this.rtzTimeBackToZero;
    }

    public void setRtzTimeBackToZero(long RTZ_TIME_BACK_TO_ZERO) {
        this.rtzTimeBackToZero = RTZ_TIME_BACK_TO_ZERO < 250L ? 250L : (RTZ_TIME_BACK_TO_ZERO > 5000L ? 5000L : RTZ_TIME_BACK_TO_ZERO);
    }

    public Timer getPeakTimer() {
        return this.PEAK_TIMER;
    }

    public void startPeakTimer() {
        if (!this.PEAK_TIMER.isRunning()) {
            this.PEAK_TIMER.start();
        }
    }

    public void stopPeakTimer() {
        if (this.PEAK_TIMER.isRunning()) {
            this.PEAK_TIMER.stop();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation ORIENTATION) {
        this.orientation = ORIENTATION;
        this.reInitialize();
    }

    public ColorDef getThresholdColor() {
        return this.model.getThresholdColor();
    }

    public void setThresholdColor(ColorDef THRESHOLD_COLOR) {
        this.model.setThresholdColor(THRESHOLD_COLOR);
        this.reInitialize();
    }

    public CustomColorDef getCustomThresholdColor() {
        return this.model.getCustomThresholdColor();
    }

    public void setCustomThresholdColor(CustomColorDef CUSTOM_THRESHOLD_COLOR) {
        this.model.setCustomThresholdColor(CUSTOM_THRESHOLD_COLOR);
        this.reInitialize();
    }

    public ThresholdType getThresholdType() {
        return this.model.getThresholdType();
    }

    public void setThresholdType(ThresholdType THRESHOLD_TYPE) {
        this.model.setThresholdType(THRESHOLD_TYPE);
        this.reInitialize();
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    public boolean isTickmarkColorFromThemeEnabled() {
        return this.model.isTickmarkColorFromThemeEnabled();
    }

    public void setTickmarkColorFromThemeEnabled(boolean TICKMARK_COLOR_FROM_THEME_ENABLED) {
        this.model.setTickmarkColorFromThemeEnabled(TICKMARK_COLOR_FROM_THEME_ENABLED);
        this.reInitialize();
    }

    public Color getTickmarkColor() {
        return this.model.getTickmarkColor();
    }

    public void setTickmarkColor(Color TICKMARK_COLOR) {
        this.model.setTickmarkColor(TICKMARK_COLOR);
        this.reInitialize();
    }

    public boolean isTickmarksVisible() {
        return this.model.isTickmarksVisible();
    }

    public void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.model.setTickmarksVisible(TICKMARKS_VISIBLE);
        this.reInitialize();
    }

    public boolean isTicklabelsVisible() {
        return this.model.isTicklabelsVisible();
    }

    public void setTicklabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.model.setTicklabelsVisible(TICKLABELS_VISIBLE);
        this.reInitialize();
    }

    public NumberFormat getLabelNumberFormat() {
        return this.model.getLabelNumberFormat();
    }

    public void setLabelNumberFormat(NumberFormat NUMBER_FORMAT) {
        this.model.setLabelNumberFormat(NUMBER_FORMAT);
        this.reInitialize();
    }

    public boolean isCustomTickmarkLabelsEnabled() {
        return this.customTickmarkLabelsEnabled;
    }

    public void setCustomTickmarkLabelsEnabled(boolean CUSTOM_TICKMARK_LABELS_ENABLED) {
        this.customTickmarkLabelsEnabled = CUSTOM_TICKMARK_LABELS_ENABLED;
        this.reInitialize();
    }

    public List<Double> getCustomTickmarkLabels() {
        ArrayList<Double> customTickmarkLabelsCopy = new ArrayList<Double>(10);
        customTickmarkLabelsCopy.addAll(this.customTickmarkLabels);
        return customTickmarkLabelsCopy;
    }

    public void setCustomTickmarkLabels(double ... CUSTOM_TICKMARK_LABELS_ARRAY) {
        this.customTickmarkLabels.clear();
        double[] dArray = CUSTOM_TICKMARK_LABELS_ARRAY;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double label = dArray[i];
            this.customTickmarkLabels.add(label);
        }
        this.reInitialize();
    }

    public void addCustomTickmarkLabel(double CUSTOM_TICKMARK_LABEL) {
        this.customTickmarkLabels.add(CUSTOM_TICKMARK_LABEL);
        this.reInitialize();
    }

    public void resetCustomTickmarkLabels() {
        this.customTickmarkLabels.clear();
        this.reInitialize();
    }

    public List<Section> getTickmarkSections() {
        return this.model.getTickmarkSections();
    }

    public void setTickmarkSections(Section ... TICKMARK_SECTIONS_ARRAY) {
        this.model.setTickmarkSections(TICKMARK_SECTIONS_ARRAY);
        this.reInitialize();
    }

    public void addTickmarkSection(Section TICKMARK_SECTION) {
        this.model.addTickmarkSection(TICKMARK_SECTION);
        this.reInitialize();
    }

    public void resetTickmarkSections() {
        this.model.resetTickmarkSections();
        this.reInitialize();
    }

    public boolean isTickmarkSectionsVisible() {
        return this.model.isTickmarkSectionsVisible();
    }

    public void setTickmarkSectionsVisible(boolean TICKMARK_SECTIONS_VISIBLE) {
        this.model.setTickmarkSectionsVisible(TICKMARK_SECTIONS_VISIBLE);
        this.reInitialize();
    }

    public TickmarkType getMinorTickmarkType() {
        return this.model.getMinorTickmarkType();
    }

    public void setMinorTickmarkType(TickmarkType TICKMARK_TYPE) {
        this.model.setMinorTickmarkType(TICKMARK_TYPE);
        this.reInitialize();
    }

    public TickmarkType getMajorTickmarkType() {
        return this.model.getMajorTickmarkType();
    }

    public void setMajorTickmarkType(TickmarkType TICKMARK_TYPE) {
        this.model.setMajorTickmarkType(TICKMARK_TYPE);
        this.reInitialize();
    }

    public boolean isMinorTickmarkVisible() {
        return this.model.isMinorTickmarksVisible();
    }

    public void setMinorTickmarkVisible(boolean MINOR_TICKMARK_VISIBLE) {
        this.model.setMinorTickmarksVisible(MINOR_TICKMARK_VISIBLE);
        this.reInitialize();
    }

    public boolean isMajorTickmarkVisible() {
        return this.model.isMajorTickmarksVisible();
    }

    public void setMajorTickmarkVisible(boolean MAJOR_TICKMARK_VISIBLE) {
        this.model.setMajorTickmarksVisible(MAJOR_TICKMARK_VISIBLE);
        this.reInitialize();
    }

    public boolean isSectionTickmarksOnly() {
        return this.model.isSectionTickmarksOnly();
    }

    public void setSectionTickmarksOnly(boolean SECTION_TICKMARKS_ONLY) {
        this.model.setSectionTickmarksOnly(SECTION_TICKMARKS_ONLY);
        this.reInitialize();
    }

    public boolean isNiceScale() {
        return this.model.isNiceScale();
    }

    public void setNiceScale(boolean NICE_SCALE) {
        this.model.setNiceScale(NICE_SCALE);
        this.reInitialize();
    }

    public boolean isLogScale() {
        return this.model.isLogScale();
    }

    public void setLogScale(boolean LOG_SCALE) {
        this.model.setLogScale(LOG_SCALE);
        this.model.setMinValue(0.0);
        this.model.setLabelNumberFormat(NumberFormat.SCIENTIFIC);
        this.reInitialize();
    }

    public double getMinorTickSpacing() {
        return this.model.getMinorTickSpacing();
    }

    public void setMinorTickSpacing(double MINOR_TICKSPACING) {
        this.model.setMinorTickSpacing(MINOR_TICKSPACING);
        this.reInitialize();
    }

    public double getMajorTickSpacing() {
        return this.model.getMajorTickSpacing();
    }

    public void setMajorTickSpacing(double MAJOR_TICKSPACING) {
        this.model.setMajorTickSpacing(MAJOR_TICKSPACING);
        this.reInitialize();
    }

    public boolean isTrackVisible() {
        return this.model.isTrackVisible();
    }

    public void setTrackVisible(boolean TRACK_VISIBLE) {
        this.model.setTrackVisible(TRACK_VISIBLE);
        this.reInitialize();
    }

    public double getTrackStart() {
        return this.model.getTrackStart();
    }

    public void setTrackStart(double TRACK_START) {
        this.model.setTrackStart(TRACK_START);
        this.reInitialize();
    }

    public double getTrackSection() {
        return this.model.getTrackSection();
    }

    public void setTrackSection(double TRACK_SECTION) {
        this.model.setTrackSection(TRACK_SECTION);
        this.reInitialize();
    }

    public double getTrackStop() {
        return this.model.getTrackStop();
    }

    public void setTrackStop(double TRACK_STOP) {
        this.model.setTrackStop(TRACK_STOP);
        this.reInitialize();
    }

    public Color getTrackStartColor() {
        return this.model.getTrackStartColor();
    }

    public void setTrackStartColor(Color TRACK_START_COLOR) {
        this.model.setTrackStartColor(TRACK_START_COLOR);
        this.reInitialize();
    }

    public Color getTrackSectionColor() {
        return this.model.getTrackSectionColor();
    }

    public void setTrackSectionColor(Color TRACK_SECTION_COLOR) {
        this.model.setTrackSectionColor(TRACK_SECTION_COLOR);
        this.reInitialize();
    }

    public Color getTrackStopColor() {
        return this.model.getTrackStopColor();
    }

    public void setTrackStopColor(Color TRACK_STOP_COLOR) {
        this.model.setTrackStopColor(TRACK_STOP_COLOR);
        this.reInitialize();
    }

    public boolean isSectionsVisible() {
        return this.model.isSectionsVisible();
    }

    public void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.model.setSectionsVisible(SECTIONS_VISIBLE);
        this.reInitialize();
    }

    public boolean isHighlightSection() {
        return this.getModel().isHighlightSection();
    }

    public void setHighlightSection(boolean HIGHLIGHT_SECTION) {
        this.getModel().setHighlightSection(HIGHLIGHT_SECTION);
        this.reInitialize();
    }

    public List<Section> getSections() {
        return this.model.getSections();
    }

    public void setSections(Section ... SECTIONS_ARRAY) {
        this.model.setSections(SECTIONS_ARRAY);
        this.reInitialize();
    }

    public void addSection(Section SECTION) {
        this.model.addSection(SECTION);
        this.reInitialize();
    }

    public void resetSections() {
        this.model.resetSections();
        this.reInitialize();
    }

    public boolean isAreasVisible() {
        return this.model.isAreasVisible();
    }

    public void setAreasVisible(boolean AREAS_VISIBLE) {
        this.model.setAreasVisible(AREAS_VISIBLE);
        this.reInitialize();
    }

    public boolean isHighlightArea() {
        return this.getModel().isHighlightArea();
    }

    public void setHighlightArea(boolean HIGHLIGHT_AREA) {
        this.getModel().setHighlightArea(HIGHLIGHT_AREA);
        this.reInitialize();
    }

    public List<Section> getAreas() {
        return this.model.getAreas();
    }

    public void setAreas(Section ... AREAS_ARRAY) {
        this.model.setAreas(AREAS_ARRAY);
        this.reInitialize();
    }

    public void addArea(Section AREA) {
        this.model.addArea(AREA);
        this.reInitialize();
    }

    public void resetAreas() {
        this.model.resetAreas();
        this.reInitialize();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String TITLE) {
        this.title = TITLE;
        this.reInitialize();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String UNIT_STRING) {
        this.unitString = UNIT_STRING;
        this.reInitialize();
    }

    public boolean isLabelColorFromThemeEnabled() {
        return this.model.isLabelColorFromThemeEnabled();
    }

    public void setLabelColorFromThemeEnabled(boolean LABEL_COLOR_FROM_THEME_ENABLED) {
        this.model.setLabelColorFromThemeEnabled(LABEL_COLOR_FROM_THEME_ENABLED);
        this.reInitialize();
    }

    public Color getLabelColor() {
        return this.model.getLabelColor();
    }

    public void setLabelColor(Color LABEL_COLOR) {
        this.model.setLabelColor(LABEL_COLOR);
        this.reInitialize();
    }

    public boolean isTitleAndUnitFontEnabled() {
        return this.model.isCustomTitleAndUnitFontEnabled();
    }

    public void setTitleAndUnitFontEnabled(boolean TITLE_AND_UNIT_FONT_ENABLED) {
        this.model.setCustomTitleAndUnitFontEnabled(TITLE_AND_UNIT_FONT_ENABLED);
        this.reInitialize();
    }

    public Font getTitleAndUnitFont() {
        return this.titleAndUnitFont;
    }

    public void setTitleAndUnitFont(Font TITLE_UNIT_FONT) {
        this.titleAndUnitFont = TITLE_UNIT_FONT;
        this.reInitialize();
    }

    public FrameDesign getFrameDesign() {
        return this.model.getFrameDesign();
    }

    public void setFrameDesign(FrameDesign FRAME_DESIGN) {
        this.model.setFrameDesign(FRAME_DESIGN);
        this.reInitialize();
    }

    public Paint getCustomFrameDesign() {
        return this.model.getCustomFrameDesign();
    }

    public void setCustomFrameDesign(Paint CUSTOM_FRAME_DESIGN) {
        this.model.setCustomFrameDesign(CUSTOM_FRAME_DESIGN);
        this.reInitialize();
    }

    public boolean isFrameVisible() {
        return this.model.isFrameVisible();
    }

    public void setFrameVisible(boolean FRAME_VISIBLE) {
        this.model.setFrameVisible(FRAME_VISIBLE);
        this.calcInnerBounds();
        this.reInitialize();
    }

    public FrameEffect getFrameEffect() {
        return this.model.getFrameEffect();
    }

    public void setFrameEffect(FrameEffect FRAME_EFFECT) {
        this.model.setFrameEffect(FRAME_EFFECT);
        this.reInitialize();
    }

    public Color getFrameBaseColor() {
        return this.model.getFrameBaseColor();
    }

    public void setFrameBaseColor(Color FRAME_BASECOLOR) {
        this.model.setFrameBaseColor(FRAME_BASECOLOR);
        this.reInitialize();
    }

    public boolean isFrameBaseColorEnabled() {
        return this.model.isFrameBaseColorEnabled();
    }

    public void setFrameBaseColorEnabled(boolean FRAME_BASECOLOR_ENABLED) {
        this.model.setFrameBaseColorEnabled(FRAME_BASECOLOR_ENABLED);
        this.reInitialize();
    }

    public BackgroundColor getBackgroundColor() {
        return this.model.getBackgroundColor();
    }

    public void setBackgroundColor(BackgroundColor BACKGROUND_COLOR) {
        this.model.setBackgroundColor(BACKGROUND_COLOR);
        this.reInitialize();
    }

    public boolean isBackgroundVisible() {
        return this.model.isBackgroundVisible();
    }

    public void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.model.setBackgroundVisible(BACKGROUND_VISIBLE);
        this.reInitialize();
    }

    public Color getTextureColor() {
        return this.model.getTextureColor();
    }

    public void setTextureColor(Color TEXTURE_COLOR) {
        this.model.setTextureColor(TEXTURE_COLOR);
        BACKGROUND_FACTORY.recreatePunchedSheetTexture(TEXTURE_COLOR);
        this.reInitialize();
    }

    public Paint getCustomBackground() {
        return this.model.getCustomBackground();
    }

    public void setCustomBackground(Paint CUSTOM_BACKGROUND) {
        this.model.setCustomBackground(CUSTOM_BACKGROUND);
        if (this.model.getBackgroundColor() == BackgroundColor.CUSTOM) {
            this.reInitialize();
        }
    }

    public boolean isCustomLayerVisible() {
        return this.model.isCustomLayerVisible();
    }

    public void setCustomLayerVisible(boolean CUSTOM_LAYER_VISIBLE) {
        if (this.model.getCustomLayer() != null) {
            this.model.setCustomLayerVisible(CUSTOM_LAYER_VISIBLE);
        }
        this.reInitialize();
    }

    public BufferedImage getCustomLayer() {
        return this.model.getCustomLayer();
    }

    public void setCustomLayer(BufferedImage CUSTOM_LAYER) {
        if (CUSTOM_LAYER == null) {
            this.model.setCustomLayerVisible(false);
            return;
        }
        this.model.setCustomLayer(CUSTOM_LAYER);
        if (this.model.isCustomLayerVisible()) {
            this.reInitialize();
        }
    }

    protected float getGlowAlpha() {
        return this.glowAlpha;
    }

    abstract boolean isGlowVisible();

    public boolean isGlowPulsating() {
        return this.GLOW_PULSE.isRunning();
    }

    public void setGlowPulsating(boolean PULSATING) {
        if (this.isGlowVisible() && PULSATING && !this.GLOW_PULSE.isRunning()) {
            this.GLOW_PULSE.start();
        } else if (this.GLOW_PULSE.isRunning()) {
            this.GLOW_PULSE.stop();
            this.glowAlpha = 1.0f;
        }
    }

    public boolean isForegroundVisible() {
        return this.model.isForegroundVisible();
    }

    public void setForegroundVisible(boolean FOREGROUND_VISIBLE) {
        this.model.setForegroundVisible(FOREGROUND_VISIBLE);
        this.reInitialize();
    }

    protected final BufferedImage create_LED_Image(int SIZE, int STATE, LedColor LED_COLOR) {
        return LED_FACTORY.create_LED_Image(SIZE, STATE, LED_COLOR, this.model.getCustomLedColor());
    }

    public BufferedImage create_LCD_THRESHOLD_Image(int WIDTH, int HEIGHT, Color COLOR) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath LCD_THRESHOLD = new GeneralPath();
        LCD_THRESHOLD.setWindingRule(0);
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, 0.0);
        LCD_THRESHOLD.lineTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.closePath();
        G2.setColor(COLOR);
        G2.fill(LCD_THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    public abstract void calcInnerBounds();

    public abstract Rectangle getInnerBounds();

    protected abstract Point2D getCenter();

    protected abstract Rectangle2D getBounds2D();

    public void reInitialize() {
        if (this.isInitialized()) {
            this.init(this.getInnerBounds().width, this.getInnerBounds().height);
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.reInitialize();
    }

    public JComponent clone() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(this);
            objOut.flush();
            ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
            JComponent compClone = (JComponent)objIn.readObject();
            objOut.close();
            objIn.close();
            return compClone;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void dispose() {
        this.LED_BLINKING_TIMER.removeActionListener(this);
        this.USER_LED_BLINKING_TIMER.removeActionListener(this);
        this.PEAK_TIMER.removeActionListener(this);
    }

    public void addChangeListener(ChangeListener LISTENER) {
        this.LISTENER_LIST.add(ChangeListener.class, LISTENER);
    }

    public void removeChangeListener(ChangeListener LISTENER) {
        this.LISTENER_LIST.remove(ChangeListener.class, LISTENER);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.LISTENER_LIST.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertyChangeSupport.addPropertyChangeListener(LISTENER);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertyChangeSupport.removePropertyChangeListener(LISTENER);
    }

    @Override
    public void componentResized(ComponentEvent event) {
        if (event.getComponent() instanceof AbstractRadial) {
            int SIZE = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
            this.setSize(SIZE, SIZE);
            this.setPreferredSize(this.getSize());
            if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
                this.setSize(this.getMinimumSize());
            }
            this.calcInnerBounds();
            this.recreateLedImages();
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.recreateUserLedImages();
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.reInitialize();
        }
        if (event.getComponent() instanceof AbstractLinear) {
            this.setSize(this.getWidth(), this.getHeight());
            this.setPreferredSize(this.getSize());
            this.calcInnerBounds();
            if (this.getWidth() >= this.getHeight()) {
                this.setOrientation(Orientation.HORIZONTAL);
                this.recreateLedImages(this.getInnerBounds().height);
                this.recreateUserLedImages(this.getInnerBounds().height);
                if (this.isLedOn()) {
                    this.setCurrentLedImage(this.getLedImageOn());
                } else {
                    this.setCurrentLedImage(this.getLedImageOff());
                }
                this.setLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
                if (this.isUserLedOn()) {
                    this.setCurrentUserLedImage(this.getUserLedImageOn());
                } else {
                    this.setCurrentUserLedImage(this.getUserLedImageOff());
                }
                this.setUserLedPosition(18.0 / (double)this.getInnerBounds().width, 0.453271028);
            } else {
                this.setOrientation(Orientation.VERTICAL);
                this.recreateLedImages(this.getInnerBounds().width);
                this.recreateUserLedImages(this.getInnerBounds().width);
                if (this.isLedOn()) {
                    this.setCurrentLedImage(this.getLedImageOn());
                } else {
                    this.setCurrentLedImage(this.getLedImageOff());
                }
                this.setLedPosition(0.453271028, 18.0 / (double)this.getInnerBounds().height);
                if (this.isUserLedOn()) {
                    this.setCurrentUserLedImage(this.getUserLedImageOn());
                } else {
                    this.setCurrentUserLedImage(this.getUserLedImageOff());
                }
                this.setUserLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
            }
            this.reInitialize();
        }
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        if (EVENT.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage.flush();
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint((int)((double)this.getInnerBounds().width * this.getLedPosition().getX() + (double)this.getInnerBounds().x), (int)((double)this.getInnerBounds().height * this.getLedPosition().getY() + (double)this.getInnerBounds().y), this.currentLedImage.getWidth(), this.currentLedImage.getHeight());
        } else if (EVENT.getSource().equals(this.USER_LED_BLINKING_TIMER)) {
            this.currentUserLedImage.flush();
            this.currentUserLedImage = this.userLedOn ? this.getUserLedImageOn() : this.getUserLedImageOff();
            this.userLedOn ^= true;
            this.repaint((int)((double)this.getInnerBounds().width * this.getUserLedPosition().getX() + (double)this.getInnerBounds().x), (int)((double)this.getInnerBounds().height * this.getUserLedPosition().getY() + (double)this.getInnerBounds().y), this.currentUserLedImage.getWidth(), this.currentUserLedImage.getHeight());
        } else if (EVENT.getSource().equals(this.PEAK_TIMER)) {
            this.setPeakValueVisible(false);
            this.PEAK_TIMER.stop();
        } else if (EVENT.getSource().equals(this.GLOW_PULSE)) {
            this.glowAlphaCounter += this.glowAlphaIncrement;
            this.glowAlpha = (float)Math.cos(this.glowAlphaCounter);
            if (Float.compare(this.glowAlpha, 1.0f) >= 0) {
                this.glowAlpha = 1.0f;
                this.glowAlphaIncrement = -0.0785398164;
            }
            if (Float.compare(this.glowAlpha, 0.2f) <= 0) {
                this.glowAlpha = 0.0f;
                this.glowAlphaIncrement = 0.0785398164;
            }
            this.repaint(this.getInnerBounds());
        }
    }
}

