/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.EnumIniField;
import com.rusefi.ConfigField;
import com.rusefi.MaybeSemicolonWasMissedException;
import com.rusefi.ReaderState;
import com.rusefi.TokenUtils;
import com.rusefi.VariableRegistry;
import com.rusefi.core.Pair;
import com.rusefi.output.ConfigStructure;
import com.rusefi.parse.TypesHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class ConfigFieldImpl
implements ConfigField {
    private static final Logging log = Logging.getLogging(ConfigFieldImpl.class);
    public static final ConfigFieldImpl VOID = new ConfigFieldImpl(null, "", null, null, null, new int[0], null, false, false, null, null);
    private static final String typePattern = "([\\w\\d_]+)(\\[([\\w\\d]+)(\\sx\\s([\\w\\d]+))?(\\s([\\w\\d]+))?\\])?";
    private static final String namePattern = "[[\\w\\d\\s_]]+";
    private static final String commentPattern = ";([^;]*)";
    private static final Pattern FIELD = Pattern.compile("([\\w\\d_]+)(\\[([\\w\\d]+)(\\sx\\s([\\w\\d]+))?(\\s([\\w\\d]+))?\\])?\\s([[\\w\\d\\s_]]+)(;([^;]*))?(;(.*))?");
    private static final Pattern DIRECTIVE = Pattern.compile("#(if\\s[[\\w\\d\\s_]]+|else|elif\\s\" + namePattern + \"|endif)");
    public static final String VOID_NAME = "";
    public static final String BOOLEAN_T = "boolean";
    public static final String DIRECTIVE_T = "directive";
    private final String name;
    private final String comment;
    public final String arraySizeVariableName;
    private final String type;
    private final int[] arraySizes;
    private final String tsInfo;
    private final boolean isIterate;
    private final ReaderState state;
    private final boolean hasAutoscale;
    private final String trueName;
    private final String falseName;
    private final ConfigStructure parentType;
    private boolean isFromIterate;
    private String iterateOriginalName;
    private int iterateIndex;

    public ConfigFieldImpl(ReaderState state, String name, String comment, String arraySizeAsText, String type, int[] arraySizes, @Nullable String tsInfo, boolean isIterate, boolean hasAutoscale, String trueName, String falseName) {
        String[] tokens;
        this.hasAutoscale = hasAutoscale;
        this.trueName = trueName == null ? "true" : trueName;
        this.falseName = falseName == null ? "false" : falseName;
        Objects.requireNonNull(name, comment + " " + type);
        ConfigFieldImpl.assertNoWhitespaces(name);
        this.name = name;
        if (!this.isVoid()) {
            Objects.requireNonNull(state);
        }
        this.state = state;
        this.parentType = state == null ? null : (state.isStackEmpty() ? null : state.peek());
        this.comment = comment;
        if (!this.isVoid()) {
            Objects.requireNonNull(type);
        }
        this.type = type;
        this.arraySizeVariableName = arraySizeAsText;
        this.arraySizes = arraySizes;
        this.tsInfo = tsInfo == null ? null : state.getVariableRegistry().applyVariables(tsInfo);
        this.isIterate = isIterate;
        if (tsInfo != null && (tokens = this.getTokens()).length > 1) {
            Double scaleDouble;
            String scale = tokens[1].trim();
            try {
                scaleDouble = Double.parseDouble(scale);
            }
            catch (NumberFormatException ignore) {
                scaleDouble = -1.0;
            }
            if (!hasAutoscale && scaleDouble != 1.0) {
                throw new IllegalStateException("Unexpected scale of " + scale + " without autoscale on " + this);
            }
        }
    }

    @Override
    public ConfigStructure getParentStructureType() {
        return this.parentType;
    }

    private static int getSize(VariableRegistry variableRegistry, String s) {
        if (variableRegistry.intValues.containsKey(s)) {
            return variableRegistry.intValues.get(s);
        }
        return Integer.parseInt(s);
    }

    @Override
    public ConfigStructure getStructureType() {
        return this.getState().getStructures().get(this.getTypeName());
    }

    @Override
    public boolean isArray() {
        return this.arraySizeVariableName != null || this.arraySizes.length != 0;
    }

    @Override
    public String getArraySizeVariableName() {
        return this.arraySizeVariableName;
    }

    @Override
    public String getTrueName() {
        return this.trueName;
    }

    @Override
    public String getFalseName() {
        return this.falseName;
    }

    @Override
    public boolean isBit() {
        return BOOLEAN_T.equalsIgnoreCase(this.type);
    }

    @Override
    public boolean isDirective() {
        return DIRECTIVE_T.equalsIgnoreCase(this.type);
    }

    private boolean isVoid() {
        return this.name.equals(VOID_NAME);
    }

    public static void assertNoWhitespaces(String name) {
        if (name.contains(" ") || name.contains("\t")) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    public static ConfigFieldImpl parse(ReaderState state, String line) {
        int[] arraySizes;
        Object arraySizeAsText;
        Matcher matcher = FIELD.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String nameString = matcher.group(8).trim();
        String[] nameTokens = nameString.split("\\s");
        String name = nameTokens[nameTokens.length - 1];
        boolean hasAutoscale = false;
        for (String autoscaler : nameTokens) {
            if (!autoscaler.equals("autoscale")) continue;
            hasAutoscale = true;
            break;
        }
        String comment = matcher.group(10);
        ConfigFieldImpl.validateComment(comment);
        String type = matcher.group(1);
        if (matcher.group(5) != null) {
            arraySizeAsText = matcher.group(3) + "][" + matcher.group(5);
            arraySizes = new int[]{ConfigFieldImpl.getSize(state.getVariableRegistry(), matcher.group(3)), ConfigFieldImpl.getSize(state.getVariableRegistry(), matcher.group(5))};
        } else if (matcher.group(3) != null) {
            arraySizeAsText = matcher.group(3);
            arraySizes = new int[]{ConfigFieldImpl.getSize(state.getVariableRegistry(), (String)arraySizeAsText)};
        } else {
            arraySizes = new int[]{};
            arraySizeAsText = null;
        }
        String tsInfo = matcher.group(12);
        boolean isIterate = "iterate".equalsIgnoreCase(matcher.group(7));
        ConfigFieldImpl field = new ConfigFieldImpl(state, name, comment, (String)arraySizeAsText, type, arraySizes, tsInfo, isIterate, hasAutoscale, null, null);
        if (log.debugEnabled()) {
            log.debug("type " + type);
        }
        if (log.debugEnabled()) {
            log.debug("name " + name);
        }
        if (log.debugEnabled()) {
            log.debug("comment " + comment);
        }
        return field;
    }

    private static void validateComment(String comment) {
        if (comment == null) {
            return;
        }
        if ((comment = comment.trim()).isEmpty()) {
            return;
        }
        if (comment.charAt(0) == '\"' && !EnumIniField.isQuoted(comment)) {
            throw new MaybeSemicolonWasMissedException("This comment looks like semicolon was missed: " + comment);
        }
    }

    public static boolean isPreprocessorDirective(String line) {
        Matcher matcher = DIRECTIVE.matcher(line);
        return matcher.matches();
    }

    @Override
    public int getSize(ConfigField next) {
        if (this.isBit() && next.isBit()) {
            return 0;
        }
        if (this.isBit()) {
            return 4;
        }
        int size = this.getElementSize();
        for (int s : this.arraySizes) {
            size *= s;
        }
        return size;
    }

    public String toString() {
        return "ConfigField{name='" + this.name + "', type='" + this.type + "', arraySizes=" + Arrays.toString(this.arraySizes) + "}";
    }

    @Override
    public int[] getArraySizes() {
        return this.arraySizes;
    }

    @Override
    public String getComment() {
        if (this.comment == null) {
            return null;
        }
        return this.comment.trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return this.type;
    }

    @Override
    public int getElementSize() {
        return this.isVoid() ? 0 : TypesHelper.getElementSize(this.state, this.type);
    }

    @Override
    public boolean isIterate() {
        return this.isIterate;
    }

    @Override
    public boolean isHasAutoscale() {
        return this.hasAutoscale;
    }

    @Override
    public ReaderState getState() {
        return this.state;
    }

    @Override
    public String getTsInfo() {
        return this.tsInfo;
    }

    @Override
    public String autoscaleSpec() {
        Pair<Integer, Integer> pair = this.autoscaleSpecPair();
        if (pair == null) {
            return null;
        }
        return pair.first + ", " + pair.second;
    }

    @Override
    public double autoscaleSpecNumber() {
        Pair<Integer, Integer> pair = this.autoscaleSpecPair();
        if (pair == null) {
            return 1.0;
        }
        return 1.0 * (double)((Integer)pair.second).intValue() / (double)((Integer)pair.first).intValue();
    }

    @Override
    public Pair<Integer, Integer> autoscaleSpecPair() {
        int div;
        int mul;
        double factor;
        if (!this.hasAutoscale) {
            return null;
        }
        if (this.tsInfo == null) {
            throw new IllegalArgumentException("tsInfo expected with autoscale: " + this);
        }
        String[] tokens = this.getTokens();
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Second comma-separated token expected in [" + this.tsInfo + "] for " + this.name);
        }
        String scale = tokens[1].trim();
        if (scale.startsWith("{") && scale.endsWith("}")) {
            String[] parts = (scale = scale.substring(1, scale.length() - 1)).split("/");
            if (parts.length != 2) {
                throw new IllegalArgumentException(this.name + ": Two parts of division expected in " + scale);
            }
            factor = Double.parseDouble(parts[0]) / Double.parseDouble(parts[1]);
        } else {
            factor = Double.parseDouble(scale);
        }
        if (factor < 1.0) {
            mul = (int)Math.round(1.0 / factor);
            div = 1;
        } else {
            mul = 1;
            div = (int)factor;
        }
        double factor2 = (double)div / (double)mul;
        double accuracy = Math.abs(factor2 / factor - 1.0);
        if (accuracy > 1.0E-7) {
            throw new IllegalStateException("$*@#$* Cannot accurately represent autoscale for " + tokens[1]);
        }
        return new Pair<Integer, Integer>(mul, div);
    }

    private String[] getTokens() {
        return TokenUtils.tokenizeWithBraces(this.tsInfo);
    }

    @Override
    public String getUnits() {
        String[] tokens = this.getTokens();
        if (tokens.length == 0) {
            return VOID_NAME;
        }
        return ConfigFieldImpl.unquote(tokens[0].trim());
    }

    @Override
    public double getMin() {
        String[] tokens = this.getTokens();
        if (tokens.length < 4) {
            return -1.0;
        }
        return Double.parseDouble(tokens[3]);
    }

    @Override
    public double getMax() {
        String[] tokens = this.getTokens();
        if (tokens.length < 5) {
            return -1.0;
        }
        return Double.parseDouble(tokens[4]);
    }

    @Override
    public int getDigits() {
        String[] tokens = this.getTokens();
        if (tokens.length < 6) {
            return 0;
        }
        return Integer.parseInt(tokens[5].trim());
    }

    @Override
    public String getCategory() {
        String[] tokens = this.getTokens();
        if (tokens.length < 7) {
            return null;
        }
        return tokens[6].trim();
    }

    public static String unquote(String token) {
        return VariableRegistry.unquote(token);
    }

    public void setFromIterate(String iterateOriginalName, int iterateIndex) {
        this.iterateOriginalName = iterateOriginalName;
        this.iterateIndex = iterateIndex;
        this.isFromIterate = true;
    }

    @Override
    public String getIterateOriginalName() {
        return this.iterateOriginalName;
    }

    @Override
    public int getIterateIndex() {
        return this.iterateIndex;
    }

    @Override
    public boolean isFromIterate() {
        return this.isFromIterate;
    }

    public String getCommentOrName() {
        if (this.comment == null || this.comment.trim().isEmpty()) {
            return VariableRegistry.quote(this.name);
        }
        return this.comment;
    }

    @Override
    public String getCommentTemplated() {
        return this.state.getVariableRegistry().applyVariables(this.getComment());
    }
}

