/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.f4discovery;

import com.rusefi.IoUtil;
import com.rusefi.RusefiTestBase;
import com.rusefi.TestingUtils;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.SensorType;
import com.rusefi.enums.engine_type_e;
import com.rusefi.enums.trigger_type_e;
import com.rusefi.functional_tests.EcuTestHelper;
import com.rusefi.waves.EngineChart;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class CommonFunctionalTest
extends RusefiTestBase {
    @Test
    public void testChangingIgnitionMode() {
        this.ecu.setEngineType(engine_type_e.FORD_ASPIRE_1996);
        this.ecu.changeRpm(2000);
        this.ecu.sendCommand("set ignition_mode 2");
        EngineChart chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1", "c3");
        CommonFunctionalTest.assertWaveNull(chart, "c2", "c4");
        this.ecu.sendCommand("set ignition_mode 1");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1", "c2", "c3", "c4");
        this.ecu.sendCommand("set ignition_mode 0");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1");
        CommonFunctionalTest.assertWaveNull(chart, "c2", "c3", "c4");
        this.ecu.sendCommand("set ignition_mode 2");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1", "c3");
        CommonFunctionalTest.assertWaveNull(chart, "c2", "c4");
    }

    @Test
    public void testRevLimiter() {
        this.ecu.setEngineType(engine_type_e.FORD_ASPIRE_1996);
        this.ecu.changeRpm(2000);
        this.ecu.sendCommand("set algorithm 2");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.Tps1.ordinal() + " 25");
        this.ecu.sendCommand("set rpm_hard_limit 2500");
        EngineChart chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1", "i1");
        this.ecu.changeRpm(3000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNoRises(chart, "c1", "i1");
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1", "i1");
    }

    @Test
    public void testCustomEngine() {
        this.ecu.setEngineType(engine_type_e.DEFAULT_FRANKENSO);
        this.ecu.sendCommand("set_toothed_wheel 4 0");
    }

    @Test
    public void testAuxValveNissan() {
        this.ecu.setEngineType(engine_type_e.NISSAN_PRIMERA);
        this.ecu.changeRpm(1200);
    }

    @Test
    public void testTwoStrokeSachs() {
        this.ecu.setEngineType(engine_type_e.SACHS);
        this.ecu.changeRpm(1200);
    }

    @Test
    public void test2003DodgeNeon() {
        this.ecu.setEngineType(engine_type_e.DODGE_NEON_2003_CRANK);
        this.ecu.sendCommand("set wwaeTau 0");
        this.ecu.sendCommand("set wwaeBeta 0");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.Map.ordinal() + " 69.12");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.BatteryVoltage.ordinal() + " 12");
        this.ecu.sendCommand("disable cylinder_cleanup");
        String msg = "2003 Neon cranking ";
        this.ecu.changeRpm(200);
        this.ecu.changeRpm(250);
        this.ecu.changeRpm(200);
        EcuTestHelper.assertSomewhatClose("VBatt", 12.0, SensorCentral.getInstance().getValue(Sensor.VBATT));
        EngineChart chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNull(msg, chart, "c2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c3");
        CommonFunctionalTest.assertWaveNull(msg, chart, "c4");
        double widthRatio = 0.25;
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i4");
        msg = "2003 Neon running";
        this.ecu.changeRpm(2000);
        this.ecu.changeRpm(2700);
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNull(msg, chart, "c2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c3");
        CommonFunctionalTest.assertWaveNull(msg, chart, "c4");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i4");
        this.ecu.sendCommand(IoUtil.getEnableCommand("trigger_only_front"));
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i4");
        this.ecu.sendCommand("set_whole_timing_map 520");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        this.ecu.sendCommand("set_whole_timing_map 0");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
    }

    @Test
    public void testMazdaProtege() {
        this.ecu.setEngineType(engine_type_e.FORD_ESCORT_GT);
        this.ecu.sendCommand("set_sensor_mock " + SensorType.BatteryVoltage.ordinal() + " 12");
        this.ecu.sendCommand("set algorithm 2");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.Tps1.ordinal() + " 25");
        this.ecu.changeRpm(200);
        this.ecu.changeRpm(260);
        this.ecu.changeRpm(200);
        String msg = "ProtegeLX cranking";
        EngineChart chart = this.nextChart();
        EcuTestHelper.assertSomewhatClose("", 12.0, SensorCentral.getInstance().getValue(Sensor.VBATT), 0.1);
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c3");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
        msg = "ProtegeLX running";
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
    }

    @Test
    public void test1995DodgeNeon() {
        this.ecu.setEngineType(engine_type_e.DODGE_NEON_1995);
        this.sendComplexCommand("set_individual_coils_ignition");
        this.ecu.changeRpm(2000);
        EngineChart chart = this.nextChart();
        String msg = "1995 Neon";
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c4");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c3");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.Map.ordinal() + " 69.12");
        this.sendComplexCommand("set algorithm 0");
        this.ecu.changeRpm(2600);
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i4");
    }

    @Test
    public void testFord6() {
        this.ecu.setEngineType(engine_type_e.FORD_INLINE_6_1995);
        this.ecu.changeRpm(2000);
        EngineChart chart = this.nextChart();
        String msg = "ford 6";
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "c1");
        CommonFunctionalTest.assertWaveNull(msg, chart, "t2");
        this.sendComplexCommand("set trigger_type " + trigger_type_e.TT_FORD_ASPIRE.ordinal());
        chart = this.nextChart();
        Assert.assertTrue(chart.get("t2") != null);
    }

    @Test
    public void testFordAspire() {
        this.ecu.setEngineType(engine_type_e.FORD_ASPIRE_1996);
        this.ecu.sendCommand("disable cylinder_cleanup");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.Map.ordinal() + " 69.12");
        this.ecu.sendCommand("set_sensor_mock " + SensorType.BatteryVoltage.ordinal() + " 12");
        this.sendComplexCommand("set cranking_rpm 500");
        this.ecu.changeRpm(200);
        EngineChart chart = this.nextChart();
        EcuTestHelper.assertSomewhatClose(12.0, SensorCentral.getInstance().getValue(Sensor.VBATT));
        CommonFunctionalTest.assertWaveNotNull("aspire default cranking ", chart, "c1");
        this.ecu.changeRpm(600);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("aspire default running ", chart, "c1");
        this.ecu.changeRpm(200);
        this.ecu.sendCommand("set cranking_charge_angle 65");
        this.ecu.sendCommand("set cranking_timing_angle -31");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("aspire cranking", chart, "c1");
        this.ecu.sendCommand("set cranking_timing_angle -40");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("aspire", chart, "c1");
        this.ecu.sendCommand("set cranking_timing_angle 149");
        this.ecu.sendCommand("set cranking_charge_angle 40");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("aspire", chart, "c1");
        this.ecu.sendCommand("set cranking_charge_angle 65");
        this.ecu.changeRpm(600);
        this.sendComplexCommand("set cranking_rpm 700");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("cranking@600", chart, "c1");
        this.ecu.changeRpm(2000);
        this.ecu.changeRpm(2600);
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        String msg = "aspire running";
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg, chart, "i4");
        CommonFunctionalTest.assertWaveNotNull(chart, "c1");
        this.ecu.sendCommand("set_fuel_map 2200 4 15.66");
        this.ecu.sendCommand("set_fuel_map 2000 4 15.66");
        this.ecu.sendCommand("set_fuel_map 2200 4.2 15.66");
        this.ecu.sendCommand("set_fuel_map 2000 4.2 15.66");
        this.sendComplexCommand("set global_trigger_offset_angle 175");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel", chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel", chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel", chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel", chart, "i4");
        CommonFunctionalTest.assertWaveNotNull(chart, "c1");
        CommonFunctionalTest.assertWaveNull(chart, "c2");
        this.sendComplexCommand("set global_trigger_offset_angle 130");
        this.sendComplexCommand("set injection_offset 369");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c1");
        this.sendComplexCommand("set_individual_coils_ignition");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull("Switching Aspire into INDIVIDUAL_COILS mode", chart, "c2");
        CommonFunctionalTest.assertWaveNotNull(chart, "c3");
        this.ecu.sendCommand("set_whole_timing_map 520");
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNotNull(chart, "c2");
        this.sendComplexCommand("set algorithm 0");
        this.ecu.changeRpm(2400);
        this.ecu.changeRpm(2000);
        chart = this.nextChart();
        EcuTestHelper.assertSomewhatClose("MAP", 69.12, SensorCentral.getInstance().getValue(Sensor.MAP));
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel SD #1", chart, "i1");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel SD #2", chart, "i2");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel SD #3", chart, "i3");
        CommonFunctionalTest.assertWaveNotNull(msg + " fuel SD #4", chart, "i4");
        this.ecu.changeRpm(10000);
        chart = this.nextChart();
        CommonFunctionalTest.assertWaveNull("hard limit check", chart, "i1");
    }

    @Test
    public void testStackOverflow() {
        this.ecu.sendCommand("threadsinfo");
    }

    private void sendComplexCommand(String command) {
        this.ecu.sendCommand(command);
    }

    private static void assertWaveNull(EngineChart chart, String key) {
        CommonFunctionalTest.assertWaveNull("", chart, key);
    }

    private static void assertWaveNull(EngineChart chart, String ... keys) {
        Arrays.stream(keys).peek(k -> CommonFunctionalTest.assertWaveNull(chart, k));
    }

    private static void assertWaveNull(String msg, EngineChart chart, String key) {
        TestingUtils.assertNull(msg + "chart for " + key, chart.get(key));
    }

    private static void assertWaveNotNull(EngineChart chart, String key) {
        CommonFunctionalTest.assertWaveNotNull("", chart, key);
    }

    private static void assertWaveNotNull(String msg, EngineChart chart, String key) {
        Assert.assertTrue(msg, chart.get(key) != null);
    }

    private static void assertWaveNotNull(EngineChart chart, String ... keys) {
        Arrays.stream(keys).peek(k -> CommonFunctionalTest.assertWaveNotNull(chart, k));
    }

    private static void assertWaveNoRises(EngineChart chart, String key) {
        StringBuilder events = chart.get(key);
        if (events == null) {
            return;
        }
        Assert.assertFalse(events.toString().contains("u"));
    }

    private static void assertWaveNoRises(EngineChart chart, String ... keys) {
        Arrays.stream(keys).peek(k -> CommonFunctionalTest.assertWaveNoRises(chart, k));
    }
}

