/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.composite.CompositeEvent;
import com.rusefi.composite.CompositeParser;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.LinkManager;
import com.rusefi.stream.LogicdataStreamFile;
import com.rusefi.stream.StreamFile;
import com.rusefi.stream.TSHighSpeedLog;
import com.rusefi.stream.VcdStreamFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class BinaryProtocolLogger {
    private static final int HIGH_RPM_DELAY = Integer.getInteger("high_speed_logger_time", 10);
    public static final int COMPOSITE_OFF_RPM = Integer.getInteger("high_speed_logger_rpm", 700);
    public boolean needCompositeLogger;
    private boolean isCompositeLoggerEnabled;
    private long lastLowRpmTime = System.currentTimeMillis();
    private final List<StreamFile> compositeLogs = new CopyOnWriteArrayList<StreamFile>();
    private final SensorCentral.SensorListener rpmListener;
    private final Thread hook = new Thread(() -> this.closeComposites(), "BinaryProtocol::hook");

    public BinaryProtocolLogger(LinkManager linkManager) {
        this.rpmListener = currentRpm -> {
            if (currentRpm <= (double)COMPOSITE_OFF_RPM) {
                this.needCompositeLogger = linkManager.getCompositeLogicEnabled();
                this.lastLowRpmTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.lastLowRpmTime > (long)(HIGH_RPM_DELAY * 1000)) {
                this.needCompositeLogger = false;
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hook);
        this.needCompositeLogger = linkManager.getCompositeLogicEnabled();
    }

    private void createCompositesIfNeeded() {
        if (!this.compositeLogs.isEmpty()) {
            return;
        }
        this.compositeLogs.addAll(Arrays.asList(new VcdStreamFile(BinaryProtocolLogger.getFileName("rusEFI_trigger_log_", ".vcd")), new LogicdataStreamFile(BinaryProtocolLogger.getFileName("rusEFI_trigger_log_", ".logicdata")), new TSHighSpeedLog(BinaryProtocolLogger.getFileName("rusEFI_trigger_log_"))));
    }

    @NotNull
    public static String getFileName(String prefix) {
        return BinaryProtocolLogger.getFileName(prefix, ".csv");
    }

    @NotNull
    public static String getFileName(String prefix, String fileType) {
        return "logs/" + prefix + FileLog.getDate() + fileType;
    }

    public void compositeLogic(BinaryProtocol binaryProtocol) {
        if (this.needCompositeLogger) {
            this.getComposite(binaryProtocol);
        } else if (this.isCompositeLoggerEnabled) {
            binaryProtocol.executeCommand('l', new byte[]{2}, "disable composite");
            this.isCompositeLoggerEnabled = false;
            this.closeComposites();
        }
    }

    private void closeComposites() {
        for (StreamFile composite : this.compositeLogs) {
            composite.close();
        }
        this.compositeLogs.clear();
    }

    public void getComposite(BinaryProtocol binaryProtocol) {
        if (binaryProtocol.isClosed) {
            return;
        }
        this.isCompositeLoggerEnabled = true;
        byte[] response = binaryProtocol.executeCommand('8', "composite log");
        if (IoHelper.checkResponseCode(response)) {
            List<CompositeEvent> events = CompositeParser.parse(response);
            this.createCompositesIfNeeded();
            for (StreamFile composite : this.compositeLogs) {
                composite.append(events);
            }
        }
    }

    public void start() {
        SensorCentral.getInstance().addListener(Sensor.RPMValue, this.rpmListener);
    }

    public void close() {
        SensorCentral.getInstance().removeListener(Sensor.RPMValue, this.rpmListener);
        this.closeComposites();
        Runtime.getRuntime().removeShutdownHook(this.hook);
    }
}

