/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public class AirCompass
extends AbstractRadial {
    private boolean rotateTickmarks = true;
    private double value = 0.0;
    private double rotationAngle = 0.0;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage tickmarksImage;
    private BufferedImage planeImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private Timeline timeline = new Timeline(this);

    public AirCompass() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setLcdVisible(true);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(GAUGE_WIDTH);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(GAUGE_WIDTH);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = this.create_TICKMARKS_Image(GAUGE_WIDTH);
        if (this.planeImage != null) {
            this.planeImage.flush();
        }
        this.planeImage = this.create_AIRPLANE_Image(GAUGE_WIDTH);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        switch (this.getFrameType()) {
            case SQUARE: {
                this.foregroundImage = FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false);
                break;
            }
            default: {
                this.foregroundImage = FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType());
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        if (this.isFrameVisible()) {
            G2.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.rotateTickmarks) {
            G2.rotate(-this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.tickmarksImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        } else {
            G2.drawImage((Image)this.tickmarksImage, 0, 0, null);
        }
        if (!this.rotateTickmarks) {
            G2.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.planeImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        } else {
            G2.drawImage((Image)this.planeImage, 0, 0, null);
        }
        if (this.isForegroundVisible()) {
            G2.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double VALUE) {
        this.rotationAngle = Math.PI / 180 * (VALUE % 360.0);
        double oldValue = this.value;
        if (this.isValueCoupled()) {
            this.setLcdValue(VALUE);
        }
        this.fireStateChanged();
        this.firePropertyChange("value", oldValue, this.value);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setValueAnimated(double VALUE) {
        if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.timeline.abort();
        }
        this.timeline = new Timeline(this);
        this.timeline.addPropertyToInterpolate("value", this.value, VALUE);
        this.timeline.setEase(new Spline(0.5f));
        this.timeline.setDuration(800L);
        this.timeline.play();
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    public boolean isRotateTickmarks() {
        return this.rotateTickmarks;
    }

    public void setRotateTickmarks(boolean ROTATE_TICKMARKS) {
        this.rotateTickmarks = ROTATE_TICKMARKS;
        this.setValue(0.0);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().x, this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getInnerBounds();
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int IMAGE_WIDTH = IMAGE.getWidth();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        BasicStroke THIN_STROKE = new BasicStroke(0.01f * (float)IMAGE_WIDTH, 1, 2);
        Font NUMBER_FONT = new Font("Arial", 0, (int)(0.073f * (float)IMAGE_WIDTH));
        Font CHAR_FONT = new Font("Arial", 0, (int)(0.075f * (float)IMAGE_WIDTH));
        float TEXT_DISTANCE = 0.1f * (float)IMAGE_WIDTH;
        float MIN_LENGTH = 0.039f * (float)IMAGE_WIDTH;
        float MED_LENGTH = 0.04f * (float)IMAGE_WIDTH;
        float RADIUS = (float)IMAGE_WIDTH * 0.39f;
        this.CENTER.setLocation((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_WIDTH / 2.0f);
        Point2D.Double innerPoint = new Point2D.Double();
        Point2D.Double outerPoint = new Point2D.Double();
        Point2D.Double textPoint = new Point2D.Double();
        int tickCounterFull = 0;
        int tickCounterHalf = 0;
        int counter = 0;
        double sinValue = 0.0;
        double cosValue = 0.0;
        double STEP = 0.08726646259971647;
        if (this.isTickmarkColorFromThemeEnabled()) {
            G2.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            G2.setColor(this.getTickmarkColor());
        }
        for (double alpha = Math.PI * 2; alpha >= 0.0; alpha -= 0.08726646259971647) {
            Line2D.Double tick;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha - Math.PI);
            cosValue = Math.cos(alpha - Math.PI);
            if (tickCounterHalf == 1) {
                G2.setStroke(THIN_STROKE);
                ((Point2D)innerPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - MED_LENGTH) * sinValue, this.CENTER.getY() + (double)(RADIUS - MED_LENGTH) * cosValue);
                ((Point2D)outerPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - MIN_LENGTH) * sinValue, this.CENTER.getY() + (double)(RADIUS - MIN_LENGTH) * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounterHalf = 0;
            }
            if (tickCounterFull == 2) {
                G2.setStroke(THIN_STROKE);
                ((Point2D)innerPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - MED_LENGTH) * sinValue, this.CENTER.getY() + (double)(RADIUS - MED_LENGTH) * cosValue);
                ((Point2D)outerPoint).setLocation(this.CENTER.getX() + (double)RADIUS * sinValue, this.CENTER.getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounterFull = 0;
            }
            ((Point2D)textPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - TEXT_DISTANCE) * sinValue, this.CENTER.getY() + (double)(RADIUS - TEXT_DISTANCE) * cosValue);
            if (counter != 72 && counter % 6 == 0) {
                Color FORMER_COLOR;
                if (counter / 2 == 0) {
                    G2.setFont(CHAR_FONT);
                    FORMER_COLOR = G2.getColor();
                    G2.setColor(this.getPointerColor().LIGHT);
                    G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "N", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
                    G2.setColor(FORMER_COLOR);
                } else if (counter / 2 == 9) {
                    G2.setFont(CHAR_FONT);
                    FORMER_COLOR = G2.getColor();
                    G2.setColor(this.getPointerColor().LIGHT);
                    G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "E", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
                    G2.setColor(FORMER_COLOR);
                } else if (counter / 2 == 18) {
                    G2.setFont(CHAR_FONT);
                    FORMER_COLOR = G2.getColor();
                    G2.setColor(this.getPointerColor().LIGHT);
                    G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "S", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
                    G2.setColor(FORMER_COLOR);
                } else if (counter / 2 == 27) {
                    G2.setFont(CHAR_FONT);
                    FORMER_COLOR = G2.getColor();
                    G2.setColor(this.getPointerColor().LIGHT);
                    G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "W", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
                    G2.setColor(FORMER_COLOR);
                } else {
                    G2.setFont(NUMBER_FONT);
                    G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    G2.fill(UTIL.rotateTextAroundCenter(G2, String.valueOf(counter / 2), (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
                }
            }
            G2.setTransform(OLD_TRANSFORM);
            ++tickCounterHalf;
            ++tickCounterFull;
            ++counter;
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_AIRPLANE_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double OVERLAY_EFFECT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double OVERLAY_EFFECT_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        float[] OVERLAY_EFFECT_FRACTIONS = new float[]{0.0f, 0.41f, 0.705f, 1.0f};
        Color[] OVERLAY_EFFECT_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 30), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0)};
        RadialGradientPaint OVERLAY_EFFECT_GRADIENT = new RadialGradientPaint(OVERLAY_EFFECT_CENTER, (float)(0.4158878326 * (double)IMAGE_WIDTH), OVERLAY_EFFECT_FRACTIONS, OVERLAY_EFFECT_COLORS);
        G2.setPaint(OVERLAY_EFFECT_GRADIENT);
        G2.fill(OVERLAY_EFFECT);
        Ellipse2D.Double PLANEHOLDER_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44392523169517517, (double)IMAGE_HEIGHT * 0.44392523169517517, (double)IMAGE_WIDTH * 0.11214950680732727, (double)IMAGE_HEIGHT * 0.11214950680732727);
        Point2D.Double PLANEHOLDER_FRAME_START = new Point2D.Double(0.0, PLANEHOLDER_FRAME.getBounds2D().getMinY());
        Point2D.Double PLANEHOLDER_FRAME_STOP = new Point2D.Double(0.0, PLANEHOLDER_FRAME.getBounds2D().getMaxY());
        float[] PLANEHOLDER_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
        Color[] PLANEHOLDER_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint PLANEHOLDER_FRAME_GRADIENT = new LinearGradientPaint(PLANEHOLDER_FRAME_START, PLANEHOLDER_FRAME_STOP, PLANEHOLDER_FRAME_FRACTIONS, PLANEHOLDER_FRAME_COLORS);
        G2.setPaint(PLANEHOLDER_FRAME_GRADIENT);
        G2.fill(PLANEHOLDER_FRAME);
        Ellipse2D.Double GAUGE_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Ellipse2D.Double PLANEHOLDER_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44859811663627625, (double)IMAGE_HEIGHT * 0.44859811663627625, (double)IMAGE_WIDTH * 0.10280373692512512, (double)IMAGE_HEIGHT * 0.10280373692512512);
        Point2D.Double PLANEHOLDER_MAIN_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double PLANEHOLDER_MAIN_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
        float[] PLANEHOLDER_MAIN_FRACTIONS = new float[]{0.0f, 0.35f, 1.0f};
        Color[] PLANEHOLDER_MAIN_COLORS = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
        LinearGradientPaint PLANEHOLDER_MAIN_GRADIENT = new LinearGradientPaint(PLANEHOLDER_MAIN_START, PLANEHOLDER_MAIN_STOP, PLANEHOLDER_MAIN_FRACTIONS, PLANEHOLDER_MAIN_COLORS);
        G2.setPaint(PLANEHOLDER_MAIN_GRADIENT);
        G2.fill(PLANEHOLDER_MAIN);
        GeneralPath PLANE = new GeneralPath();
        PLANE.setWindingRule(0);
        PLANE.moveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2523364485981308);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2523364485981308, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.2850467289719626, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.3130841121495327);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.38317757009345793);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5186915887850467);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.5700934579439252);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48598130841121495);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.6121495327102804);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.6635514018691588);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4252336448598131, (double)IMAGE_HEIGHT * 0.7149532710280374);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6822429906542056);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.6962616822429907);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6962616822429907);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6822429906542056);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.7149532710280374);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5747663551401869, (double)IMAGE_HEIGHT * 0.6635514018691588);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.6121495327102804);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48598130841121495);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.5700934579439252);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.6728971962616822, (double)IMAGE_HEIGHT * 0.5186915887850467);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.38317757009345793);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.32710280373831774, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.3130841121495327);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2570093457943925, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2523364485981308);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2523364485981308, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2336448598130841, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2336448598130841);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.16822429906542055);
        PLANE.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841);
        PLANE.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2336448598130841, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2523364485981308, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2523364485981308);
        PLANE.closePath();
        G2.setColor(this.getPointerColor().MEDIUM);
        G2.setStroke(new BasicStroke(1.5f, 0, 0));
        G2.draw(PLANE);
        G2.translate(1, 2);
        G2.setStroke(new BasicStroke(2.0f, 0, 0));
        G2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
        G2.draw(PLANE);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "AirCompass";
    }
}

