/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.lua.TextEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.putgemin.VerticalFlowLayout;

public class ConnectionTab {
    private final UIContext uiContext;
    private final JPanel content = new JPanel(new BorderLayout());

    public ConnectionTab(UIContext uiContext) {
        this.uiContext = uiContext;
        JPanel vertical = new JPanel(new VerticalFlowLayout());
        this.content.add((Component)vertical, "Center");
        JButton connect = new JButton("Connect");
        JButton disconnect = new JButton("Disconnect");
        vertical.add(new JLabel("Same shortcuts work while on Lua tab"));
        vertical.add(new JLabel("Ctrl+R connect"));
        vertical.add(connect);
        vertical.add(new JLabel("Ctrl+D disconnect"));
        vertical.add(disconnect);
        ConnectionStatusLogic.INSTANCE.addListener(isConnected -> {
            connect.setEnabled(!isConnected);
            disconnect.setEnabled(isConnected);
        });
        ConnectionTab.installConnectAndDisconnect(uiContext, this.content);
        disconnect.addActionListener(e -> ConnectionTab.disconnect(uiContext));
        connect.addActionListener(e -> ConnectionTab.reconnect(uiContext));
    }

    public static void installConnectAndDisconnect(final UIContext uiContext, JComponent control) {
        KeyStroke disconnectKeyStroke = KeyStroke.getKeyStroke(68, 2);
        KeyStroke connectKeyStroke = KeyStroke.getKeyStroke(82, 2);
        TextEditor.installKeyAction(connectKeyStroke, "connectCommand", control, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionTab.reconnect(uiContext);
            }
        });
        TextEditor.installKeyAction(disconnectKeyStroke, "disconnectCommand", control, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionTab.disconnect(uiContext);
            }
        });
    }

    private static void reconnect(UIContext uiContext) {
        uiContext.getLinkManager().reconnect();
    }

    private static void disconnect(UIContext uiContext) {
        uiContext.getLinkManager().disconnect();
    }

    public JPanel getContent() {
        return this.content;
    }
}

