/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.auth.AuthTokenUtil;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.ui.util.URLLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AuthTokenPanel {
    private static final Logging log = Logging.getLogging(AuthTokenPanel.class);
    private final JPanel content = new JPanel(new BorderLayout());
    private final JTextField authTokenTestField = new JTextField();

    public AuthTokenPanel() {
        JPanel top = new JPanel(new FlowLayout(0));
        this.content.setBorder(BorderFactory.createTitledBorder("rusEFI Online Authentication Token"));
        this.authTokenTestField.setPreferredSize(new Dimension(200, 24));
        String authToken = AuthTokenPanel.getAuthToken();
        log.info("Auth token from settings: " + authToken);
        this.authTokenTestField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AuthTokenPanel.this.onTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AuthTokenPanel.this.onTextChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AuthTokenPanel.this.onTextChange();
            }
        });
        final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        JButton paste = new JButton("Paste from clipboard");
        paste.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                    if (AuthTokenUtil.isToken(data)) {
                        AuthTokenPanel.this.authTokenTestField.setText(data);
                    }
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
        });
        clipboard.addFlavorListener(e -> this.setPasteButtonEnabledBasedOnClipboardContent(clipboard, paste));
        this.setPasteButtonEnabledBasedOnClipboardContent(clipboard, paste);
        top.add(this.authTokenTestField);
        top.add(paste);
        this.content.add(top);
        if (authToken.trim().isEmpty()) {
            authToken = "Please copy token from your forum profile";
        }
        this.content.add((Component)new URLLabel("Manage authentication token at your forum profile", "https://rusefi.com/forum/ucp.php?i=254"), "South");
        this.authTokenTestField.setText(authToken);
    }

    public static void setAuthToken(String value) {
        PersistentConfiguration.getConfig().getRoot().setProperty("auth_token", value);
    }

    @NotNull
    public static String getAuthToken() {
        return PersistentConfiguration.getConfig().getRoot().getProperty("auth_token");
    }

    private void setPasteButtonEnabledBasedOnClipboardContent(Clipboard clipboard, JButton paste) {
        try {
            String data = (String)clipboard.getData(DataFlavor.stringFlavor);
            paste.setEnabled(AuthTokenUtil.isToken(data));
        }
        catch (UnsupportedFlavorException | IOException | IllegalStateException ex) {
            log.info("Ignoring " + ex);
        }
    }

    private void persistToken() {
        AuthTokenPanel.setAuthToken(this.authTokenTestField.getText());
        PersistentConfiguration.getConfig().save();
    }

    private void onTextChange() {
        if (AuthTokenUtil.isToken(this.authTokenTestField.getText())) {
            this.persistToken();
        }
    }

    public JPanel getContent() {
        return this.content;
    }

    public static boolean hasToken() {
        return AuthTokenUtil.isToken(AuthTokenPanel.getAuthToken());
    }

    public String getToken() {
        return this.authTokenTestField.getText();
    }

    public static void showError(JComponent parent) {
        JOptionPane.showMessageDialog(parent, "Does not work without auth token, see below.", "Auth Token", 0);
    }
}

