/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.trigger;

import com.rusefi.trigger.TriggerSignal;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TriggerSignalReader {
    @NotNull
    public static List<TriggerSignal> readSignals(BufferedReader reader, int count) throws IOException {
        ArrayList<TriggerSignal> signals = new ArrayList<TriggerSignal>();
        int index = 0;
        while (index < count) {
            String line = reader.readLine();
            if (line.trim().startsWith("#")) continue;
            String[] tokens = line.split(" ");
            if (tokens.length < 4) {
                throw new IllegalStateException("Unexpected [" + line + "]");
            }
            int signalIndex = Integer.parseInt(tokens[2]);
            int signalState = Integer.parseInt(tokens[3]);
            double angle = Double.parseDouble(tokens[4]);
            double gap = TriggerSignalReader.parseDoubleMaybeNaN(tokens[5]);
            TriggerSignal s = new TriggerSignal(signalIndex, signalState, angle, gap);
            signals.add(s);
            ++index;
        }
        return signals;
    }

    private static double parseDoubleMaybeNaN(String doubleString) {
        if ("nan".equalsIgnoreCase(doubleString)) {
            return Double.NaN;
        }
        return Double.parseDouble(doubleString);
    }
}

