/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public class WindDirection
extends AbstractRadial {
    private double visibleValue = 0.0;
    private double angleStep;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage pointerImage;
    private BufferedImage pointer2Image;
    private BufferedImage disabledImage;
    private ColorDef pointer2Color = ColorDef.BLUE;
    private CustomColorDef customPointer2Color = new CustomColorDef(Color.BLUE);
    private PointerType pointer2Type = PointerType.TYPE3;
    private boolean pointer2Visible;
    private double value2;
    private Timeline timeline = new Timeline(this);
    private final Spline EASE = new Spline(0.5f);
    private long easingDuration = 250L;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public WindDirection() {
        this.setMinValue(-360.0);
        this.setMaxValue(360.0);
        this.setPointerType(PointerType.TYPE5);
        this.setLcdColor(LcdColor.BLACK_LCD);
        this.setValueCoupled(false);
        this.setLcdDecimals(1);
        this.setLcdVisible(true);
        this.calcAngleStep();
        this.value2 = 0.0;
        this.pointer2Visible = true;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n4 * 0.15f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n4 * 0.15f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n4 * 0.15f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n4 * 0.15f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n4 * 0.15f));
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        this.create_SHIP_Image(n4, this.bImage);
        this.create_TITLE_Image(n4, this.getTitle(), this.getUnitString(), this.bImage);
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        this.create_TICKMARKS_Image(n4, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, true, true, null, this.bImage);
        this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)n4 * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)n4 * 0.4, (double)n4 * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
        this.LCD.setRect(((double)this.getGaugeBounds().width - (double)n4 * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)n4 * 0.4, (double)n4 * 0.15);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n4, this.getPointerType());
        if (this.pointer2Image != null) {
            this.pointer2Image.flush();
        }
        this.pointer2Image = this.create_POINTER_Image(n4, this.pointer2Type, this.pointer2Color, this.customPointer2Color);
        this.createPostsImage(n4, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isLcdVisible()) {
            double d;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - d - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * (double)0.76f));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.rotate(this.value2 * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointer2Image, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(this.getValue() * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public void setValue(double d) {
        if (this.isEnabled()) {
            super.setValue(d % 360.0);
            if (d % 360.0 == 0.0) {
                this.visibleValue = 90.0;
            }
            if (d % 360.0 > 0.0 && d % 360.0 <= 180.0) {
                this.visibleValue = d % 360.0;
            }
            if (d % 360.0 > 180.0 && d % 360.0 <= 360.0) {
                this.visibleValue = 360.0 - d % 360.0;
            }
            if (this.isValueCoupled()) {
                this.setLcdValue(this.visibleValue);
            }
            this.fireStateChanged();
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.getValue(), d);
            this.timeline.setEase(this.EASE);
            this.timeline.setDuration(this.easingDuration);
            this.timeline.play();
        }
    }

    @Override
    public double getMinValue() {
        return -360.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    public long getEasingDuration() {
        return this.easingDuration;
    }

    public void setEasingDuration(long l) {
        this.easingDuration = l;
    }

    public ColorDef getPointer2Color() {
        return this.pointer2Color;
    }

    public void setPointer2Color(ColorDef colorDef) {
        this.pointer2Color = colorDef;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public double getValue2() {
        return this.value2;
    }

    public void setValue2(double d) {
        if (this.isEnabled()) {
            this.value2 = d % 360.0;
            this.fireStateChanged();
            this.repaint(this.getInnerBounds());
        }
    }

    public boolean isPointer2Visible() {
        return this.pointer2Visible;
    }

    public void setPointer2Visible(boolean bl) {
        this.pointer2Visible = bl;
        this.repaint(this.getInnerBounds());
    }

    public PointerType getPointer2Type() {
        return this.pointer2Type;
    }

    public void setPointer2Type(PointerType pointerType) {
        this.pointer2Type = pointerType;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomPointer2Color() {
        return this.customPointer2Color.COLOR;
    }

    public void setCustomPointer2Color(Color color) {
        this.customPointer2Color = new CustomColorDef(color);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomPointer2ColorObject() {
        return this.customPointer2Color;
    }

    private void calcAngleStep() {
        this.angleStep = Math.PI / 180;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void createSections(BufferedImage bufferedImage) {
        if (this.bImage != null) {
            double d = 90.0;
            double d2 = 1.0;
            double d3 = (float)this.bImage.getWidth() * 0.38f;
            double d4 = (float)this.bImage.getWidth() * 0.38f - (float)this.bImage.getWidth() * 0.04f;
            double d5 = (double)this.bImage.getWidth() / 2.0 - d3;
            double d6 = (double)this.bImage.getWidth() / 2.0 - d4;
            Ellipse2D.Double double_ = new Ellipse2D.Double((double)this.bImage.getMinX() + d6, (double)this.bImage.getMinY() + d6, 2.0 * d4, 2.0 * d4);
            for (Section object : this.getSections()) {
                double section = d - object.getStart() * d2 + this.getMinValue() * d2;
                double d7 = -(object.getStop() - object.getStart()) * d2;
                Arc2D.Double double_2 = new Arc2D.Double(2);
                double_2.setFrame((double)this.bImage.getMinX() + d5, (double)this.bImage.getMinY() + d5, 2.0 * d3, 2.0 * d3);
                ((Arc2D)double_2).setAngleStart(section);
                ((Arc2D)double_2).setAngleExtent(d7);
                Area area = new Area(double_2);
                area.subtract(new Area(double_));
                object.setSectionArea(area);
            }
            if (this.isSectionsVisible() && bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    graphics2D.setColor(section.getColor());
                    graphics2D.fill(section.getSectionArea());
                }
                graphics2D.dispose();
            }
        }
    }

    protected BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2, int n3, boolean bl, boolean bl2, ArrayList<Section> arrayList, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        int n6 = (int)(0.08 * (double)n);
        int n7 = (int)(0.02 * (double)n);
        int n8 = (int)(0.04 * (double)n);
        float f = (float)n4 * 0.38f;
        Point2D.Double double_ = new Point2D.Double((float)n4 / 2.0f, (float)n5 / 2.0f);
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_4 = new Point2D.Double(0.0, 0.0);
        Line2D.Double double_5 = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double double_6 = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        int n9 = (int)(0.0186915888 * (double)n);
        int n10 = (int)(0.03 * (double)n);
        int n11 = 0;
        int n12 = 0;
        float f2 = 90.0f;
        boolean bl3 = false;
        float f3 = 1.0f;
        graphics2D.setFont(font);
        double d6 = 0.0;
        double d7 = 0.0;
        for (double d8 = Math.PI * 2; d8 >= Math.PI / 180; d8 -= Math.PI / 180) {
            graphics2D.setStroke(basicStroke2);
            d6 = Math.sin(d8 - 1.5707963267948966);
            d7 = Math.cos(d8 - 1.5707963267948966);
            if (n11 % 5 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke2);
                ((Point2D)double_2).setLocation(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
                ((Point2D)double_3).setLocation(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                switch (this.getMinorTickmarkType()) {
                    case LINE: {
                        double_5.setLine(double_2, double_3);
                        graphics2D.draw(double_5);
                        break;
                    }
                    case CIRCLE: {
                        ((RectangularShape)double_6).setFrame(((Point2D)double_3).getX() - (double)n9 / 2.0, ((Point2D)double_3).getY() - (double)n9 / 2.0, n9, n9);
                        graphics2D.fill(double_6);
                        break;
                    }
                    default: {
                        double_5.setLine(double_2, double_3);
                        graphics2D.draw(double_5);
                    }
                }
            }
            if (n11 == 30 || n11 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke);
                ((Point2D)double_2).setLocation(((Point2D)double_).getX() + (double)(f - (float)n8) * d6, ((Point2D)double_).getY() + (double)(f - (float)n8) * d7);
                ((Point2D)double_3).setLocation(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                ((Point2D)double_4).setLocation(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
                graphics2D.setFont(font);
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)f2), (int)((Point2D)double_4).getX(), (int)((Point2D)double_4).getY(), 0.0));
                n11 = 0;
                ++n12;
                switch (this.getMajorTickmarkType()) {
                    case LINE: {
                        double_5.setLine(double_2, double_3);
                        graphics2D.draw(double_5);
                        break;
                    }
                    case CIRCLE: {
                        ((RectangularShape)double_6).setFrame(((Point2D)double_3).getX() - (double)n10 / 2.0, ((Point2D)double_3).getY() - (double)n10 / 2.0, n10, n10);
                        graphics2D.fill(double_6);
                        break;
                    }
                    default: {
                        double_5.setLine(double_2, double_3);
                        graphics2D.draw(double_5);
                    }
                }
            }
            ++n11;
            if (f2 == 0.0f) {
                bl3 = true;
            }
            if (f2 == 180.0f) {
                bl3 = false;
            }
            if (bl3) {
                f2 += f3;
                continue;
            }
            f2 -= f3;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SHIP_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.7242990654205608);
        generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.7242990654205608, (double)n2 * 0.45794392523364486, (double)n3 * 0.7383177570093458, (double)n2 * 0.5, (double)n3 * 0.7383177570093458);
        generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.7383177570093458, (double)n2 * 0.5560747663551402, (double)n3 * 0.7242990654205608, (double)n2 * 0.5560747663551402, (double)n3 * 0.7242990654205608);
        generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.7242990654205608, (double)n2 * 0.5654205607476636, (double)n3 * 0.6962616822429907, (double)n2 * 0.5654205607476636, (double)n3 * 0.48598130841121495);
        generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.2897196261682243, (double)n2 * 0.5, (double)n3 * 0.2336448598130841, (double)n2 * 0.5, (double)n3 * 0.2336448598130841);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.2336448598130841, (double)n2 * 0.42990654205607476, (double)n3 * 0.2897196261682243, (double)n2 * 0.42990654205607476, (double)n3 * 0.48598130841121495);
        generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.719626168224299, (double)n2 * 0.4439252336448598, (double)n3 * 0.7242990654205608, (double)n2 * 0.4439252336448598, (double)n3 * 0.7242990654205608);
        generalPath.closePath();
        graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "WindDirection";
    }
}

