/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.simulator;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.bench_mode_e;
import com.rusefi.enums.bench_test_io_control_e;
import com.rusefi.enums.bench_test_magic_numbers_e;
import com.rusefi.enums.bench_test_packet_ids_e;
import com.rusefi.functional_tests.EcuTestHelper;
import com.rusefi.io.LinkManager;
import etch.util.CircularByteBuffer;
import java.io.EOFException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class SimulatorFunctionalTest {
    private static final Logging log = Logging.getLogging(SimulatorFunctionalTest.class);
    private final LinkManager linkManager;
    private boolean gotCanPacketAnalog1 = false;
    private boolean gotCanPacketAnalog2 = false;
    private int pinToggleCounter = 0;
    private final int[] durationsInStateMs = new int[]{0, 0};

    public SimulatorFunctionalTest(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void mainTestBody() throws InterruptedException {
        this.assertHappyTriggerSimulator();
        this.assertVvtPosition();
        this.assertRawAnalogPackets();
        int vvtOutputFrequency = 300;
        this.testPwmPin(bench_mode_e.BENCH_VVT0_VALVE, vvtOutputFrequency);
        this.testOutputPin(bench_mode_e.BENCH_MAIN_RELAY, 1000);
        this.testOutputPin(bench_mode_e.BENCH_FUEL_PUMP, 3000);
        this.testOutputPin(bench_mode_e.BENCH_FAN_RELAY, 2000);
        this.testOutputPin(bench_mode_e.HD_ACR, 800);
        this.testOutputPin(bench_mode_e.HD_ACR2, 800);
        this.testOutputPin(bench_mode_e.BENCH_AC_COMPRESSOR_RELAY, 800);
        this.testOutputPin(bench_mode_e.BENCH_STARTER_ENABLE_RELAY, 4000);
        EcuTestHelper ecu = new EcuTestHelper(this.linkManager);
        ecu.sendCommand(IoUtil.getDisableCommand("self_stimulation"));
        IoUtil.awaitRpm(0);
        this.testOutputPin(bench_mode_e.BENCH_VVT0_VALVE, 300);
    }

    private void assertHappyTriggerSimulator() throws InterruptedException {
        Thread.sleep(5000L);
        double triggerErrors = SensorCentral.getInstance().getValue(Sensor.totalTriggerErrorCounter);
        Assert.assertTrue("triggerErrors " + triggerErrors, triggerErrors < 5.0);
    }

    private void assertVvtPosition() {
        this.assertNear("RPM", SensorCentral.getInstance().getValue(Sensor.RPMValue), 1200.0, 5.0);
        this.assertNear("VVT", SensorCentral.getInstance().getValue(Sensor.vvtPositionB1I), 90.0, 15.0);
    }

    private void assertNear(String message, double actual, double expected, double tolerance) {
        if (!this.nearEq(actual, expected, tolerance)) {
            throw new IllegalStateException(message + " actual=" + actual + " expected=" + expected);
        }
    }

    private int store8bit(byte[] buf, int offset, int int8) {
        buf[offset++] = (byte)int8;
        return offset;
    }

    private int store32bit(byte[] buf, int offset, int int32) {
        buf[offset++] = (byte)(int32 >> 24);
        buf[offset++] = (byte)(int32 >> 16);
        buf[offset++] = (byte)(int32 >> 8);
        buf[offset++] = (byte)int32;
        return offset;
    }

    private void exchangeCanPackets(final CountDownLatch gotCan, final bench_test_packet_ids_e[] expectedEids, final byte[][] packets) {
        this.linkManager.submit(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                void var4_5;
                int numBytes = 1 + 4 * expectedEids.length + 1;
                byte[][] byArray = packets;
                int n = byArray.length;
                boolean bl = false;
                while (var4_5 < n) {
                    byte[] packet = byArray[var4_5];
                    numBytes += packet.length;
                    ++var4_5;
                }
                byte[] allData = new byte[numBytes];
                int offset = SimulatorFunctionalTest.this.store8bit(allData, 0, expectedEids.length);
                for (bench_test_packet_ids_e eid : expectedEids) {
                    offset = SimulatorFunctionalTest.this.store32bit(allData, offset, eid.get());
                }
                offset = SimulatorFunctionalTest.this.store8bit(allData, offset, packets.length);
                for (byte[] packet : packets) {
                    System.arraycopy(packet, 0, allData, offset, packet.length);
                    offset += packet.length;
                }
                byte[] byArray2 = SimulatorFunctionalTest.this.linkManager.getBinaryProtocol().executeCommand('>', allData, "TS_SIMULATE_CAN");
                if (byArray2 == null) {
                    return;
                }
                CircularByteBuffer c = new CircularByteBuffer(byArray2);
                try {
                    int count = IoHelper.swap16(c.getShort());
                    c.get();
                    for (int idx = 0; idx < count; ++idx) {
                        int dataLength = c.get() & 0xF;
                        c.get();
                        c.get();
                        c.get();
                        int eid = c.get();
                        eid |= c.get() << 8;
                        eid |= c.get() << 16;
                        c.get();
                        byte[] data = new byte[dataLength];
                        c.get(data);
                        SimulatorFunctionalTest.this.processCanPacket(eid, data);
                    }
                    log.debug("Got " + count + " CAN packet(s)");
                    gotCan.countDown();
                }
                catch (EOFException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private byte[] getCanFrameData(int eid, byte[] msg) {
        byte[] packet = new byte[]{0, 0, 0, 40, (byte)(eid & 0xFF), (byte)(eid >> 8 & 0xFF), (byte)(eid >> 16 & 0xFF), (byte)(eid >> 24 & 0xFF), 0, 0, 0, 0, 0, 0, 0, 0};
        if (msg.length > 8) {
            throw new RuntimeException("msg.length > 8");
        }
        System.arraycopy(msg, 0, packet, packet.length - 8, msg.length);
        return packet;
    }

    private void executeIoControlCommand(bench_test_io_control_e command, bench_test_packet_ids_e[] expectedEids, byte subCommand) throws InterruptedException {
        CountDownLatch gotCan = new CountDownLatch(1);
        byte[][] packets = new byte[][]{this.getCanFrameData(bench_test_packet_ids_e.IO_CONTROL.get(), new byte[]{(byte)bench_test_magic_numbers_e.BENCH_HEADER.get(), (byte)command.get(), subCommand})};
        this.exchangeCanPackets(gotCan, expectedEids, packets);
        gotCan.await(1L, TimeUnit.MINUTES);
    }

    private void assertRawAnalogPackets() throws InterruptedException {
        CountDownLatch gotCan1 = new CountDownLatch(1);
        this.exchangeCanPackets(gotCan1, new bench_test_packet_ids_e[]{bench_test_packet_ids_e.RAW_ANALOG_1, bench_test_packet_ids_e.RAW_ANALOG_2}, new byte[0][]);
        gotCan1.await(1L, TimeUnit.MINUTES);
        if (!this.gotCanPacketAnalog1 || !this.gotCanPacketAnalog2) {
            throw new IllegalStateException("Didn't receive analog CAN packets! " + this.gotCanPacketAnalog1 + " " + this.gotCanPacketAnalog2);
        }
    }

    private void testPwmPin(bench_mode_e pinId, int freq) throws InterruptedException {
        long startMs = System.currentTimeMillis();
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_QUERY_PIN_STATE, new bench_test_packet_ids_e[]{bench_test_packet_ids_e.PIN_STATE}, (byte)pinId.ordinal());
        int defaultPinToggleCounter = this.pinToggleCounter;
        int numSleepMs = 1000;
        Thread.sleep(numSleepMs);
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_QUERY_PIN_STATE, new bench_test_packet_ids_e[]{bench_test_packet_ids_e.PIN_STATE}, (byte)pinId.ordinal());
        long endMs = System.currentTimeMillis();
        double timeElapsedSec = 0.5 * (double)(endMs - startMs + (long)numSleepMs) / 1000.0;
        double pulses = this.pinToggleCounter - defaultPinToggleCounter;
        double expectedPulses = 2.0 * timeElapsedSec * (double)freq;
        double tolerance = expectedPulses * 0.2;
        if (!this.nearEq(pulses, expectedPulses, tolerance)) {
            throw new IllegalStateException(pinId + ": Unexpected PWM pin coutner: was=" + defaultPinToggleCounter + " now=" + this.pinToggleCounter + " freq=" + freq);
        }
        double periodMs = this.durationsInStateMs[0] + this.durationsInStateMs[1];
        double expectedPeriodMs = 1000.0 / (double)freq;
        if (!this.nearEq(periodMs, expectedPeriodMs, 1.0)) {
            throw new IllegalStateException(pinId + ": Unexpected PWM period: dur[0]=" + this.durationsInStateMs[0] + " dur[1]=" + this.durationsInStateMs[1] + " period=" + expectedPeriodMs);
        }
    }

    private void testOutputPin(bench_mode_e pinId, int stateToggleTimeMs) throws InterruptedException {
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_START_PIN_TEST, new bench_test_packet_ids_e[0], (byte)pinId.ordinal());
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_QUERY_PIN_STATE, new bench_test_packet_ids_e[]{bench_test_packet_ids_e.PIN_STATE}, (byte)pinId.ordinal());
        int defaultPinToggleCounter = this.pinToggleCounter;
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_EXECUTE_BENCH_TEST, new bench_test_packet_ids_e[0], (byte)pinId.ordinal());
        Thread.sleep(stateToggleTimeMs * 2 + 500);
        this.executeIoControlCommand(bench_test_io_control_e.CAN_BENCH_END_PIN_TEST, new bench_test_packet_ids_e[]{bench_test_packet_ids_e.PIN_STATE}, (byte)pinId.ordinal());
        if (this.pinToggleCounter < defaultPinToggleCounter + 3 || this.pinToggleCounter > defaultPinToggleCounter + 4) {
            throw new IllegalStateException(pinId + ": Unexpected pin toggle counter: before=" + defaultPinToggleCounter + " after=" + this.pinToggleCounter);
        }
        if (!this.nearEq(this.durationsInStateMs[1], stateToggleTimeMs, 10)) {
            throw new IllegalStateException(pinId + ": Unexpected pin state duration: [0]=" + this.durationsInStateMs[0] + " [1]=" + this.durationsInStateMs[1] + " toggleTimeMs=" + stateToggleTimeMs);
        }
    }

    private int readInt(byte[] data, int startIdx, int endIdx) {
        int v = 0;
        for (int i = startIdx; i <= endIdx; ++i) {
            v |= (data[i] & 0xFF) << 8 * (endIdx - i);
        }
        return v;
    }

    private void processCanPacket(int eid, byte[] data) {
        if (eid == bench_test_packet_ids_e.RAW_ANALOG_1.get()) {
            this.gotCanPacketAnalog1 = true;
        } else if (eid == bench_test_packet_ids_e.RAW_ANALOG_2.get()) {
            this.gotCanPacketAnalog2 = true;
        } else if (eid == bench_test_packet_ids_e.PIN_STATE.get()) {
            this.pinToggleCounter = this.readInt(data, 0, 1);
            this.durationsInStateMs[0] = this.readInt(data, 2, 4);
            this.durationsInStateMs[1] = this.readInt(data, 5, 7);
        }
    }

    private boolean nearEq(double actual, double expected, double tolerance) {
        return Math.abs(actual - expected) <= tolerance;
    }

    private boolean nearEq(int actual, int expected, int tolerance) {
        return Math.abs(actual - expected) <= tolerance;
    }
}

