/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class DisplayRectangular
extends AbstractLinear {
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage titleImage;
    private BufferedImage lcdImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();

    public DisplayRectangular() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        int n3 = 0;
        if (this.isFrameVisible()) {
            n3 = 18;
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * (float)(this.getHeight() - 2 * n3)));
        } else {
            this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * (float)(this.getHeight() - 2 * n3)));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)(this.getHeight() - 2 * n3)));
        } else {
            this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * (float)(this.getHeight() - 2 * n3)));
        }
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(n, n2);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.isFrameVisible() ? this.create_LCD_Image(n - 2 * n3, n2 - 2 * n3, this.getLcdColor(), this.getCustomLcdBackground()) : this.create_LCD_Image(this.getWidth(), this.getHeight(), this.getLcdColor(), this.getCustomLcdBackground());
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(this.getWidth(), this.getHeight());
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n, n2);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.isFrameVisible()) {
            graphics2D.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.isLcdVisible()) {
            double d;
            int n = 0;
            if (this.isFrameVisible()) {
                n = 18;
            }
            graphics2D.drawImage((Image)this.lcdImage, n, n, null);
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)) + n, (int)((float)this.lcdImage.getHeight() * 0.76f) + n);
                d = this.UNIT_BOUNDARY.getWidth();
            } else {
                d = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
            this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
            graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)((double)this.lcdImage.getWidth() - d - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09) + n, (int)((float)this.lcdImage.getHeight() * 0.76f) + n);
        }
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public boolean isLcdVisible() {
        return true;
    }

    @Override
    public void setValue(double d) {
        this.setLcdValue(d);
    }

    @Override
    public double getValue() {
        return this.getLcdValue();
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2;
        int n = 1;
        if (this.isFrameVisible()) {
            n = 19;
        }
        if ((double_2 = new Point2D.Double(0.0, n)).equals(double_ = new Point2D.Double(0.0, this.getHeight() - n))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.backgroundImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.backgroundImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        int n = 0;
        if (this.isFrameVisible()) {
            n = 17;
        }
        return new Rectangle(n, n, this.lcdImage.getWidth(), this.lcdImage.getHeight());
    }

    @Override
    public String toString() {
        return "DisplayRectangular";
    }
}

