/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ContourGradientPaint;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Transparency;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum GlowImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private Color radGlowColor = Color.RED;
    private boolean radOn = false;
    private GaugeType radGaugeType = GaugeType.TYPE4;
    private boolean radKnobs;
    private Orientation radOrientation;
    private BufferedImage radGlowImage = this.UTIL.createImage(1, 1, 3);
    private int linWidth = 0;
    private int linHeight = 0;
    private Color linGlowColor = Color.RED;
    private boolean linOn = false;
    private BufferedImage linGlowImage = this.UTIL.createImage(1, 1, 3);
    private int lcdWidth = 0;
    private int lcdHeight = 0;
    private Color lcdGlowColor = Color.RED;
    private boolean lcdOn = false;
    private BufferedImage lcdGlowImage = this.UTIL.createImage(1, 1, 3);

    public BufferedImage createRadialGlow(int n, Color color, boolean bl, GaugeType gaugeType, boolean bl2, Orientation orientation) {
        Transparency transparency;
        Color[] colorArray;
        Object[] objectArray;
        Object object;
        Cloneable cloneable;
        if (n <= 0) {
            return null;
        }
        if (this.radWidth == n && this.radGlowColor.equals(color) && this.radOn == bl && this.radGaugeType == gaugeType && this.radKnobs == bl2 && this.radOrientation == orientation) {
            return this.radGlowImage;
        }
        this.radGlowImage.flush();
        this.radGlowImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radGlowImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = this.radGlowImage.getWidth();
        int n3 = this.radGlowImage.getHeight();
        Area area = new Area(new Ellipse2D.Double((double)n2 * 0.0841121495, (double)n2 * 0.0841121495, (double)n2 * 0.8317757009, (double)n2 * 0.8317757009));
        Area area2 = new Area(new Ellipse2D.Double((double)n2 * 0.1074766355, (double)n2 * 0.1074766355, (double)n2 * 0.785046729, (double)n2 * 0.785046729));
        area.subtract(area2);
        if (!bl) {
            cloneable = new Point2D.Double(0.0, area.getBounds2D().getMinY());
            object = new Point2D.Double(0.0, area.getBounds2D().getMaxY());
            objectArray = new float[]{0.0f, 0.17f, 0.33f, 0.34f, 0.63f, 0.64f, 0.83f, 1.0f};
            colorArray = new Color[]{new Color(204, 204, 204, 102), new Color(153, 153, 153, 102), new Color(252, 252, 252, 102), new Color(255, 255, 255, 102), new Color(204, 204, 204, 102), new Color(203, 203, 203, 102), new Color(153, 153, 153, 102), new Color(255, 255, 255, 102)};
            transparency = new LinearGradientPaint((Point2D)cloneable, (Point2D)object, (float[])objectArray, colorArray);
            graphics2D.setPaint((Paint)transparency);
            graphics2D.fill(area);
        } else {
            cloneable = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
            object = new float[]{0.0f, 0.8999999f, 0.9f, 0.95f, 1.0f};
            objectArray = new Color[]{this.UTIL.setAlpha(color, 0.6f), this.UTIL.setAlpha(color, 0.6f), this.UTIL.setSaturation(color, 0.6f), color, this.UTIL.setSaturation(color, 0.6f)};
            colorArray = new RadialGradientPaint((Point2D)cloneable, (float)(0.4158878504672897 * (double)n2), (float[])object, (Color[])objectArray);
            graphics2D.setPaint((Paint)colorArray);
            transparency = Shadow.INSTANCE.createSoftClipImage(area, (Paint)colorArray);
            graphics2D.translate(-16, -16);
            graphics2D.drawImage((Image)Shadow.INSTANCE.createDropShadow((BufferedImage)transparency, 0, 1.0f, 15, 315, color), area.getBounds().x + 1, area.getBounds().y + 1, null);
            graphics2D.translate(16, 16);
            if (bl2) {
                Ellipse2D.Double double_ = new Ellipse2D.Double();
                Point2D.Double double_2 = new Point2D.Double();
                Point2D.Double double_3 = new Point2D.Double();
                float[] fArray = new float[]{0.0f, 0.5f, 1.0f};
                Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 0), this.UTIL.setAlpha(color, 0.0f), this.UTIL.setAlpha(color, 0.3f)};
                Ellipse2D.Double double_4 = new Ellipse2D.Double();
                Point2D.Double double_5 = new Point2D.Double();
                float[] fArray2 = new float[]{0.0f, 0.5f, 0.98f, 1.0f};
                Color[] colorArray3 = new Color[]{this.UTIL.setAlpha(color, 0.0f), this.UTIL.setAlpha(color, 0.1f), this.UTIL.setAlpha(color, 0.2f), this.UTIL.setAlpha(color, 0.1f)};
                block0 : switch (gaugeType) {
                    case TYPE1: {
                        ((RectangularShape)double_).setFrame((double)n2 * 0.13084112107753754, (double)n3 * 0.514018714427948, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMaxX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMinX(), double_.getCenterY());
                        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_).setFrame((double)n2 * 0.5233644843101501, (double)n3 * 0.13084112107753754, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getCenterX(), double_.getMaxY());
                        ((Point2D)double_3).setLocation(double_.getCenterX(), double_.getMinY());
                        linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_4).setFrame((double)n2 * 0.4579439252, (double)n2 * 0.4579439252, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                        ((Point2D)double_5).setLocation(double_4.getCenterX(), double_4.getCenterY());
                        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, (float)(((RectangularShape)double_4).getWidth() / 2.0), fArray2, colorArray3);
                        graphics2D.setPaint(radialGradientPaint);
                        graphics2D.fill(double_4);
                        break;
                    }
                    case TYPE2: {
                        ((RectangularShape)double_).setFrame((double)n2 * 0.13084112107753754, (double)n3 * 0.514018714427948, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMaxX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMinX(), double_.getCenterY());
                        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_).setFrame((double)n2 * 0.8317757248878479, (double)n3 * 0.514018714427948, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMinX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMaxX(), double_.getCenterY());
                        linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_4).setFrame((double)n2 * 0.4579439252, (double)n2 * 0.4579439252, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                        ((Point2D)double_5).setLocation(double_4.getCenterX(), double_4.getCenterY());
                        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, (float)(((RectangularShape)double_4).getWidth() / 2.0), fArray2, colorArray3);
                        graphics2D.setPaint(radialGradientPaint);
                        graphics2D.fill(double_4);
                        break;
                    }
                    case TYPE3: {
                        ((RectangularShape)double_).setFrame((double)n2 * 0.5233644843101501, (double)n3 * 0.8317757248878479, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getCenterX(), double_.getMinY());
                        ((Point2D)double_3).setLocation(double_.getCenterX(), double_.getMaxY());
                        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_).setFrame((double)n2 * 0.8317757248878479, (double)n3 * 0.514018714427948, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMinX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMaxX(), double_.getCenterY());
                        linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_4).setFrame((double)n2 * 0.4579439252, (double)n2 * 0.4579439252, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                        ((Point2D)double_5).setLocation(double_4.getCenterX(), double_4.getCenterY());
                        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, (float)(((RectangularShape)double_4).getWidth() / 2.0), fArray2, colorArray3);
                        graphics2D.setPaint(radialGradientPaint);
                        graphics2D.fill(double_4);
                        break;
                    }
                    case TYPE5: {
                        switch (orientation) {
                            case WEST: {
                                ((RectangularShape)double_).setFrame((double)n2 * 0.4485981308, (double)n3 * 0.7803738318, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                                ((Point2D)double_2).setLocation(double_.getCenterX(), double_.getMinY());
                                ((Point2D)double_3).setLocation(double_.getCenterX(), double_.getMaxY());
                                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                                graphics2D.setPaint(linearGradientPaint);
                                graphics2D.fill(double_);
                                ((RectangularShape)double_).setFrame((double)n2 * 0.4485981308, (double)n3 * 0.1822429907, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                                ((Point2D)double_2).setLocation(double_.getCenterX(), double_.getMaxY());
                                ((Point2D)double_3).setLocation(double_.getCenterX(), double_.getMinY());
                                linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                                graphics2D.setPaint(linearGradientPaint);
                                graphics2D.fill(double_);
                                ((RectangularShape)double_4).setFrame((double)n2 * 0.691588785, (double)n2 * 0.4579439252, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                                LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(new Point2D.Double(double_4.getMinX(), double_4.getCenterY()), new Point2D.Double(double_4.getMaxX(), double_4.getCenterY()), fArray2, colorArray3);
                                graphics2D.setPaint(linearGradientPaint2);
                                graphics2D.fill(double_4);
                                break block0;
                            }
                        }
                        ((RectangularShape)double_).setFrame((double)n2 * 0.1822429907, (double)n3 * 0.4485981308, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMaxX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMinX(), double_.getCenterY());
                        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_).setFrame((double)n2 * 0.7803738318, (double)n3 * 0.4485981308, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMinX(), double_.getCenterY());
                        ((Point2D)double_3).setLocation(double_.getMaxX(), double_.getCenterY());
                        linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_4).setFrame((double)n2 * 0.4579439252, (double)n2 * 0.691588785, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(new Point2D.Double(double_4.getCenterX(), double_4.getMinY()), new Point2D.Double(double_4.getCenterX(), double_4.getMaxY()), fArray2, colorArray3);
                        graphics2D.setPaint(linearGradientPaint3);
                        graphics2D.fill(double_4);
                        break;
                    }
                    default: {
                        ((RectangularShape)double_).setFrame((double)n2 * 0.336448609828949, (double)n3 * 0.8037382960319519, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMaxX(), double_.getMinY());
                        ((Point2D)double_3).setLocation(double_.getMinX(), double_.getMaxY());
                        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_).setFrame((double)n2 * 0.6261682510375977, (double)n3 * 0.8037382960319519, (double)n2 * 0.0373831776, (double)n2 * 0.0373831776);
                        ((Point2D)double_2).setLocation(double_.getMinX(), double_.getMinY());
                        ((Point2D)double_3).setLocation(double_.getMaxX(), double_.getMaxY());
                        linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
                        graphics2D.setPaint(linearGradientPaint);
                        graphics2D.fill(double_);
                        ((RectangularShape)double_4).setFrame((double)n2 * 0.4579439252, (double)n2 * 0.4579439252, (double)n2 * 0.0841121495, (double)n2 * 0.0841121495);
                        ((Point2D)double_5).setLocation(double_4.getCenterX(), double_4.getCenterY());
                        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, (float)(((RectangularShape)double_4).getWidth() / 2.0), fArray2, colorArray3);
                        graphics2D.setPaint(radialGradientPaint);
                        graphics2D.fill(double_4);
                    }
                }
            }
        }
        cloneable = new Area(new Arc2D.Double((double)n2 * 0.0841121495, (double)n2 * 0.0841121495, (double)n2 * 0.8317757009, (double)n2 * 0.8317757009, 270.0, 114.0, 2));
        ((Area)cloneable).subtract(area2);
        object = new Point2D.Double(0.7336448598130841 * (double)n2, 0.8364485981308412 * (double)n3);
        objectArray = new float[]{0.0f, 1.0f};
        colorArray = new Color[]{new Color(255, 255, 255, 140), new Color(255, 255, 255, 0)};
        transparency = new RadialGradientPaint((Point2D)object, (float)(0.23598130841121495 * (double)n2), (float[])objectArray, colorArray);
        graphics2D.setPaint((Paint)transparency);
        graphics2D.fill((Shape)((Object)cloneable));
        graphics2D.dispose();
        this.radWidth = n;
        this.radGlowColor = color;
        this.radOn = bl;
        this.radGaugeType = gaugeType;
        this.radKnobs = bl2;
        this.radOrientation = orientation;
        return this.radGlowImage;
    }

    public BufferedImage createLinearGlow(int n, int n2, Color color, boolean bl) {
        if (n <= 32 || n2 <= 32) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == n && this.linHeight == n2 && this.linGlowColor.equals(color) && this.linOn == bl) {
            return this.linGlowImage;
        }
        this.linGlowImage.flush();
        this.linGlowImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = this.linGlowImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = n;
        int n4 = n2;
        double d = n3 >= n4 ? (double)n4 * 0.05 : (double)n3 * 0.05;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        double d2 = n3 >= n4 ? d - (((RectangularShape)double_).getHeight() - (double)n4 - 2.0) / 2.0 : d - (((RectangularShape)double_).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        double d3 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, d3, d3);
        double d4 = d3 - 1.0;
        Area area = new Area(new RoundRectangle2D.Double(((RectangularShape)double_3).getX() + 1.0, ((RectangularShape)double_3).getY() + 1.0, ((RectangularShape)double_3).getWidth() - 2.0, ((RectangularShape)double_3).getHeight() - 2.0, d4, d4));
        Area area2 = new Area(new RoundRectangle2D.Double(((RectangularShape)double_3).getX() + 6.0, ((RectangularShape)double_3).getY() + 6.0, ((RectangularShape)double_3).getWidth() - 12.0, ((RectangularShape)double_3).getHeight() - 12.0, d4, d4));
        area.subtract(area2);
        if (!bl) {
            Point2D.Double double_4 = new Point2D.Double(0.0, area.getBounds2D().getMinY());
            Point2D.Double double_5 = new Point2D.Double(0.0, area.getBounds2D().getMaxY());
            float[] fArray = new float[]{0.0f, 0.17f, 0.33f, 0.34f, 0.63f, 0.64f, 0.83f, 1.0f};
            Color[] colorArray = new Color[]{new Color(204, 204, 204, 102), new Color(153, 153, 153, 102), new Color(252, 252, 252, 102), new Color(255, 255, 255, 102), new Color(204, 204, 204, 102), new Color(203, 203, 203, 102), new Color(153, 153, 153, 102), new Color(255, 255, 255, 102)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_4, double_5, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(area);
        } else {
            float f = n >= n2 ? 10.0f / (float)area.getBounds().height : 10.0f / (float)area.getBounds().width;
            float[] fArray = new float[]{0.0f, f * 0.1f, f * 0.5f, f, 1.0f};
            Color[] colorArray = new Color[]{this.UTIL.setAlpha(color, 0.0f), this.UTIL.setSaturation(color, 0.6f), color, this.UTIL.setSaturation(color, 0.6f), this.UTIL.setAlpha(color, 0.0f)};
            ContourGradientPaint contourGradientPaint = new ContourGradientPaint(area.getBounds2D(), fArray, colorArray);
            graphics2D.setPaint(contourGradientPaint);
            graphics2D.translate(-10, -10);
            graphics2D.drawImage((Image)Shadow.INSTANCE.createDropShadow(area, contourGradientPaint, color, true, null, null, 0, 1.0f, 10, 315, color), area.getBounds().x, area.getBounds().y, null);
            graphics2D.translate(10, 10);
            Point2D.Double double_6 = new Point2D.Double(area.getBounds2D().getCenterX(), area.getBounds2D().getMinY());
            Point2D.Double double_7 = new Point2D.Double(area.getBounds2D().getCenterX(), area.getBounds2D().getMaxY());
            float[] fArray2 = new float[]{0.0f, 0.1f, 0.2f, 0.2001f, 0.27f, 0.41f, 0.42f, 0.48f, 0.48009998f, 0.55f, 0.5501f, 0.92f, 0.93f, 0.97f, 0.99f, 1.0f};
            Color[] colorArray2 = new Color[]{new Color(255, 255, 255, 140), new Color(255, 255, 255, 0), new Color(255, 255, 255, 50), new Color(255, 255, 255, 60), new Color(255, 255, 255, 45), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 80), new Color(255, 255, 255, 95), new Color(255, 255, 255, 24), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 124), new Color(255, 255, 255, 164)};
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_6, double_7, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(area);
        }
        graphics2D.dispose();
        this.linWidth = n;
        this.linHeight = n2;
        this.linGlowColor = color;
        this.linOn = bl;
        return this.linGlowImage;
    }

    public BufferedImage createLcdGlow(int n, int n2, Color color, boolean bl) {
        if (n <= 1 || n2 <= 1) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.lcdWidth == n && this.lcdHeight == n2 && this.lcdGlowColor.equals(color) && this.lcdOn == bl) {
            return this.lcdGlowImage;
        }
        this.lcdGlowImage.flush();
        this.lcdGlowImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = this.lcdGlowImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        double d = n > n2 ? (double)n2 * 0.095 - 1.0 : (double)n * 0.095 - 1.0;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(1.0, 1.0, n - 2, n2 - 2 - 1, d, d);
        Color[] colorArray = new Color[]{this.UTIL.setAlpha(color, 0.65f), this.UTIL.setAlpha(color, 0.32f), this.UTIL.setAlpha(color, 0.18f), this.UTIL.setAlpha(color, 0.07f), this.UTIL.setAlpha(color, 0.03f), this.UTIL.setAlpha(color, 0.01f)};
        for (int i = 0; i < 6; ++i) {
            graphics2D.setColor(colorArray[i]);
            ((RoundRectangle2D)double_).setRoundRect(i + 1, i + 1, n - 2 - i * 2, n2 - 2 - i * 2, d, d);
            graphics2D.draw(double_);
        }
        graphics2D.dispose();
        this.lcdWidth = n;
        this.lcdHeight = n2;
        this.lcdGlowColor = color;
        this.lcdOn = bl;
        return this.lcdGlowImage;
    }
}

