/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.CommandControl;
import com.rusefi.FixedCommandControl;
import com.rusefi.PerformanceTraceHelper;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.ui.MessagesView;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.UiUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class BenchTestPane {
    private final JPanel content = new JPanel(new GridLayout(2, 5));
    private final UIContext uiContext;

    public BenchTestPane(UIContext uiContext, PersistentConfiguration config) {
        this.uiContext = uiContext;
        this.content.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.content.add(this.grabPerformanceTrace());
        this.content.add(this.createFanTest());
        this.content.add(this.createAcRelayTest());
        this.content.add(this.createFuelPumpTest());
        this.content.add(this.createSparkTest());
        this.content.add(this.createInjectorTest());
        this.content.add(this.createSolenoidTest());
        this.content.add(this.createMILTest());
        this.content.add(this.createIdleTest());
        this.content.add(this.createStarterTest());
        this.content.add(new CommandControl(uiContext, "Reboot", "", "Reboot", new JComponent[0]){

            @Override
            protected String getCommand() {
                return "reboot";
            }
        }.getContent());
        this.content.add(new CommandControl(uiContext, "Reboot to DFU", "", "Reboot to DFU", new JComponent[0]){

            @Override
            protected String getCommand() {
                return "reboot_dfu";
            }
        }.getContent());
        this.content.add(new MessagesView((Node)config.getRoot()).messagesScroll);
    }

    private Component grabPerformanceTrace() {
        JButton button = new JButton("Grab PTrace");
        ActionListener actionListener = e -> this.uiContext.getLinkManager().COMMUNICATION_EXECUTOR.execute(() -> {
            BinaryProtocol bp = this.uiContext.getLinkManager().getCurrentStreamState();
            PerformanceTraceHelper.grabPerformanceTrace(button, bp);
        });
        button.addActionListener(actionListener);
        return UiUtils.wrap(button);
    }

    private Component createMILTest() {
        CommandControl panel = new CommandControl(this.uiContext, "MIL", "check_engine.jpg", "Test", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "milbench";
            }
        };
        return panel.getContent();
    }

    private Component createIdleTest() {
        CommandControl panel = new CommandControl(this.uiContext, "Idle Valve", "idle_valve.png", "Test", new JComponent[0]){

            @Override
            @NotNull
            protected String getCommand() {
                return "idlebench";
            }
        };
        return panel.getContent();
    }

    private Component createStarterTest() {
        FixedCommandControl panel = new FixedCommandControl(this.uiContext, "Starter", "", "Test", "starterbench");
        return ((CommandControl)panel).getContent();
    }

    private Component createFanTest() {
        FixedCommandControl panel = new FixedCommandControl(this.uiContext, "Radiator Fan", "radiator_fan.jpg", "Test", "fanbench");
        return ((CommandControl)panel).getContent();
    }

    private Component createAcRelayTest() {
        FixedCommandControl panel = new FixedCommandControl(this.uiContext, "A/C Compressor Relay", ".jpg", "Test", "acrelaybench");
        return ((CommandControl)panel).getContent();
    }

    private Component createFuelPumpTest() {
        FixedCommandControl panel = new FixedCommandControl(this.uiContext, "Fuel Pump", "fuel_pump.jpg", "Test", "fuelpumpbench");
        return ((CommandControl)panel).getContent();
    }

    private Component createSparkTest() {
        final JComboBox<Integer> indexes = this.createIndexCombo(12);
        CommandControl panel = new CommandControl(this.uiContext, "Spark #", "spark.jpg", "Test", new JComponent[]{indexes}){

            @Override
            protected String getCommand() {
                return "sparkbench2 " + indexes.getSelectedItem() + " 5 333 3";
            }
        };
        return panel.getContent();
    }

    private Component createInjectorTest() {
        final JComboBox<Integer> indexes = this.createIndexCombo(12);
        CommandControl panel = new CommandControl(this.uiContext, "Injector #", "injector.png", "Test", new JComponent[]{indexes}){

            @Override
            protected String getCommand() {
                return "fuelbench2 " + indexes.getSelectedItem() + " 5 333 3";
            }
        };
        return panel.getContent();
    }

    private Component createSolenoidTest() {
        final JComboBox<Integer> indexes = this.createIndexCombo(6);
        CommandControl panel = new CommandControl(this.uiContext, "TCU Solenoid #", "solenoid.jpg", "Test", new JComponent[]{indexes}){

            @Override
            protected String getCommand() {
                return "tcusolbench " + indexes.getSelectedItem() + " 1000 1000 3";
            }
        };
        return panel.getContent();
    }

    @NotNull
    private JComboBox<Integer> createIndexCombo(Integer count) {
        JComboBox<Integer> indexes = new JComboBox<Integer>();
        for (int i = 1; i <= count; ++i) {
            indexes.addItem(i);
        }
        return indexes;
    }

    public JPanel getContent() {
        return this.content;
    }
}

