/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.ui;

import com.rusefi.autoupdate.ReportedIOException;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoupdateUtil {
    public static final boolean runHeadless = Boolean.getBoolean("run_headless") || GraphicsEnvironment.isHeadless();
    private static final String APPICON = "/appicon.png";
    private static final DynamicForResourcesURLClassLoader dynamicResourcesLoader = new DynamicForResourcesURLClassLoader(new URL[0], AutoupdateUtil.class.getClassLoader());

    public static JComponent wrap(JComponent component) {
        AutoupdateUtil.assertAwtThread();
        JPanel result = new JPanel();
        result.add(component);
        return result;
    }

    private static ProgressView createProgressView(String title) {
        if (runHeadless) {
            return new ProgressView(null, null);
        }
        FrameHelper frameHelper = new FrameHelper();
        JProgressBar jProgressBar = new JProgressBar();
        frameHelper.getFrame().setTitle(title);
        jProgressBar.setMaximum(100);
        frameHelper.showFrame(jProgressBar, true);
        return new ProgressView(frameHelper, jProgressBar);
    }

    public static void downloadAutoupdateFile(String localZipFileName, ConnectionAndMeta connectionAndMeta, String title) throws IOException {
        ProgressView view = AutoupdateUtil.createProgressView(title);
        try {
            ConnectionAndMeta.DownloadProgressListener listener = currentProgress -> {
                if (!runHeadless) {
                    SwingUtilities.invokeLater(() -> view.progressBar.setValue(currentProgress));
                }
            };
            ConnectionAndMeta.downloadFile(localZipFileName, connectionAndMeta, listener);
        }
        catch (IOException e) {
            if (view.progressBar != null) {
                JOptionPane.showMessageDialog(view.progressBar, "Error downloading: " + e, "Error", 0);
                throw new ReportedIOException(e);
            }
            throw e;
        }
        finally {
            view.dispose();
        }
    }

    @NotNull
    public static URLClassLoader getClassLoaderByJar(String jar) throws MalformedURLException {
        URL jarURL = new File(jar).toURI().toURL();
        dynamicResourcesLoader.addURL(jarURL);
        return new URLClassLoader(new URL[]{new File(jar).toURI().toURL()}, (ClassLoader)dynamicResourcesLoader);
    }

    public static void trueLayout(Component component) {
        AutoupdateUtil.assertAwtThread();
        if (component == null) {
            return;
        }
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static Window getSelectedWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isActive()) {
                return window;
            }
            Window[] ownedWindows = window.getOwnedWindows();
            if (ownedWindows == null) continue;
            return AutoupdateUtil.getSelectedWindow(ownedWindows);
        }
        return null;
    }

    public static void assertAwtThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            IllegalStateException e = new IllegalStateException("Not on AWT thread but " + Thread.currentThread().getName());
            StringBuilder trace = new StringBuilder(e + "\n");
            for (StackTraceElement element : e.getStackTrace()) {
                trace.append(element.toString()).append("\n");
            }
            SwingUtilities.invokeLater(() -> {
                Window w = AutoupdateUtil.getSelectedWindow(Window.getWindows());
                JOptionPane.showMessageDialog(w, trace, "Error", 0);
            });
        }
    }

    public static boolean hasExistingFile(String zipFileName, long completeFileSize, long lastModified) {
        File file = new File(zipFileName);
        System.out.println("We have " + file.length() + " " + new Date(file.lastModified()) + " " + file.getAbsolutePath());
        return file.length() == completeFileSize && file.lastModified() == lastModified;
    }

    public static ImageIcon loadIcon(String strPath) {
        URL imgURL = dynamicResourcesLoader.getResource(strPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        imgURL = dynamicResourcesLoader.getResource("/com/rusefi/" + strPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static void setAppIcon(JFrame frame) {
        ImageIcon icon = AutoupdateUtil.loadIcon(APPICON);
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
    }

    public static void pack(Window window) {
        AutoupdateUtil.trueLayout(window);
        if (window != null) {
            window.pack();
        }
        AutoupdateUtil.trueLayout(window);
    }

    private static class DynamicForResourcesURLClassLoader
    extends URLClassLoader {
        public DynamicForResourcesURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public DynamicForResourcesURLClassLoader(URL[] urls) {
            super(urls);
        }

        public DynamicForResourcesURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        @Nullable
        public URL getResource(String name) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return super.getResource(name);
        }
    }

    static class ProgressView {
        private final FrameHelper frameHelper;
        private final JProgressBar progressBar;

        ProgressView(FrameHelper frameHelper, JProgressBar progressBar) {
            this.frameHelper = frameHelper;
            this.progressBar = progressBar;
        }

        public void dispose() {
            if (this.frameHelper != null) {
                this.frameHelper.getFrame().dispose();
            }
        }
    }
}

