/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.CompatibleFunction;
import com.rusefi.Listener;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.BinaryProtocolState;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.LinkManager;
import com.rusefi.io.commands.ByteRange;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.tcp.ServerSocketFunction;
import com.rusefi.io.tcp.ServerSocketReference;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.server.rusEFISSLContext;
import com.rusefi.ui.StatusConsumer;
import com.rusefi.util.HexBinary;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryProtocolServer {
    private static final Logging log = Logging.getLogging(BinaryProtocolServer.class);
    private static final int DEFAULT_PROXY_PORT = 2390;
    public static final String TS_OK = "\u0000";
    private static final boolean MOCK_SD_CARD = true;
    private static final int SD_STATUS_OFFSET = 246;
    public final AtomicInteger unknownCommands = new AtomicInteger();
    public static final ServerSocketFunction SECURE_SOCKET_FACTORY;
    private static final ConcurrentHashMap<String, ThreadFactory> THREAD_FACTORIES_BY_NAME;

    public void start(LinkManager linkManager) {
        try {
            this.start(linkManager, 2390, Listener.empty(), new Context());
        }
        catch (IOException e) {
            log.warn("Error starting local proxy: " + e);
        }
    }

    public void start(LinkManager linkManager, int port, Listener serverSocketCreationCallback, Context context) throws IOException {
        log.info("BinaryProtocolServer on " + port);
        CompatibleFunction<Socket, Runnable> clientSocketRunnableFactory = clientSocket -> () -> {
            try {
                this.runProxy(linkManager, (Socket)clientSocket, context);
            }
            catch (IOException e) {
                log.info("proxy connection: " + e);
            }
        };
        BinaryProtocolServer.tcpServerSocket(port, "BinaryProtocolServer", clientSocketRunnableFactory, serverSocketCreationCallback, StatusConsumer.ANONYMOUS);
    }

    public static ServerSocketReference tcpServerSocket(int port, String threadName, CompatibleFunction<Socket, Runnable> socketRunnableFactory, Listener serverSocketCreationCallback, StatusConsumer statusConsumer) throws IOException {
        return BinaryProtocolServer.tcpServerSocket(socketRunnableFactory, port, threadName, serverSocketCreationCallback, (int p) -> {
            ServerSocket serverSocket = new ServerSocket(p);
            statusConsumer.append("ServerSocket " + p + " created. Feel free to point TS at IP Address 'localhost' port " + p);
            return serverSocket;
        });
    }

    public static ServerSocketReference tcpServerSocket(CompatibleFunction<Socket, Runnable> clientSocketRunnableFactory, int port, String threadName, Listener serverSocketCreationCallback, ServerSocketFunction nonSecureSocketFunction) throws IOException {
        ThreadFactory threadFactory = BinaryProtocolServer.getThreadFactory(threadName);
        Objects.requireNonNull(serverSocketCreationCallback, "serverSocketCreationCallback");
        ServerSocket serverSocket = nonSecureSocketFunction.apply(port);
        ServerSocketReference holder = new ServerSocketReference(serverSocket);
        serverSocketCreationCallback.onResult(null);
        Runnable runnable = () -> {
            while (!holder.isClosed()) {
                Socket clientSocket;
                try {
                    clientSocket = serverSocket.accept();
                }
                catch (IOException e) {
                    log.info("Client socket closed right away " + e);
                    continue;
                }
                log.info("Accepting binary protocol proxy port connection on " + port);
                Runnable clientRunnable = (Runnable)clientSocketRunnableFactory.apply(clientSocket);
                Objects.requireNonNull(clientRunnable, "Runnable for " + clientSocket);
                threadFactory.newThread(clientRunnable).start();
            }
        };
        threadFactory.newThread(runnable).start();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ThreadFactory getThreadFactory(String threadName) {
        ConcurrentHashMap<String, ThreadFactory> concurrentHashMap = THREAD_FACTORIES_BY_NAME;
        synchronized (concurrentHashMap) {
            ThreadFactory threadFactory = THREAD_FACTORIES_BY_NAME.get(threadName);
            if (threadFactory == null) {
                threadFactory = new NamedThreadFactory(threadName);
                THREAD_FACTORIES_BY_NAME.put(threadName, threadFactory);
            }
            return threadFactory;
        }
    }

    private void runProxy(LinkManager linkManager, Socket clientSocket, Context context) throws IOException {
        TcpIoStream stream = new TcpIoStream("[proxy] ", clientSocket);
        IncomingDataBuffer in = stream.getDataBuffer();
        while (true) {
            ByteRange byteRange;
            Integer length;
            if ((length = BinaryProtocolServer.getPendingPacketLengthOrHandleProtocolCommand(clientSocket, context, in)) == null) {
                continue;
            }
            byte[] payload = BinaryProtocolServer.getPacketContent(in, length);
            byte command = payload[0];
            log.info("Got command " + BinaryProtocol.findCommand(command));
            if (command == 83) {
                new HelloCommand("rusEFI lts-202403a.2024.03.08.proteus_f7.213393737").handle(stream);
                continue;
            }
            if (command == 70) {
                stream.sendPacket("\u0000001".getBytes());
                continue;
            }
            if (command == 86) {
                stream.sendPacket("\u0000rusEFI proxy".getBytes());
                continue;
            }
            if (command == 107) {
                this.handleCrc(linkManager, stream);
                continue;
            }
            if (command == 80) {
                stream.sendPacket(TS_OK.getBytes());
                continue;
            }
            if (command == 82) {
                byteRange = ByteRange.valueOf(payload);
                this.handleRead(linkManager, byteRange, stream);
                continue;
            }
            if (command == 67) {
                byteRange = ByteRange.valueOf(payload);
                this.handleWrite(linkManager, payload, byteRange, stream);
                continue;
            }
            if (command == 66) {
                stream.sendPacket(new byte[]{4});
                continue;
            }
            if (command == 56) {
                System.err.println("NOT IMPLEMENTED TS_GET_COMPOSITE_BUFFER_DONE_DIFFERENTLY relay");
                stream.sendPacket(TS_OK.getBytes());
                continue;
            }
            if (command == 79) {
                BinaryProtocolState binaryProtocolState = linkManager.getBinaryProtocolState();
                byte[] currentOutputs = binaryProtocolState.getCurrentOutputs();
                byte[] response = BinaryProtocolServer.getOutputCommandResponse(payload, currentOutputs);
                stream.sendPacket(response);
                continue;
            }
            if (command == 71) {
                System.err.println("NOT IMPLEMENTED TS_GET_TEXT relay");
                stream.sendPacket(TS_OK.getBytes());
                continue;
            }
            this.unknownCommands.incrementAndGet();
            new IllegalStateException().printStackTrace();
            log.info("Error: unexpected " + BinaryProtocol.findCommand(command));
        }
    }

    @NotNull
    public static byte[] getOutputCommandResponse(byte[] payload, byte[] currentOutputs) throws IOException {
        ByteRange byteRange = ByteRange.valueOf(payload);
        if (log.debugEnabled()) {
            log.debug("TS_OUTPUT_COMMAND offset=" + byteRange);
        }
        byte[] response = new byte[1 + byteRange.getCount()];
        response[0] = (byte)TS_OK.charAt(0);
        currentOutputs[246] = 5;
        if (currentOutputs != null) {
            System.arraycopy(currentOutputs, byteRange.getOffset(), response, 1, byteRange.getCount());
        }
        return response;
    }

    @NotNull
    public static byte[] getPacketContent(IncomingDataBuffer in, Integer length) throws IOException {
        Packet packet;
        byte[] payload;
        if (log.debugEnabled()) {
            log.debug("Got [" + length + "] length promise");
        }
        if ((payload = (packet = BinaryProtocolServer.readPromisedBytes(in, (int)length)).getPacket()).length == 0) {
            throw new IOException("Empty packet");
        }
        return payload;
    }

    @Nullable
    public static Integer getPendingPacketLengthOrHandleProtocolCommand(Socket clientSocket, Context context, IncomingDataBuffer in) throws IOException {
        AtomicBoolean handled = new AtomicBoolean();
        Handler protocolCommandHandler = () -> {
            BinaryProtocolServer.handleProtocolCommand(clientSocket);
            handled.set(true);
        };
        int length = BinaryProtocolServer.getPacketLength(in, protocolCommandHandler, context.getTimeout());
        if (handled.get()) {
            return null;
        }
        return length;
    }

    public static int getPacketLength(IncomingDataBuffer in, Handler protocolCommandHandler) throws IOException {
        return BinaryProtocolServer.getPacketLength(in, protocolCommandHandler, 5000);
    }

    public static int getPacketLength(IncomingDataBuffer in, Handler protocolCommandHandler, int ioTimeout) throws IOException {
        byte first = in.readByte(ioTimeout);
        if (first == 70) {
            protocolCommandHandler.handle();
            return 0;
        }
        byte secondByte = in.readByte(ioTimeout);
        return IoHelper.getInt(first, secondByte);
    }

    public static Packet readPromisedBytes(DataInputStream in, int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException(String.format("Negative %d %x", length, length));
        }
        byte[] packet = new byte[length];
        int size = in.read(packet);
        if (size != packet.length) {
            throw new IOException(size + " promised but " + packet.length + " arrived");
        }
        int crc = in.readInt();
        if (crc != IoHelper.getCrc32(packet)) {
            throw new IOException("CRC mismatch");
        }
        return new Packet(packet, crc);
    }

    public static Packet readPromisedBytes(IncomingDataBuffer in, int length) throws IOException {
        if (length <= 0) {
            throw new IOException("Unexpected packed length " + length);
        }
        byte[] packet = new byte[length];
        in.read(packet);
        int crc = in.readInt();
        int fromPacket = IoHelper.getCrc32(packet);
        if (crc != fromPacket) {
            throw new IOException("CRC mismatch crc=" + Integer.toString(crc, 16) + " vs packet=" + Integer.toString(fromPacket, 16) + " len=" + packet.length + " data: " + HexBinary.printHexBinary(packet));
        }
        in.onPacketArrived();
        return new Packet(packet, crc);
    }

    public static void handleProtocolCommand(Socket clientSocket) throws IOException {
        if (log.debugEnabled()) {
            log.debug("Got plain GetProtocol F command");
        }
        OutputStream outputStream = clientSocket.getOutputStream();
        outputStream.write("001".getBytes());
        outputStream.flush();
    }

    private void handleWrite(LinkManager linkManager, byte[] packet, ByteRange byteRange, TcpIoStream stream) throws IOException {
        int offset = byteRange.getOffset();
        int count = byteRange.getCount();
        log.info("TS_CHUNK_WRITE_COMMAND: offset=" + byteRange);
        BinaryProtocolState bp = linkManager.getBinaryProtocolState();
        bp.setRange(packet, 7, offset, count);
        stream.sendPacket(TS_OK.getBytes());
    }

    private void handleRead(LinkManager linkManager, ByteRange byteRange, TcpIoStream stream) throws IOException {
        int offset = byteRange.getOffset();
        int count = byteRange.getCount();
        if (count <= 0) {
            log.info("Error: negative read request " + byteRange);
        } else {
            if (log.debugEnabled()) {
                log.debug("read " + offset + "/" + count);
            }
            BinaryProtocolState bp = linkManager.getBinaryProtocolState();
            byte[] response = new byte[1 + count];
            response[0] = (byte)TS_OK.charAt(0);
            Objects.requireNonNull(bp, "bp");
            ConfigurationImage configurationImage = bp.getControllerConfiguration();
            Objects.requireNonNull(configurationImage, "configurationImage");
            System.arraycopy(configurationImage.getContent(), offset, response, 1, count);
            stream.sendPacket(response);
        }
    }

    private void handleCrc(LinkManager linkManager, TcpIoStream stream) throws IOException {
        log.info("CRC check");
        BinaryProtocolState bp = linkManager.getBinaryProtocolState();
        byte[] content = bp.getControllerConfiguration().getContent();
        byte[] packet = BinaryProtocolServer.createCrcResponse(content);
        stream.sendPacket(packet);
    }

    @NotNull
    public static byte[] createCrcResponse(byte[] content) throws IOException {
        int crc32value = IoHelper.getCrc32(content);
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        response.write(TS_OK.charAt(0));
        new DataOutputStream(response).writeInt(crc32value);
        return response.toByteArray();
    }

    static {
        log.configureDebugEnabled(false);
        SECURE_SOCKET_FACTORY = rusEFISSLContext::getSSLServerSocket;
        THREAD_FACTORIES_BY_NAME = new ConcurrentHashMap();
    }

    public static class Context {
        public int getTimeout() {
            return 5000;
        }
    }

    public static class Packet {
        private final byte[] packet;
        private final int crc;

        public Packet(byte[] packet, int crc) {
            this.packet = packet;
            this.crc = crc;
        }

        public byte[] getPacket() {
            return this.packet;
        }

        public int getCrc() {
            return this.crc;
        }
    }

    public static interface Handler {
        public void handle() throws IOException;
    }
}

