/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.EngineState;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.io.CommandQueue;
import com.rusefi.ui.LogSizeControl;
import com.rusefi.ui.util.UiUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public class MessagesView {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss_SSS");
    private final Style bold;
    private final Style italic;
    private final Node config;
    private boolean isPaused;
    protected final JTextPane messages = new JTextPane();
    public final JScrollPane messagesScroll = new JScrollPane(this.messages, 22, 30);
    public Listener listener = Listener.VOID;

    public MessagesView(Node config) {
        this.config = config;
        this.messages.setEditable(false);
        UiUtils.installPopupMenu(this.createPopupMenu(), this.messages);
        StyledDocument d = (StyledDocument)this.messages.getDocument();
        this.bold = d.addStyle("StyleName", null);
        this.bold.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        this.italic = d.addStyle("StyleName", null);
        this.italic.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.TRUE);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                String date = DATE_FORMAT.format(new Date());
                if (!MessagesView.this.isPaused) {
                    MessagesView.this.append(date + ": " + clazz.getSimpleName() + ": " + message, clazz);
                    MessagesView.this.listener.onMessage(message);
                }
            }
        });
    }

    @NotNull
    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(UiUtils.createCopyMenu(this.messages));
        menu.add(new JPopupMenu.Separator());
        JMenuItem pause = new JMenuItem("Pause/Resume");
        pause.addActionListener(e -> this.setPaused(!this.isPaused));
        menu.add(pause);
        JMenuItem clear = new JMenuItem("Clear");
        clear.addActionListener(e -> this.clear());
        menu.add(clear);
        return menu;
    }

    private void append(String line, Class clazz) {
        Document d = this.messages.getDocument();
        int logSizeControl = LogSizeControl.getValue(this.config);
        if (d.getLength() > logSizeControl) {
            this.clearMessages(d, logSizeControl);
        }
        try {
            d.insertString(d.getLength(), line + "\r\n", this.getStyle(clazz));
            this.messages.select(d.getLength(), d.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    private AttributeSet getStyle(Class clazz) {
        if (clazz == CommandQueue.COMMAND_QUEUE_CLASS) {
            return this.bold;
        }
        if (clazz == EngineState.ENGINE_STATE_CLASS) {
            return this.italic;
        }
        return null;
    }

    private void clearMessages(Document d, int logSizeControl) {
        try {
            d.remove(0, d.getLength() - logSizeControl / 2);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void clear() {
        Document d = this.messages.getDocument();
        this.clearMessages(d, 0);
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public static interface Listener {
        public static final Listener VOID = message -> {};

        public void onMessage(String var1);
    }
}

