/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.MessagesCentral;
import com.rusefi.io.commands.PTraceHelper;
import com.rusefi.tools.ConsoleTools;
import com.rusefi.tracing.Entry;
import com.rusefi.tracing.JsonOutput;
import com.rusefi.ui.RpmModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PerformanceTraceHelper {
    public static void grabPerformanceTrace(JComponent parent, BinaryProtocol bp) {
        if (bp == null) {
            String msg = "Failed to locate serial ports";
            JOptionPane.showMessageDialog(parent, msg, msg, 0);
            return;
        }
        try {
            List<Entry> data = PTraceHelper.requestWaitAndGetPTrace(bp);
            if (data.isEmpty()) {
                String msg = "Empty PERF_TRACE response";
                JOptionPane.showMessageDialog(parent, msg, msg, 0);
                return;
            }
            MessagesCentral.getInstance().postMessage(PerformanceTraceHelper.class, "Got " + data.size() + " PTrace entries");
            int rpm = RpmModel.getInstance().getValue();
            String fileName = FileLog.getDate() + "_rpm_" + rpm + "_rusEFI_trace.json";
            File outputFile = new File(fileName);
            JsonOutput.writeToStream(data, new FileOutputStream(outputFile));
            MessagesCentral.getInstance().postMessage(PerformanceTraceHelper.class, "Saved to " + outputFile.getAbsolutePath());
            MessagesCentral.getInstance().postMessage(PerformanceTraceHelper.class, "See https://github.com/rusefi/rusefi/wiki/Developer-Performance-Tracing");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void getPerformanceTune() {
        ConsoleTools.startAndConnect(linkManager -> {
            BinaryProtocol binaryProtocol = linkManager.getConnector().getBinaryProtocol();
            PerformanceTraceHelper.grabPerformanceTrace(null, binaryProtocol);
            System.exit(0);
            return null;
        });
    }
}

