/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.extras.Poi;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public enum PoiUtil {
    INSTANCE;


    public double distanceTo(Poi poi, Poi poi2) {
        return this.distanceTo(poi.getLon(), poi.getLat(), poi2.getLon(), poi2.getLat());
    }

    public double distanceTo(double d, double d2, double d3, double d4) {
        return Math.abs(Math.acos(Math.sin(Math.toRadians(d)) * Math.sin(Math.toRadians(d3)) + Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d2 - d4))) * 6371000.0);
    }

    public Poi shiftTo(Poi poi, double d, double d2) {
        double d3 = Math.toRadians(poi.getLon());
        double d4 = Math.toRadians(poi.getLat());
        double d5 = Math.asin(Math.sin(d4) * Math.cos(d / 6371000.0) + Math.cos(d4) * Math.sin(d / 6371000.0) * Math.cos(Math.toRadians(d2)));
        double d6 = d3 + Math.atan2(Math.sin(Math.toRadians(d2)) * Math.sin(d / 6371000.0) * Math.cos(d4), Math.cos(d / 6371000.0) - Math.sin(d4) * Math.sin(d5));
        double d7 = (d6 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new Poi(poi.getName(), Math.toDegrees(d7), Math.toDegrees(d5));
    }

    public Poi shiftTo(String string, double d, double d2, double d3, double d4) {
        return this.shiftTo(new Poi(string, d, d2), d3, d4);
    }

    public Point2D toXY(double d, double d2, Rectangle rectangle) {
        double d3 = d * -1.0 + 90.0;
        double d4 = d2 + 180.0;
        double d5 = Math.round(d4 * (rectangle.getWidth() / 360.0));
        double d6 = Math.round(d3 * (rectangle.getHeight() / 180.0));
        return new Point2D.Double(d5, d6);
    }

    public Point2D toXY(Poi poi, Rectangle rectangle) {
        return this.toXY(poi.getLat(), poi.getLon(), rectangle);
    }
}

