/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.RawIniFile;
import java.util.ArrayList;
import java.util.List;

public class IniFileMetaInfo {
    public static final int DEFAULT_BLOCKING_FACTOR = 16000;
    private final int nPages;
    private final String signature;
    private final List<String> pageReadCommands;
    private int totalSize;
    private final List<Integer> pageSizes = new ArrayList<Integer>();
    private final int blockingFactor;

    public IniFileMetaInfo(RawIniFile file) {
        this.nPages = file.getSimpleIntegerProperty("nPages", 1);
        this.blockingFactor = file.getSimpleIntegerProperty("blockingFactor", 16000);
        this.signature = file.getValues("signature").get(0);
        List<String> individualPageSizes = file.getValues("pageSize");
        if (individualPageSizes.size() != this.nPages) {
            throw new IllegalStateException("Unexpected individual sizes: " + individualPageSizes);
        }
        for (String value : individualPageSizes) {
            int size = Integer.parseInt(value);
            this.pageSizes.add(size);
            this.totalSize += size;
        }
        this.pageReadCommands = file.getValues("pageReadCommand");
    }

    public int getnPages() {
        return this.nPages;
    }

    public int getBlockingFactor() {
        return this.blockingFactor;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getPageReadCommand(int pageIndex) {
        return this.pageReadCommands.get(pageIndex);
    }

    public int getPageSize(int pageIndex) {
        return this.pageSizes.get(pageIndex);
    }
}

