/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import com.rusefi.util.LazyFile;
import java.io.IOException;

public class SdCardFieldsContent {
    public static final String SD_CARD_OUTPUT_FILE_NAME = "console/binary_log/log_fields_generated.h";
    private final StringBuilder body = new StringBuilder();
    public String home = "test->reference";
    public String conditional;
    public Boolean isPtr = false;

    public static void wrapContent(LazyFile output, String content) {
        output.write("// generated by " + SdCardFieldsContent.class + "\n");
        output.write("static const LogField fields[] = {\n{packedTime, GAUGE_NAME_TIME, \"sec\", 0},\n");
        output.write(content);
        output.write("};\n");
    }

    public void handleEndStruct(ReaderState state, ConfigStructure structure) throws IOException {
        if (state.isStackEmpty()) {
            PerFieldWithStructuresIterator.Strategy strategy = new PerFieldWithStructuresIterator.Strategy(){

                @Override
                public String process(ReaderState state, ConfigField configField, String prefix) {
                    return SdCardFieldsContent.this.processOutput(configField, prefix);
                }

                @Override
                public String getArrayElementName(ConfigField cf) {
                    return cf.getOriginalArrayName();
                }
            };
            PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(state, structure.getTsFields(), "", strategy, ".");
            iterator.loop();
            String content = iterator.getContent();
            this.body.append(content);
        }
    }

    private String processOutput(ConfigField configField, String prefix) {
        if (configField.getName().startsWith("alignmentFill_at_")) {
            return "";
        }
        if (configField.getName().startsWith("unused")) {
            return "";
        }
        if (configField.isBit()) {
            return "";
        }
        String name = configField.getOriginalArrayName();
        return this.getLine(configField, prefix, prefix + name);
    }

    private String getLine(ConfigField configField, String prefix, String name) {
        Object categoryStr = configField.getCategory();
        categoryStr = categoryStr == null ? "" : ", " + (String)categoryStr;
        boolean isEnum = configField.getType().contains("_e");
        if (isEnum) {
            return "";
        }
        String before = this.conditional == null ? "" : "#if " + this.conditional + "\n";
        String after = this.conditional == null ? "" : "#endif\n";
        return before + "\t{" + this.home + (this.isPtr != false ? "->" : ".") + name + ", " + DataLogConsumer.getHumanGaugeName(prefix, configField, "") + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + ", " + configField.getDigits() + (String)categoryStr + "},\n" + after;
    }

    public String getBody() {
        return this.body.toString();
    }
}

