/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu.android;

import android.hardware.usb.UsbDeviceConnection;
import com.rusefi.dfu.DfuCommmand;
import com.rusefi.dfu.DfuConnection;
import com.rusefi.dfu.FlashRange;
import java.nio.ByteBuffer;

public class AndroidDfuConnection
implements DfuConnection {
    private final UsbDeviceConnection usbDeviceConnection;
    private final int interfaceNumber;
    private final int transferSize;
    private final FlashRange flashRange;
    private static final byte REQUEST_TYPE_CLASS = 32;
    private static final byte RECIPIENT_INTERFACE = 1;

    public AndroidDfuConnection(UsbDeviceConnection usbDeviceConnection, int interfaceNumber, int transferSize, FlashRange flashRange) {
        this.usbDeviceConnection = usbDeviceConnection;
        this.interfaceNumber = interfaceNumber;
        this.transferSize = transferSize;
        this.flashRange = flashRange;
    }

    @Override
    public FlashRange getFlashRange() {
        return this.flashRange;
    }

    @Override
    public int getTransferSize() {
        return this.transferSize;
    }

    @Override
    public int receiveData(DfuCommmand command, short wValue, ByteBuffer data) {
        return this.transfer(this.usbDeviceConnection, 128, command.getValue(), wValue, data);
    }

    @Override
    public int sendData(DfuCommmand command, short wValue, ByteBuffer data) {
        return this.transfer(this.usbDeviceConnection, 0, command.getValue(), wValue, data);
    }

    @Override
    public ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    private int transfer(UsbDeviceConnection connection, int direction, int request, short wValue, ByteBuffer byteBuffer) {
        if (!byteBuffer.hasArray() || byteBuffer.arrayOffset() != 0) {
            throw new IllegalArgumentException("Need a simpler ByteArray");
        }
        return connection.controlTransfer(0x21 | direction, request, (int)wValue, this.interfaceNumber, byteBuffer.array(), byteBuffer.limit(), 10000);
    }
}

