/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.core.FileUtil;
import com.rusefi.core.Sensor;
import java.nio.ByteBuffer;

public interface ISensorHolder {
    default public void grabSensorValues(byte[] response) {
        for (Sensor sensor : Sensor.values()) {
            int size;
            if (sensor.getType() == null) continue;
            int offset = 1 + sensor.getOffset();
            if (offset + (size = 4) > response.length) {
                throw new IllegalArgumentException(sensor + String.format(" but %d+%d in %d", offset, size, response.length));
            }
            ByteBuffer bb = FileUtil.littleEndianWrap(response, offset, size);
            double rawValue = sensor.getValueForChannel(bb);
            double scaledValue = rawValue * sensor.getScale();
            this.setValue(scaledValue, sensor);
        }
    }

    public double getValue(Sensor var1);

    public boolean setValue(double var1, Sensor var3);
}

