/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.PointerType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.Timer;
import javax.swing.border.Border;

public final class Clock
extends AbstractRadial
implements ActionListener {
    private static final double ANGLE_STEP = 6.0;
    private final Timer CLOCK_TIMER;
    private boolean automatic = false;
    private double minutePointerAngle = (double)Calendar.getInstance().get(12) * 6.0;
    private double hourPointerAngle = (double)Calendar.getInstance().get(10) * 6.0 * 5.0 + 0.5 * (double)Calendar.getInstance().get(12);
    private double secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0;
    private final Rectangle INNER_BOUNDS;
    private boolean secondMovesContinuous = false;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage hourImage;
    private BufferedImage hourShadowImage;
    private BufferedImage minuteImage;
    private BufferedImage minuteShadowImage;
    private BufferedImage knobImage;
    private BufferedImage secondImage;
    private BufferedImage secondShadowImage;
    private BufferedImage topKnobImage;
    private BufferedImage disabledImage;
    private int hour = 11;
    private int minute = 55;
    private int second = 0;
    private int timeZoneOffsetHour = 0;
    private int timeZoneOffsetMinute = 0;
    private boolean secondPointerVisible = true;
    private final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
    private int horizontalAlignment;
    private int verticalAlignment;

    public Clock() {
        this.CLOCK_TIMER = new Timer(1000, this);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setPointerColor(ColorDef.BLACK);
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
    }

    @Override
    public AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        this.CENTER.setLocation(this.INNER_BOUNDS.getCenterX() - (double)this.getInsets().top, this.INNER_BOUNDS.getCenterX() - (double)this.getInsets().top);
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getInnerBounds().width) * 0.0841121495, (double)(-this.getInnerBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n, n, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n, n, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n, n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n, this.bImage);
        }
        this.create_TICKMARKS_Image(n, this.bImage);
        if (this.hourImage != null) {
            this.hourImage.flush();
        }
        this.hourImage = this.create_HOUR_Image(n);
        if (this.hourShadowImage != null) {
            this.hourShadowImage.flush();
        }
        this.hourShadowImage = this.create_HOUR_SHADOW_Image(n);
        if (this.minuteImage != null) {
            this.minuteImage.flush();
        }
        this.minuteImage = this.create_MINUTE_Image(n);
        if (this.minuteShadowImage != null) {
            this.minuteShadowImage.flush();
        }
        this.minuteShadowImage = this.create_MINUTE_SHADOW_Image(n);
        if (this.knobImage != null) {
            this.knobImage.flush();
        }
        this.knobImage = this.create_KNOB_Image(n);
        if (this.secondImage != null) {
            this.secondImage.flush();
        }
        this.secondImage = this.create_SECOND_Image(n);
        if (this.secondShadowImage != null) {
            this.secondShadowImage.flush();
        }
        this.secondShadowImage = this.create_SECOND_SHADOW_Image(n);
        if (this.topKnobImage != null) {
            this.topKnobImage.flush();
        }
        this.topKnobImage = this.create_TOP_KNOB_Image(n);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n, n, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = DISABLED_FACTORY.createRadialDisabled(n);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        graphics2D.rotate(Math.toRadians(this.hourPointerAngle + 2.0 * Math.sin(Math.toRadians(this.hourPointerAngle))), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.hourShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.hourPointerAngle), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.hourImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle + 2.0 * Math.sin(Math.toRadians(this.minutePointerAngle))), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.minuteShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.minuteImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        if (this.getPointerType() == PointerType.TYPE1) {
            graphics2D.drawImage((Image)this.knobImage, 0, 0, null);
        }
        if (this.secondPointerVisible) {
            graphics2D.rotate(Math.toRadians(this.secondPointerAngle + 2.0 * Math.sin(Math.toRadians(this.secondPointerAngle))), this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.secondShadowImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
            graphics2D.rotate(Math.toRadians(this.secondPointerAngle), this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.secondImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.drawImage((Image)this.topKnobImage, 0, 0, null);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean bl) {
        this.automatic = bl;
        if (bl) {
            if (!this.CLOCK_TIMER.isRunning()) {
                this.CLOCK_TIMER.start();
            }
        } else if (this.CLOCK_TIMER.isRunning()) {
            this.CLOCK_TIMER.stop();
        }
        this.repaint(this.getInnerBounds());
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int n) {
        this.hour = n % 12;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int n) {
        this.minute = n % 60;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int n) {
        this.second = n % 60;
        this.calculateAngles(this.hour, this.minute, this.second);
        this.repaint(this.getInnerBounds());
    }

    public int getTimeZoneOffsetHour() {
        return this.timeZoneOffsetHour;
    }

    public void setTimeZoneOffsetHour(int n) {
        this.timeZoneOffsetHour = n;
    }

    public int getTimeZoneOffsetMinute() {
        return this.timeZoneOffsetMinute;
    }

    public void setTimeZoneOffsetMinute(int n) {
        this.timeZoneOffsetMinute = n;
    }

    public boolean isSecondPointerVisible() {
        return this.secondPointerVisible;
    }

    public void setSecondPointerVisible(boolean bl) {
        this.secondPointerVisible = bl;
        this.repaint(this.getInnerBounds());
    }

    public boolean isSecondMovesContinuous() {
        return this.secondMovesContinuous;
    }

    public void setSecondMovesContinuous(boolean bl) {
        if (bl) {
            this.CLOCK_TIMER.setDelay(100);
        } else {
            this.CLOCK_TIMER.setDelay(1000);
        }
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BACKGROUND_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.getFrameType()) {
            case SQUARE: {
                BACKGROUND_FACTORY.createLinearBackground(n, n, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), bufferedImage);
                break;
            }
            default: {
                BACKGROUND_FACTORY.createRadialBackground(n, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), bufferedImage);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_TICKMARKS_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        Color color = this.getBackgroundColor().LABEL_COLOR;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        AffineTransform affineTransform = graphics2D.getTransform();
        switch (this.getPointerType()) {
            case TYPE2: {
                int n3;
                double d = (double)n2 * 0.0140186916;
                double d2 = (double)n2 * 0.0373831776;
                double_.setFrame(this.CENTER.getX() - d / 2.0, (double)n2 * 0.0981308411, d, d2);
                graphics2D.setColor(color);
                for (n3 = 0; n3 < 360; n3 += 6) {
                    graphics2D.setTransform(affineTransform);
                    graphics2D.rotate(Math.toRadians(n3), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(double_);
                }
                double d3 = (double)n2 * 0.0327102804;
                double d4 = (double)n2 * 0.1261682243;
                double_2.setFrame(this.CENTER.getX() - d3 / 2.0, (double)n2 * 0.0981308411, d3, d4);
                for (n3 = 0; n3 < 360; n3 += 30) {
                    graphics2D.setTransform(affineTransform);
                    graphics2D.rotate(Math.toRadians(n3), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(double_2);
                }
                break;
            }
            default: {
                int n4;
                double d = (double)n2 * 0.0093457944;
                double d5 = (double)n2 * 0.0747663551;
                double_.setFrame(this.CENTER.getX() - d / 2.0, (double)n2 * 0.0981308411, d, d5);
                for (n4 = 0; n4 < 360; n4 += 30) {
                    graphics2D.setTransform(affineTransform);
                    graphics2D.rotate(Math.toRadians(n4), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.setColor(color);
                    graphics2D.fill(double_);
                    graphics2D.setColor(color.darker());
                    graphics2D.draw(double_);
                }
                double d6 = (double)n2 * 0.0280373832;
                double d7 = (double)n2 * 0.0841121495;
                double_2.setFrame(this.CENTER.getX() - d6 / 2.0, (double)n2 * 0.0981308411, d6, d7);
                for (n4 = 0; n4 < 360; n4 += 90) {
                    graphics2D.setTransform(affineTransform);
                    graphics2D.rotate(Math.toRadians(n4), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.setColor(color);
                    graphics2D.fill(double_2);
                    graphics2D.setColor(color.darker());
                    graphics2D.draw(double_2);
                }
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HOUR_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double d = (double)n2 * 0.046728972;
                double d2 = (double)n2 * 0.2242990654;
                Rectangle2D.Double double_ = new Rectangle2D.Double(this.CENTER.getX() - d / 2.0, (double)n2 * 0.2897196262, d, d2);
                graphics2D.setPaint(this.getPointerColor().MEDIUM);
                graphics2D.fill(double_);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.21495327102803738);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1822429906542056);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.21495327102803738);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5607476635514018);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                Color color = new Color(14343649);
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HOUR_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.21495327102803738);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1822429906542056);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.21495327102803738);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5607476635514018);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
                generalPath.closePath();
                graphics2D.setColor(this.SHADOW_COLOR);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MINUTE_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double d = (double)n2 * 0.0327102804;
                double d2 = (double)n2 * 0.3878504673;
                Rectangle2D.Double double_ = new Rectangle2D.Double(this.CENTER.getX() - d / 2.0, (double)n2 * 0.1168224299, d, d2);
                graphics2D.setPaint(this.getPointerColor().MEDIUM);
                graphics2D.fill(double_);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.10747663551401869);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.14018691588785046);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                Color color = new Color(14343649);
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MINUTE_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.10747663551401869);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.14018691588785046);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
                generalPath.closePath();
                graphics2D.setColor(this.SHADOW_COLOR);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_KNOB_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.48130841121495327, (double)n2 * 0.4719626168224299, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.45794392523364486, (double)n2 * 0.5467289719626168, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.5327102803738317, (double)n2 * 0.5280373831775701, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5560747663551402, (double)n2 * 0.4532710280373832, (double)n3 * 0.5327102803738317, (double)n2 * 0.4532710280373832, (double)n3 * 0.5046728971962616);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(40, 40, 41, 255), new Color(13, 13, 13, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.4766355140186916, (double)n2 * 0.4766355140186916, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
        generalPath2.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.45794392523364486, (double)n2 * 0.5420560747663551, (double)n3 * 0.4766355140186916, (double)n2 * 0.5420560747663551, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.5233644859813084, (double)n2 * 0.5233644859813084, (double)n3 * 0.5420560747663551, (double)n2 * 0.5, (double)n3 * 0.5420560747663551);
        generalPath2.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5420560747663551, (double)n2 * 0.45794392523364486, (double)n3 * 0.5233644859813084, (double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath2.closePath();
        Point2D.Double double_3 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(238, 240, 242, 255), new Color(101, 105, 109, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SECOND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)n2 * 0.4953271028, (double)n2 * 0.0981308411, (double)n2 * 0.0093457944, (double)n2 * 0.1261682243);
                Rectangle2D.Double double_2 = new Rectangle2D.Double((double)n2 * 0.4906542056, (double)n2 * 0.308411215, (double)n2 * 0.0186915888, (double)n2 * 0.191588785);
                Area area = new Area(double_);
                area.add(new Area(new Ellipse2D.Double((double)n2 * 0.453271028, (double)n2 * 0.2196261682, (double)n2 * 0.0934579439, (double)n2 * 0.0934579439)));
                area.subtract(new Area(new Ellipse2D.Double((double)n2 * 0.4672897196, (double)n2 * 0.2336448598, (double)n2 * 0.0654205607, (double)n2 * 0.0654205607)));
                area.add(new Area(double_2));
                GeneralPath generalPath = new GeneralPath(area);
                graphics2D.setPaint(ColorDef.RED.MEDIUM);
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.11682242990654206);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                Point2D.Double double_3 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.47f, 1.0f};
                Color[] colorArray = new Color[]{new Color(236, 123, 125, 255), new Color(231, 27, 33, 255), new Color(166, 40, 46, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SECOND_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)n2 * 0.4953271028, (double)n2 * 0.0981308411, (double)n2 * 0.0093457944, (double)n2 * 0.1261682243);
                Rectangle2D.Double double_2 = new Rectangle2D.Double((double)n2 * 0.4906542056, (double)n2 * 0.308411215, (double)n2 * 0.0186915888, (double)n2 * 0.191588785);
                Area area = new Area(double_);
                area.add(new Area(new Ellipse2D.Double((double)n2 * 0.453271028, (double)n2 * 0.2196261682, (double)n2 * 0.0934579439, (double)n2 * 0.0934579439)));
                area.subtract(new Area(new Ellipse2D.Double((double)n2 * 0.4672897196, (double)n2 * 0.2336448598, (double)n2 * 0.0654205607, (double)n2 * 0.0654205607)));
                area.add(new Area(double_2));
                GeneralPath generalPath = new GeneralPath(area);
                graphics2D.setPaint(this.SHADOW_COLOR);
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.11682242990654206);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
                generalPath.closePath();
                graphics2D.setPaint(this.SHADOW_COLOR);
                graphics2D.fill(generalPath);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_TOP_KNOB_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                double d = (double)n * 0.0887850467;
                Ellipse2D.Double double_ = new Ellipse2D.Double(this.CENTER.getX() - d / 2.0, this.CENTER.getY() - d / 2.0, d, d);
                graphics2D.setPaint(this.getPointerColor().MEDIUM);
                graphics2D.fill(double_);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48598130841121495, (double)n2 * 0.48598130841121495, (double)n3 * 0.4719626168224299, (double)n2 * 0.5, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.5280373831775701, (double)n3 * 0.48598130841121495, (double)n2 * 0.5280373831775701, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.514018691588785, (double)n2 * 0.514018691588785, (double)n3 * 0.5280373831775701, (double)n2 * 0.5, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5280373831775701, (double)n2 * 0.4719626168224299, (double)n3 * 0.514018691588785, (double)n2 * 0.4719626168224299, (double)n3 * 0.5);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = new Color[]{new Color(221, 223, 223, 255), new Color(38, 40, 41, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.48598130841121495, (double)n2 * 0.48598130841121495, (double)n3 * 0.4766355140186916, (double)n2 * 0.5, (double)n3 * 0.4766355140186916);
                generalPath2.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4766355140186916, (double)n2 * 0.5233644859813084, (double)n3 * 0.48598130841121495, (double)n2 * 0.5233644859813084, (double)n3 * 0.5);
                generalPath2.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.514018691588785, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5233644859813084);
                generalPath2.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5233644859813084, (double)n2 * 0.4766355140186916, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5);
                generalPath2.closePath();
                Point2D.Double double_3 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMinY());
                Point2D.Double double_4 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMaxY());
                float[] fArray2 = new float[]{0.0f, 0.11f, 0.12f, 0.2f, 0.2001f, 1.0f};
                Color[] colorArray2 = new Color[]{new Color(234, 235, 238, 255), new Color(234, 236, 238, 255), new Color(232, 234, 236, 255), new Color(192, 197, 203, 255), new Color(190, 195, 201, 255), new Color(169, 174, 181, 255)};
                LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray2, colorArray2);
                graphics2D.setPaint(linearGradientPaint2);
                graphics2D.fill(generalPath2);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private void calculateAngles(int n, int n2, int n3) {
        this.secondPointerAngle = (double)n3 * 6.0;
        this.minutePointerAngle = (double)n2 * 6.0;
        this.hourPointerAngle = (double)n * 6.0 * 5.0 + 0.5 * (double)this.minute;
    }

    @Override
    public void calcInnerBounds() {
        int n;
        Insets insets = this.getInsets();
        int n2 = n = this.getWidth() - insets.left - insets.right <= this.getHeight() - insets.top - insets.bottom ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        if (!this.isFrameVisible()) {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 1.202247191), (int)((double)n * 1.202247191));
        } else {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, n, n);
        }
    }

    @Override
    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 50 || dimension.height < 50) {
            dimension = new Dimension(50, 50);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n = dimension.width < 50 ? 50 : dimension.width;
        int n2 = dimension.height < 50 ? 50 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMinimumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width > 1080 || dimension.height > 1080) {
            dimension = new Dimension(1080, 1080);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n = dimension.width > 1080 ? 1080 : dimension.width;
        int n2 = dimension.height > 1080 ? 1080 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMaximumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setPreferredSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = n <= n2 ? n : n2;
        super.setSize(n3, n3);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (rectangle.width <= rectangle.height) {
            int n;
            switch (this.verticalAlignment) {
                case 1: {
                    n = rectangle.y;
                    break;
                }
                case 3: {
                    n = rectangle.y + (rectangle.height - rectangle.width);
                    break;
                }
                default: {
                    n = rectangle.y + (rectangle.height - rectangle.width) / 2;
                }
            }
            super.setBounds(rectangle.x, n, rectangle.width, rectangle.width);
        } else {
            int n;
            switch (this.horizontalAlignment) {
                case 2: {
                    n = rectangle.x;
                    break;
                }
                case 4: {
                    n = rectangle.x + (rectangle.width - rectangle.height);
                    break;
                }
                default: {
                    n = rectangle.x + (rectangle.width - rectangle.height) / 2;
                }
            }
            super.setBounds(n, rectangle.y, rectangle.height, rectangle.height);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= n4) {
            int n5;
            switch (this.verticalAlignment) {
                case 1: {
                    n5 = n2;
                    break;
                }
                case 3: {
                    n5 = n2 + (n4 - n3);
                    break;
                }
                default: {
                    n5 = n2 + (n4 - n3) / 2;
                }
            }
            super.setBounds(n, n5, n3, n3);
        } else {
            int n6;
            switch (this.horizontalAlignment) {
                case 2: {
                    n6 = n;
                    break;
                }
                case 4: {
                    n6 = n + (n3 - n4);
                    break;
                }
                default: {
                    n6 = n + (n3 - n4) / 2;
                }
            }
            super.setBounds(n6, n2, n4, n4);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    @Override
    public void dispose() {
        this.CLOCK_TIMER.removeActionListener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.CLOCK_TIMER)) {
            this.secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0 + (double)Calendar.getInstance().get(14) * 6.0 / 1000.0;
            this.hour = Calendar.getInstance().get(10) - this.timeZoneOffsetHour;
            if (this.hour > 12) {
                this.hour -= 12;
            }
            if (this.hour < 0) {
                this.hour += 12;
            }
            this.minute = Calendar.getInstance().get(12) + this.timeZoneOffsetMinute;
            if (this.minute > 60) {
                this.minute -= 60;
                ++this.hour;
            }
            if (this.minute < 0) {
                this.minute += 60;
                --this.hour;
            }
            this.hourPointerAngle = (double)this.hour * 6.0 * 5.0 + 0.5 * (double)this.minute;
            this.minutePointerAngle = (double)this.minute * 6.0;
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.setPreferredSize(new Dimension(n, n));
        if (n < this.getMinimumSize().width || n < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public String toString() {
        return "Clock";
    }
}

