/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.intelhex;

import cz.jaybee.intelhex.DataListener;
import cz.jaybee.intelhex.IntelHexException;
import cz.jaybee.intelhex.Record;
import cz.jaybee.intelhex.RecordType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class Parser {
    private final BufferedReader reader;
    private DataListener dataListener = null;
    private static final int HEX = 16;
    private boolean eof = false;
    private int recordIdx = 0;
    private long upperAddress = 0L;
    private long startAddress = 0L;

    public Parser(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Parser(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public void setDataListener(DataListener listener) {
        this.dataListener = listener;
    }

    private Record parseRecord(String record) throws IntelHexException {
        Record result = new Record();
        if (this.eof) {
            throw new IntelHexException("Data after eof (" + this.recordIdx + ")");
        }
        if (!record.startsWith(":")) {
            throw new IntelHexException("Invalid Intel HEX record (" + this.recordIdx + ")");
        }
        int lineLength = record.length();
        byte[] hexRecord = new byte[lineLength / 2];
        int sum = 0;
        for (int i = 0; i < hexRecord.length; ++i) {
            String num = record.substring(2 * i + 1, 2 * i + 3);
            hexRecord[i] = (byte)Integer.parseInt(num, 16);
            sum += hexRecord[i] & 0xFF;
        }
        if ((sum &= 0xFF) != 0) {
            throw new IntelHexException("Invalid checksum (" + this.recordIdx + ")");
        }
        result.length = hexRecord[0];
        if (result.length + 5 != hexRecord.length) {
            throw new IntelHexException("Invalid record length (" + this.recordIdx + ")");
        }
        result.data = new byte[result.length];
        System.arraycopy(hexRecord, 4, result.data, 0, result.length);
        result.address = ((hexRecord[1] & 0xFF) << 8) + (hexRecord[2] & 0xFF);
        result.type = RecordType.fromInt(hexRecord[3] & 0xFF);
        if (result.type == RecordType.UNKNOWN) {
            throw new IntelHexException("Unsupported record type " + (hexRecord[3] & 0xFF) + " (" + this.recordIdx + ")");
        }
        return result;
    }

    private void processRecord(Record record) throws IntelHexException {
        long addr = (long)record.address | this.upperAddress;
        switch (record.type) {
            case DATA: {
                if (this.dataListener == null) break;
                this.dataListener.data(addr, record.data);
                break;
            }
            case EOF: {
                if (this.dataListener != null) {
                    this.dataListener.eof();
                }
                this.eof = true;
                break;
            }
            case EXT_LIN: {
                if (record.length == 2) {
                    this.upperAddress = ((record.data[0] & 0xFF) << 8) + (record.data[1] & 0xFF);
                    this.upperAddress <<= 16;
                    break;
                }
                throw new IntelHexException("Invalid EXT_LIN record (" + this.recordIdx + ")");
            }
            case EXT_SEG: {
                if (record.length == 2) {
                    this.upperAddress = ((record.data[0] & 0xFF) << 8) + (record.data[1] & 0xFF);
                    this.upperAddress <<= 4;
                    break;
                }
                throw new IntelHexException("Invalid EXT_SEG record (" + this.recordIdx + ")");
            }
            case START_LIN: {
                if (record.length == 4) {
                    this.startAddress = 0L;
                    for (byte c : record.data) {
                        this.startAddress <<= 8;
                        this.startAddress |= (long)(c & 0xFF);
                    }
                    break;
                }
                throw new IntelHexException("Invalid START_LIN record at line #" + this.recordIdx + " " + record);
            }
            case START_SEG: {
                if (record.length == 4) {
                    this.startAddress = 0L;
                    for (byte c : record.data) {
                        this.startAddress <<= 8;
                        this.startAddress |= (long)(c & 0xFF);
                    }
                    break;
                }
                throw new IntelHexException("Invalid START_SEG record at line #" + this.recordIdx + " " + record);
            }
        }
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    public void parse() throws IntelHexException, IOException {
        String recordStr;
        this.eof = false;
        this.recordIdx = 1;
        this.upperAddress = 0L;
        this.startAddress = 0L;
        while ((recordStr = this.reader.readLine()) != null) {
            if (recordStr.isEmpty()) continue;
            Record record = this.parseRecord(recordStr);
            this.processRecord(record);
            ++this.recordIdx;
        }
        if (!this.eof) {
            throw new IntelHexException("No eof at the end of file");
        }
    }
}

