/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractLinear
extends AbstractGauge
implements Lcd,
ActionListener {
    private final Rectangle INNER_BOUNDS = new Rectangle(120, 300);
    private boolean startingFromZero = false;
    private boolean transparentSectionsEnabled = false;
    private boolean transparentAreasEnabled = false;
    private Point2D ledPosition;
    private Point2D userLedPosition;
    private String lcdUnitString;
    private double lcdValue;
    private String lcdInfoString;
    protected static final Font LCD_STANDARD_FONT = new Font("Verdana", 0, 24);
    protected static final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private Timeline lcdTimeline;
    private boolean lcdTextVisible;
    private Timer LCD_BLINKING_TIMER;
    private Timeline timeline;
    private final TimelineEase STANDARD_EASING;
    private final TimelineEase RETURN_TO_ZERO_EASING;
    private TimelineCallback timelineCallback;

    public AbstractLinear() {
        this.ledPosition = new Point2D.Double(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
        this.userLedPosition = new Point2D.Double(18.0 / (double)this.getInnerBounds().width, 0.453271028);
        this.lcdValue = 0.0;
        this.lcdTimeline = new Timeline(this);
        this.lcdUnitString = this.getUnitString();
        this.lcdInfoString = "";
        this.timeline = new Timeline(this);
        this.STANDARD_EASING = new Spline(0.5f);
        this.RETURN_TO_ZERO_EASING = new Sine();
        this.lcdTextVisible = true;
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.addComponentListener(this);
    }

    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            double d2;
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            double d3 = d < this.getMinValue() ? this.getMinValue() : (d2 = d > this.getMaxValue() ? this.getMaxValue() : d);
            if (!this.isAutoResetToZero()) {
                this.timeline.removeCallback(this.timelineCallback);
                this.timeline = new Timeline(this);
                this.timeline.addPropertyToInterpolate("value", this.getValue(), d2);
                this.timeline.setEase(this.STANDARD_EASING);
                this.timeline.setDuration(this.getStdTimeToValue());
                this.timelineCallback = new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                        if (timelineState2 == Timeline.TimelineState.IDLE) {
                            AbstractLinear.this.repaint(AbstractLinear.this.getInnerBounds());
                        }
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }

                    @Override
                    public void onTimelinePulse(float f, float f2) {
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                        if (AbstractLinear.this.getValue() < AbstractLinear.this.getMinMeasuredValue()) {
                            AbstractLinear.this.setMinMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }
                };
                this.timeline.addCallback(this.timelineCallback);
                this.timeline.play();
            } else {
                TimelineScenario.Sequence sequence = new TimelineScenario.Sequence();
                Timeline timeline = new Timeline(this);
                timeline.addPropertyToInterpolate("value", this.getValue(), d2);
                timeline.setEase(this.RETURN_TO_ZERO_EASING);
                timeline.setDuration(this.getRtzTimeToValue());
                timeline.addCallback(new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                        if (timelineState == Timeline.TimelineState.PLAYING_FORWARD && timelineState2 == Timeline.TimelineState.DONE) {
                            AbstractLinear.this.getModel().setPeakValue(AbstractLinear.this.getValue());
                            AbstractLinear.this.getModel().setPeakValueVisible(true);
                            if (AbstractLinear.this.getPeakTimer().isRunning()) {
                                AbstractLinear.this.stopPeakTimer();
                            }
                            AbstractLinear.this.startPeakTimer();
                            if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                                AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                            }
                        }
                    }

                    @Override
                    public void onTimelinePulse(float f, float f2) {
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                        if (AbstractLinear.this.getValue() < AbstractLinear.this.getMinMeasuredValue()) {
                            AbstractLinear.this.setMinMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }
                });
                Timeline timeline2 = new Timeline(this);
                timeline2.addPropertyToInterpolate("value", d2, 0.0);
                timeline2.setEase(this.RETURN_TO_ZERO_EASING);
                timeline2.setDuration(this.getRtzTimeBackToZero());
                ((TimelineScenario)sequence).addScenarioActor(timeline);
                ((TimelineScenario)sequence).addScenarioActor(timeline2);
                sequence.play();
            }
        }
    }

    public ColorDef getValueColor() {
        return this.getModel().getValueColor();
    }

    public void setValueColor(ColorDef colorDef) {
        this.getModel().setValueColor(colorDef);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomValueColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public Color getCustomValueColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomValueColor(Color color) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(color));
        this.repaint(this.getInnerBounds());
    }

    public boolean isStartingFromZero() {
        return this.startingFromZero;
    }

    public void setStartingFromZero(boolean bl) {
        this.startingFromZero = bl;
    }

    public int getMaxNoOfMinorTicks() {
        return this.getModel().getMaxNoOfMinorTicks();
    }

    public void setMaxNoOfMinorTicks(int n) {
        this.getModel().setMaxNoOfMinorTicks(n);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public int getMaxNoOfMajorTicks() {
        return this.getModel().getMaxNoOfMajorTicks();
    }

    public void setMaxNoOfMajorTicks(int n) {
        this.getModel().setMaxNoOfMajorTicks(n);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getLedPosition() {
        return this.ledPosition;
    }

    @Override
    public void setLedPosition(double d, double d2) {
        this.ledPosition.setLocation(d, d2);
        this.repaint(this.getInnerBounds());
    }

    public void setLedPosition(Point2D point2D) {
        this.ledPosition.setLocation(point2D);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getUserLedPosition() {
        return this.userLedPosition;
    }

    @Override
    public void setUserLedPosition(double d, double d2) {
        this.userLedPosition.setLocation(d, d2);
        this.repaint(this.getInnerBounds());
    }

    public void setUserLedPosition(Point2D point2D) {
        this.userLedPosition.setLocation(point2D);
        this.repaint(this.getInnerBounds());
    }

    protected void createLedImages() {
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.recreateLedImages(this.getWidth());
        } else {
            this.recreateLedImages(this.getHeight());
        }
    }

    public boolean isLcdVisible() {
        return this.getModel().isLcdVisible();
    }

    public void setLcdVisible(boolean bl) {
        this.getModel().setLcdVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdTextVisible() {
        return this.lcdTextVisible;
    }

    @Override
    public boolean isValueCoupled() {
        return this.getModel().isValueCoupled();
    }

    @Override
    public void setValueCoupled(boolean bl) {
        this.getModel().setValueCoupled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double d) {
        this.lcdValue = d;
        if (this.getLcdNumberSystem() != NumberSystem.DEC && d < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        this.repaint(this.getLcdBounds());
    }

    @Override
    public void setLcdValueAnimated(double d) {
        if (this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.lcdTimeline.abort();
        }
        this.lcdTimeline = new Timeline(this);
        this.lcdTimeline.addPropertyToInterpolate("lcdValue", this.lcdValue, d);
        this.lcdTimeline.setEase(new Spline(0.5f));
        this.lcdTimeline.play();
    }

    @Override
    public double getLcdThreshold() {
        return this.getModel().getLcdThreshold();
    }

    @Override
    public void setLcdThreshold(double d) {
        this.getModel().setLcdThreshold(d);
        if (this.getModel().isLcdThresholdVisible()) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.getModel().isLcdThresholdVisible();
    }

    @Override
    public void setLcdThresholdVisible(boolean bl) {
        this.getModel().setLcdThresholdVisible(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.getModel().isLcdThresholdBehaviourInverted();
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean bl) {
        this.getModel().setLcdThresholdBehaviourInverted(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBlinking() {
        return this.getModel().isLcdBlinking();
    }

    @Override
    public void setLcdBlinking(boolean bl) {
        if (bl) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
            this.lcdTextVisible = true;
        }
        this.getModel().setLcdBlinking(bl);
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String string) {
        this.lcdUnitString = string;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.getModel().isLcdUnitStringVisible();
    }

    @Override
    public void setLcdUnitStringVisible(boolean bl) {
        this.getModel().setLcdUnitStringVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isDigitalFont() {
        return this.getModel().isDigitalFontEnabled();
    }

    @Override
    public void setDigitalFont(boolean bl) {
        this.getModel().setDigitalFontEnabled(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.getModel().isCustomLcdUnitFontEnabled();
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean bl) {
        this.getModel().setCustomLcdUnitFontEnabled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.getModel().getCustomLcdUnitFont();
    }

    @Override
    public void setCustomLcdUnitFont(Font font) {
        this.getModel().setCustomLcdUnitFont(font);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.getModel().getLcdDecimals();
    }

    @Override
    public void setLcdDecimals(int n) {
        this.getModel().setLcdDecimals(n);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.getModel().getLcdColor();
    }

    @Override
    public void setLcdColor(LcdColor lcdColor) {
        this.getModel().setLcdColor(lcdColor);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.getModel().getCustomLcdBackground();
    }

    @Override
    public void setCustomLcdBackground(Paint paint) {
        this.getModel().setCustomLcdBackground(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.getModel().isLcdBackgroundVisible();
    }

    @Override
    public void setLcdBackgroundVisible(boolean bl) {
        this.getModel().setLcdBackgroundVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.getModel().getCustomLcdForeground();
    }

    @Override
    public void setCustomLcdForeground(Color color) {
        this.getModel().setCustomLcdForeground(color);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("0");
        if (this.getModel().getLcdDecimals() > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.getModel().getLcdDecimals(); ++i) {
            stringBuilder.append("0");
        }
        if (this.getModel().isLcdScientificFormatEnabled()) {
            stringBuilder.append("E0");
        }
        stringBuilder.trimToSize();
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.getModel().isLcdScientificFormatEnabled();
    }

    @Override
    public void setLcdScientificFormat(boolean bl) {
        this.getModel().setLcdScientificFormatEnabled(bl);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdValueFont() {
        return this.getModel().getLcdValueFont();
    }

    @Override
    public void setLcdValueFont(Font font) {
        this.getModel().setLcdValueFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.getModel().getLcdUnitFont();
    }

    @Override
    public void setLcdUnitFont(Font font) {
        this.getModel().setLcdUnitFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.getModel().getLcdInfoFont();
    }

    @Override
    public void setLcdInfoFont(Font font) {
        this.getModel().setLcdInfoFont(font);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String string) {
        this.lcdInfoString = string;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.getModel().getNumberSystem();
    }

    @Override
    public void setLcdNumberSystem(NumberSystem numberSystem) {
        this.getModel().setNumberSystem(numberSystem);
        switch (numberSystem) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public abstract Rectangle getLcdBounds();

    @Override
    public void toggleDesign() {
        if (this.getActiveDesign().equals(this.getDesign1())) {
            this.setActiveDesign(this.getDesign2());
        } else {
            this.setActiveDesign(this.getDesign1());
        }
    }

    @Override
    public boolean isGlowVisible() {
        return this.getModel().isGlowVisible();
    }

    public void setGlowVisible(boolean bl) {
        this.getModel().setGlowVisible(bl);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.getModel().getGlowColor();
    }

    public void setGlowColor(Color color) {
        this.getModel().setGlowColor(color);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowing() {
        return this.getModel().isGlowing();
    }

    public void setGlowing(boolean bl) {
        this.getModel().setGlowing(bl);
        this.repaint(this.getInnerBounds());
    }

    public Paint getOuterFrameColor() {
        return FRAME_FACTORY.getOuterFrameColor();
    }

    public void setOuterFrameColor(Paint paint) {
        FRAME_FACTORY.setOuterFrameColor(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Paint getInnerFrameColor() {
        return FRAME_FACTORY.getInnerFrameColor();
    }

    public void setInnerFrameColor(Paint paint) {
        FRAME_FACTORY.setInnerFrameColor(paint);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentSectionsEnabled() {
        return this.transparentSectionsEnabled;
    }

    public void setTransparentSectionsEnabled(boolean bl) {
        this.transparentSectionsEnabled = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentAreasEnabled() {
        return this.transparentAreasEnabled;
    }

    public void setTransparentAreasEnabled(boolean bl) {
        this.transparentAreasEnabled = bl;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    protected BufferedImage create_FRAME_Image(int n, int n2) {
        return FRAME_FACTORY.createLinearFrame(n, n2, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect());
    }

    protected BufferedImage create_FRAME_Image(int n, int n2, BufferedImage bufferedImage) {
        return FRAME_FACTORY.createLinearFrame(n, n2, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), bufferedImage);
    }

    protected BufferedImage create_BACKGROUND_Image(int n, int n2) {
        return this.create_BACKGROUND_Image(n, n2, null);
    }

    protected BufferedImage create_BACKGROUND_Image(int n, int n2, BufferedImage bufferedImage) {
        if (n <= 0 || n2 <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n2, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BACKGROUND_FACTORY.createLinearBackground(n, n2, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), bufferedImage);
        if (this.isCustomLayerVisible()) {
            graphics2D.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), n3, n4, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_GLOW_Image(int n, int n2, Color color, boolean bl) {
        return GLOW_FACTORY.createLinearGlow(n, n2, color, bl);
    }

    protected BufferedImage create_TRACK_Image(int n, int n2, double d, double d2, double d3, double d4, double d5, Color color, Color color2, Color color3) {
        return this.create_TRACK_Image(n, n2, d, d2, d3, d4, d5, color, color2, color3, null);
    }

    protected BufferedImage create_TRACK_Image(int n, int n2, double d, double d2, double d3, double d4, double d5, Color color, Color color2, Color color3, BufferedImage bufferedImage) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Rectangle2D.Double double_3;
        if (n <= 0 || n2 <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (d5 > d2) {
            throw new IllegalArgumentException("Please adjust track start and/or track stop values");
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n2, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (this.getOrientation() == Orientation.VERTICAL) {
            double_3 = new Rectangle2D.Double((double)n3 * 0.315, (double)n4 * 0.1276, (double)n3 * 0.05, (double)n4 * 0.728);
            double_2 = new Point2D.Double(0.0, double_3.getMaxY());
            double_ = new Point2D.Double(0.0, double_3.getMinY());
        } else {
            double_3 = new Rectangle2D.Double((double)n3 * 0.139, (double)n4 * 0.6285714285714286, (double)n3 * 0.735, (double)n4 * 0.05);
            double_2 = new Point2D.Double(double_3.getMinX(), 0.0);
            double_ = new Point2D.Double(double_3.getMaxX(), 0.0);
        }
        float f = (float)((d3 - d) / (d2 - d));
        float f2 = (float)((d5 - d) / (d2 - d));
        Color color4 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        float f3 = (float)((d4 - d) / (d2 - d));
        float[] fArray = new float[]{0.0f, f + 0.001f, f + 0.002f, f3, f2 - 0.002f, f2 - 0.001f, 1.0f};
        Color[] colorArray = new Color[]{color4, color4, color, color2, color3, color4, color4};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TITLE_Image(int n, int n2, boolean bl) {
        return this.create_TITLE_Image(n, n2, bl, null);
    }

    protected BufferedImage create_TITLE_Image(int n, int n2, boolean bl, BufferedImage bufferedImage) {
        if (n <= 0 || n2 <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n2, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (this.isLabelColorFromThemeEnabled()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            graphics2D.setColor(this.getLabelColor());
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            Cloneable cloneable;
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.1 * (double)n3)));
            }
            if (!this.getTitle().isEmpty()) {
                TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
                cloneable = graphics2D.getTransform();
                graphics2D.translate(0.0, -0.05 * (double)n4);
                graphics2D.rotate(1.5707963267948966, 0.67142856f * (float)n3, 0.1375f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
                graphics2D.drawString(this.getTitle(), 0.67142856f * (float)n3, 0.1375f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
                graphics2D.setTransform((AffineTransform)cloneable);
            }
            if (bl && !this.getUnitString().isEmpty()) {
                if (this.isTitleAndUnitFontEnabled()) {
                    graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.07142857142857142 * (double)n3)));
                } else {
                    graphics2D.setFont(new Font("Verdana", 0, (int)(0.07142857142857142 * (double)n3)));
                }
                cloneable = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
                Rectangle2D rectangle2D = ((TextLayout)cloneable).getBounds();
                graphics2D.drawString(this.getUnitString(), (float)((double)n3 - rectangle2D.getWidth()) / 2.0f, 0.8875f * (float)n4 + ((TextLayout)cloneable).getAscent() - ((TextLayout)cloneable).getDescent());
            }
        } else {
            if (this.isTitleAndUnitFontEnabled()) {
                graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.1 * (double)n4)));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.1 * (double)n4)));
            }
            if (!this.getTitle().isEmpty()) {
                TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
                graphics2D.drawString(this.getTitle(), 0.15f * (float)n3, 0.25f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
            }
            if (bl && !this.getUnitString().isEmpty()) {
                if (this.isTitleAndUnitFontEnabled()) {
                    graphics2D.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.025 * (double)n3)));
                } else {
                    graphics2D.setFont(new Font("Verdana", 0, (int)(0.025 * (double)n3)));
                }
                TextLayout textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
                graphics2D.drawString(this.getUnitString(), 0.0625f * (float)n3, 0.7f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_LCD_Image(int n, int n2, LcdColor lcdColor, Paint paint) {
        return this.create_LCD_Image(new Rectangle2D.Double(0.0, 0.0, n, n2), lcdColor, paint, null);
    }

    protected BufferedImage create_LCD_Image(Rectangle2D rectangle2D, LcdColor lcdColor, Paint paint, BufferedImage bufferedImage) {
        return LCD_FACTORY.create_LCD_Image(rectangle2D, lcdColor, paint, bufferedImage);
    }

    protected BufferedImage create_THRESHOLD_Image(int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        int n3;
        int n4;
        if (n <= 14 || n2 <= 14) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            n4 = (int)((double)n * 0.0714285714);
            n3 = (int)((double)n4 * 0.8);
        } else {
            n3 = (int)((double)n2 * 0.0714285714);
            n4 = (int)((double)n3 * 0.8);
        }
        BufferedImage bufferedImage = UTIL.createImage(n4, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(0.0, (double)n4 * 0.005);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (this.getOrientation() == Orientation.VERTICAL) {
            generalPath.moveTo((double)n4 * 0.1, (double)n3 * 0.5);
            generalPath.lineTo((double)n4 * 0.9, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.9, (double)n3 * 0.9);
            generalPath.lineTo((double)n4 * 0.1, (double)n3 * 0.5);
            generalPath.closePath();
            double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        } else {
            generalPath.moveTo((double)n4 * 0.5, (double)n3 * 0.9);
            generalPath.lineTo((double)n4 * 1.0, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.1, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.5, (double)n3 * 0.9);
            generalPath.closePath();
            double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        }
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getThresholdColor().DARK, this.getThresholdColor().MEDIUM, this.getThresholdColor().MEDIUM, this.getThresholdColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int n, int n2, Color color) {
        int n3;
        int n4;
        if (n <= 20 || n2 <= 20) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            n3 = n4 = (int)((double)n * 0.05);
        } else {
            n4 = n3 = (int)((double)n2 * 0.05);
        }
        BufferedImage bufferedImage = UTIL.createImage(n4, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (this.getOrientation() == Orientation.VERTICAL) {
            generalPath.moveTo((double)n4, (double)n3 * 0.5);
            generalPath.lineTo(0.0, 0.0);
            generalPath.lineTo(0.0, (double)n3);
            generalPath.closePath();
        } else {
            generalPath.moveTo((double)n4 * 0.5, 0.0);
            generalPath.lineTo(n4, n3);
            generalPath.lineTo(0.0, (double)n3);
            generalPath.closePath();
        }
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_FOREGROUND_Image(int n, int n2) {
        return FOREGROUND_FACTORY.createLinearForeground(n, n2);
    }

    protected BufferedImage create_DISABLED_Image(int n, int n2) {
        return DISABLED_FACTORY.createLinearDisabled(n, n2);
    }

    @Override
    public void calcInnerBounds() {
        this.calcInnerBounds(this.getWidth(), this.getHeight());
    }

    public void calcInnerBounds(int n, int n2) {
        Insets insets = this.getInsets();
        if (!this.isFrameVisible()) {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, n - insets.left - insets.right + 34, n2 - insets.top - insets.bottom + 34);
        } else {
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        }
    }

    @Override
    public final Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width <= dimension.height) {
            if (dimension.width < 40 || dimension.height < 60) {
                dimension = new Dimension(40, 60);
            }
        } else if (dimension.width < 60 || dimension.height < 60) {
            dimension = new Dimension(60, 40);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n;
        int n2;
        if (this.getInnerBounds().width <= this.getInnerBounds().height) {
            n2 = dimension.width < 40 ? 40 : dimension.width;
            n = dimension.height < 60 ? 60 : dimension.height;
        } else {
            n2 = dimension.width < 60 ? 60 : dimension.width;
            n = dimension.height < 40 ? 40 : dimension.height;
        }
        super.setMinimumSize(new Dimension(n2, n));
        this.calcInnerBounds(dimension.width, dimension.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width <= dimension.height) {
            if (dimension.width > 1080 || dimension.height > 1920) {
                dimension = new Dimension(1080, 1920);
            }
        } else if (dimension.width > 1920 || dimension.height > 1080) {
            dimension = new Dimension(1920, 1080);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n;
        int n2;
        if (this.getInnerBounds().width <= this.getInnerBounds().height) {
            n2 = dimension.width > 1080 ? 1080 : dimension.width;
            n = dimension.height > 1920 ? 1920 : dimension.height;
        } else {
            n2 = dimension.width > 1920 ? 1920 : dimension.width;
            n = dimension.height > 1080 ? 1080 : dimension.height;
        }
        super.setMaximumSize(new Dimension(n2, n));
        this.calcInnerBounds(dimension.width, dimension.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.calcInnerBounds(dimension.width, dimension.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calcInnerBounds(n, n2);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.calcInnerBounds(dimension.width, dimension.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.calcInnerBounds(rectangle.width, rectangle.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calcInnerBounds(n3, n4);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Container container = this.getParent();
        if (container != null && container.getLayout() == null) {
            this.setSize(this.getWidth(), this.getHeight());
        } else {
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        }
        this.calcInnerBounds();
        if (this.getWidth() >= this.getHeight()) {
            this.setOrientation(Orientation.HORIZONTAL);
            this.recreateLedImages(this.getInnerBounds().height);
            this.recreateUserLedImages(this.getInnerBounds().height);
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.setLedPosition(((double)this.getInnerBounds().width - 20.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.setUserLedPosition(18.0 / (double)this.getInnerBounds().width, 0.453271028);
        } else {
            this.setOrientation(Orientation.VERTICAL);
            this.recreateLedImages(this.getInnerBounds().width);
            this.recreateUserLedImages(this.getInnerBounds().width);
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.setLedPosition(0.453271028, 20.0 / (double)this.getInnerBounds().height);
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.setUserLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
        }
        this.getModel().setSize(this.getLocation().x, this.getLocation().y, this.getWidth(), this.getHeight());
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public String toString() {
        return "AbstractLinear";
    }
}

