/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIterator;
import java.util.List;

class PerFieldWithStructuresIterator
extends FieldIterator {
    private final ReaderState state;
    private final String variableNamePrefix;
    private final Strategy strategy;
    private final String prefixSeparator;
    private final StringBuilder sb = new StringBuilder();

    public PerFieldWithStructuresIterator(ReaderState state, List<ConfigField> fields, String variableNamePrefix, Strategy strategy, String prefixSeparator) {
        super(fields);
        this.state = state;
        this.variableNamePrefix = variableNamePrefix;
        this.strategy = strategy;
        this.prefixSeparator = prefixSeparator;
    }

    public PerFieldWithStructuresIterator(ReaderState state, List<ConfigField> fields, String variableNamePrefix, Strategy strategy) {
        this(state, fields, variableNamePrefix, strategy, "_");
    }

    @Override
    public void end() {
        String content;
        ConfigStructure cs = this.cf.getState().getStructures().get(this.cf.getType());
        if (cs != null) {
            if (this.strategy.skip(this.cf)) {
                content = "";
            } else {
                String extraPrefix = this.variableNamePrefix + this.strategy.getArrayElementName(this.cf) + this.prefixSeparator;
                PerFieldWithStructuresIterator fieldIterator = new PerFieldWithStructuresIterator(this.state, cs.getTsFields(), extraPrefix, this.strategy, this.prefixSeparator);
                fieldIterator.loop();
                content = fieldIterator.sb.toString();
            }
        } else {
            content = this.strategy.process(this.state, this.cf, this.variableNamePrefix);
        }
        this.sb.append(content);
        super.end();
    }

    public String getContent() {
        return this.sb.toString();
    }

    static interface Strategy {
        public String process(ReaderState var1, ConfigField var2, String var3);

        default public String getArrayElementName(ConfigField cf) {
            return cf.getName();
        }

        default public boolean skip(ConfigField cf) {
            return cf.isFromIterate();
        }
    }
}

