/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu;

import java.util.ArrayList;
import java.util.List;

public class FlashRange {
    private final int baseAddress;
    private final List<Integer> pages;
    private final int totalLength;

    public FlashRange(int baseAddress, List<Integer> pages) {
        this.baseAddress = baseAddress;
        this.pages = pages;
        int t = 0;
        for (Integer page : pages) {
            t += page.intValue();
        }
        this.totalLength = t;
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public List<Integer> getPages() {
        return this.pages;
    }

    public String toString() {
        return "FlashRange{baseAddress=" + this.baseAddress + ", totalLength=" + this.totalLength + '}';
    }

    public List<Integer> pagesForSize(int size) {
        int total = 0;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer page : this.pages) {
            if (total >= size) continue;
            result.add(page);
            total += page.intValue();
        }
        return result;
    }
}

