/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.TypesHelper;
import com.rusefi.VariableRegistry;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import org.abego.treelayout.internal.util.java.lang.string.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLogConsumer
implements ConfigurationConsumer {
    private static final int MSQ_LENGTH_LIMIT = 34;
    public static final String UNUSED = "unused";
    private final String fileName;
    private final StringBuilder tsWriter = new StringBuilder();
    private final TreeSet<String> comments = new TreeSet(String.CASE_INSENSITIVE_ORDER);

    public DataLogConsumer(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        if (readerState.isStackEmpty()) {
            PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(readerState, structure.getTsFields(), "", (configField, prefix, prefix2) -> this.handle(prefix, prefix2));
            iterator.loop();
            String content = iterator.getContent();
            this.tsWriter.append(content);
        }
        this.writeStringToFile(this.fileName, this.tsWriter);
    }

    private void writeStringToFile(@Nullable String fileName, StringBuilder writer) throws IOException {
        if (fileName != null) {
            FileWriter fw = new FileWriter(fileName);
            fw.write(writer.toString());
            fw.close();
        }
    }

    private String handle(ConfigField configField, String prefix) {
        if (configField.getName().contains(UNUSED)) {
            return "";
        }
        if (configField.isArray()) {
            return "";
        }
        String autoscaleSpec = configField.autoscaleSpec();
        String typeString = TypesHelper.isFloat(configField.getType()) || autoscaleSpec != null && !autoscaleSpec.equals("1, 1") ? "float,  \"%.3f\"" : "int,    \"%d\"";
        String comment = DataLogConsumer.getHumanGaugeName(prefix, configField);
        if (this.comments.contains(comment)) {
            throw new IllegalStateException(comment + " already present in the outputs! " + configField);
        }
        this.comments.add(comment);
        return "entry = " + prefix + configField.getName() + ", " + comment + ", " + typeString + "\n";
    }

    @NotNull
    public static String getHumanGaugeName(String prefix, ConfigField configField) {
        String comment = configField.getCommentTemplated();
        if ((comment = DataLogConsumer.getFirstLine(comment)).isEmpty()) {
            comment = prefix + VariableRegistry.unquote(configField.getName());
        }
        if (comment.length() > 34) {
            throw new IllegalStateException("[" + comment + "] is too long for log files at " + comment.length());
        }
        if (comment.charAt(0) != '\"') {
            comment = StringUtil.quote(comment);
        }
        return comment;
    }

    private static String getFirstLine(String comment) {
        String[] comments = comment == null ? new String[]{} : VariableRegistry.unquote(comment).split("\\\\n");
        comment = comments.length > 0 ? comments[0] : "";
        return comment;
    }

    public String getContent() {
        return this.tsWriter.toString();
    }
}

