/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse.layout;

import com.rusefi.newparse.layout.ArrayIterateScalarLayout;
import com.rusefi.newparse.layout.ArrayIterateStructLayout;
import com.rusefi.newparse.layout.ArrayLayout;
import com.rusefi.newparse.layout.BitGroupLayout;
import com.rusefi.newparse.layout.EnumLayout;
import com.rusefi.newparse.layout.Layout;
import com.rusefi.newparse.layout.ScalarLayout;
import com.rusefi.newparse.layout.StringLayout;
import com.rusefi.newparse.layout.StructNamePrefixer;
import com.rusefi.newparse.layout.UnionLayout;
import com.rusefi.newparse.layout.UnusedLayout;
import com.rusefi.newparse.outputs.TsMetadata;
import com.rusefi.newparse.parsing.ArrayField;
import com.rusefi.newparse.parsing.BitGroup;
import com.rusefi.newparse.parsing.EnumField;
import com.rusefi.newparse.parsing.Field;
import com.rusefi.newparse.parsing.PrototypeField;
import com.rusefi.newparse.parsing.ScalarField;
import com.rusefi.newparse.parsing.StringField;
import com.rusefi.newparse.parsing.Struct;
import com.rusefi.newparse.parsing.StructField;
import com.rusefi.newparse.parsing.Union;
import com.rusefi.newparse.parsing.UnusedField;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class StructLayout
extends Layout {
    public final List<Layout> children = new ArrayList<Layout>();
    public final String typeName;
    private final String name;
    private final String comment;
    private final Boolean noPrefix;
    private final int size;

    private static int getAlignedOffset(int offset, int alignment) {
        if (offset % alignment != 0) {
            return offset + alignment - offset % alignment;
        }
        return offset;
    }

    int padOffsetWithUnused(int offset, int align) {
        int alignedOffset = StructLayout.getAlignedOffset(offset, align);
        int needsUnused = alignedOffset - offset;
        if (needsUnused > 0) {
            UnusedLayout ul = new UnusedLayout(needsUnused);
            ul.setOffset(offset);
            ul.setOffsetWithinStruct(offset - this.offset);
            this.children.add(ul);
            return alignedOffset;
        }
        return offset;
    }

    public StructLayout(int offset, String name, Struct parsedStruct) {
        this.setOffset(offset);
        this.typeName = parsedStruct.name;
        this.name = name;
        this.comment = parsedStruct.comment;
        this.noPrefix = parsedStruct.noPrefix;
        int initialOffest = offset;
        for (Field f : parsedStruct.fields) {
            if (f instanceof ArrayField) {
                ArrayField asf = (ArrayField)f;
                assert (asf.prototype instanceof ScalarField || asf.iterate.booleanValue());
                if (asf.iterate.booleanValue()) {
                    if (asf.prototype instanceof StructField) {
                        offset = this.addItem(offset, new ArrayIterateStructLayout((StructField)asf.prototype, asf.length));
                        continue;
                    }
                    offset = this.addItem(offset, new ArrayIterateScalarLayout((PrototypeField)asf.prototype, asf.length));
                    continue;
                }
                assert (asf.prototype instanceof ScalarField);
                ScalarField prototype = (ScalarField)asf.prototype;
                offset = this.addItem(offset, new ArrayLayout(prototype, asf.length));
                continue;
            }
            offset = this.addItem(offset, f);
        }
        offset = this.padOffsetWithUnused(offset, 4);
        this.size = offset - initialOffest;
    }

    private int addItem(int offset, Field f) {
        Layout l;
        if (f instanceof StructField) {
            StructField sf = (StructField)f;
            return this.addStruct(offset, sf.struct, sf.name);
        }
        if (f instanceof ScalarField) {
            l = new ScalarLayout((ScalarField)f);
        } else if (f instanceof EnumField) {
            l = new EnumLayout((EnumField)f);
        } else if (f instanceof UnusedField) {
            l = new UnusedLayout((UnusedField)f);
        } else if (f instanceof BitGroup) {
            l = new BitGroupLayout((BitGroup)f);
        } else if (f instanceof StringField) {
            l = new StringLayout((StringField)f);
        } else if (f instanceof Union) {
            l = new UnionLayout((Union)f);
        } else {
            throw new RuntimeException("unexpected field type during layout");
        }
        return this.addItem(offset, l);
    }

    private int addItem(int offset, Layout l) {
        offset = this.padOffsetWithUnused(offset, l.getAlignment());
        l.setOffset(offset);
        l.setOffsetWithinStruct(offset - this.offset);
        this.children.add(l);
        return offset + l.getSize();
    }

    private int addStruct(int offset, Struct struct, String name) {
        offset = this.padOffsetWithUnused(offset, 4);
        StructLayout sl = new StructLayout(offset, name, struct);
        sl.setOffsetWithinStruct(offset - this.offset);
        this.children.add(sl);
        int structSize = sl.getSize();
        return offset + structSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getAlignment() {
        return 4;
    }

    @Override
    public String toString() {
        return "Struct " + this.typeName + " " + super.toString();
    }

    @Override
    protected void writeTunerstudioLayout(PrintStream ps, TsMetadata meta, StructNamePrefixer prefixer, int offsetAdd) {
        if (!this.noPrefix.booleanValue()) {
            prefixer.push(this.name);
        }
        this.children.forEach(c -> c.writeTunerstudioLayout(ps, meta, prefixer, offsetAdd));
        if (!this.noPrefix.booleanValue()) {
            prefixer.pop();
        }
    }

    @Override
    public void writeCLayout(PrintStream ps) {
        this.writeCOffsetHeader(ps, null, null);
        ps.println("\t" + this.typeName + " " + this.name + ";");
    }

    @Override
    public void writeCLayout(PrintStream ps, int[] arrayLength) {
        this.writeCOffsetHeader(ps, null, null);
        ps.println("\t" + this.typeName + " " + this.name + "[" + arrayLength[0] + "];");
    }

    public void writeCLayoutRoot(PrintStream ps) {
        if (this.comment != null) {
            ps.println("/**\n * @brief " + this.comment);
            ps.println("*/");
        }
        ps.println("// start of " + this.typeName);
        ps.println("struct " + this.typeName + " {");
        this.children.forEach(c -> c.writeCLayout(ps));
        ps.println("};");
        ps.println("static_assert(sizeof(" + this.typeName + ") == " + this.getSize() + ");");
        ps.println();
    }

    @Override
    protected void writeOutputChannelLayout(PrintStream ps, StructNamePrefixer prefixer, int offsetAdd) {
        if (!this.noPrefix.booleanValue()) {
            prefixer.push(this.name);
        }
        this.children.forEach(c -> c.writeOutputChannelLayout(ps, prefixer, offsetAdd));
        if (!this.noPrefix.booleanValue()) {
            prefixer.pop();
        }
    }
}

