/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.ConsoleUI;
import com.rusefi.FileLog;
import com.rusefi.Launcher;
import com.rusefi.RealHardwareTestLauncher;
import com.rusefi.SerialPortScanner;
import com.rusefi.SimulatorHelper;
import com.rusefi.autodetect.PortDetector;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.serial.BaudRateHolder;
import com.rusefi.maintenance.DriverInstall;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.FirmwareFlasher;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.ui.PcanConnectorUI;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.util.IoUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.putgemin.VerticalFlowLayout;

public class StartupFrame {
    private static final Logging log = Logging.getLogging(Launcher.class);
    public static final String LOGO_PATH = "/com/rusefi/";
    private static final String LOGO = "/com/rusefi/logo.png";
    public static final String LINK_TEXT = "rusEFI (c) 2012-2023";
    private static final String URI = "http://rusefi.com/?java_console";
    private final JFrame frame;
    private final JPanel connectPanel = new JPanel(new FlowLayout());
    private final JComboBox<String> comboPorts = new JComboBox();
    private final JPanel leftPanel = new JPanel(new VerticalFlowLayout());
    private final JPanel realHardwarePanel = new JPanel(new MigLayout());
    private final JPanel miscPanel = new JPanel(new MigLayout()){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(size.width, ((StartupFrame)StartupFrame.this).realHardwarePanel.getPreferredSize().width), size.height);
        }
    };
    private boolean isProceeding;
    private final JLabel noPortsMessage = new JLabel("<html>No ports found!<br>Confirm blue LED is blinking</html>");

    public StartupFrame() {
        String title = "rusEFI console version 20230107";
        this.frame = new JFrame(StartupFrame.appendBundleName(title));
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                if (!StartupFrame.this.isProceeding) {
                    PersistentConfiguration.getConfig().save();
                    IoUtils.exit("windowClosed", 0);
                }
            }
        });
        AutoupdateUtil.setAppIcon(this.frame);
    }

    @NotNull
    public static String appendBundleName(String title) {
        String bundleName = BundleUtil.readBundleFullNameNotNull();
        return title + " " + bundleName;
    }

    public void chooseSerialPort() {
        JLabel logo;
        this.realHardwarePanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.darkGray), "Real stm32"));
        this.miscPanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.darkGray), "Miscellaneous"));
        if (FileLog.isWindows()) {
            UiUtils.setToolTip(this.comboPorts, "Use 'Device Manager' icon above to launch Device Manager", "In 'Ports' section look for ", "'STMicroelectronics Virtual COM Port' for USB port", "'USB Serial Port' for TTL port");
        }
        this.connectPanel.add(this.comboPorts);
        final JComboBox<String> comboSpeeds = StartupFrame.createSpeedCombo();
        comboSpeeds.setToolTipText("For 'STMicroelectronics Virtual COM Port' device any speed setting would work the same");
        this.connectPanel.add(comboSpeeds);
        JButton connectButton = new JButton("Connect", new ImageIcon(this.getClass().getResource("/com/rusefi/connect48.png")));
        UiUtils.setToolTip(connectButton, "Connect to real hardware");
        this.connectPanel.add(connectButton);
        this.connectPanel.setVisible(false);
        this.frame.getRootPane().setDefaultButton(connectButton);
        connectButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StartupFrame.this.connectButtonAction(comboSpeeds);
                }
            }
        });
        connectButton.addActionListener(e -> this.connectButtonAction(comboSpeeds));
        this.leftPanel.add(this.realHardwarePanel);
        this.leftPanel.add(this.miscPanel);
        if (FileLog.isWindows()) {
            JPanel topButtons = new JPanel(new FlowLayout(1, 5, 0));
            topButtons.add(this.createShowDeviceManagerButton());
            topButtons.add(DriverInstall.createButton());
            topButtons.add(this.createPcanConnectorButton());
            this.realHardwarePanel.add((Component)topButtons, "right, wrap");
        }
        this.realHardwarePanel.add((Component)this.connectPanel, "right, wrap");
        this.realHardwarePanel.add((Component)this.noPortsMessage, "right, wrap");
        this.installMessage(this.noPortsMessage, "Check you cables. Check your drivers. Do you want to start simulator maybe?");
        ProgramSelector selector = new ProgramSelector(this.comboPorts);
        if (FileLog.isWindows()) {
            this.realHardwarePanel.add((Component)new HorizontalLine(), "right, wrap");
            this.realHardwarePanel.add((Component)selector.getControl(), "right, wrap");
            if (new File(FirmwareFlasher.IMAGE_NO_ASSERTS_FILE).exists()) {
                FirmwareFlasher firmwareFlasher = new FirmwareFlasher(FirmwareFlasher.IMAGE_NO_ASSERTS_FILE, "ST-LINK Program Firmware/NoAsserts", "Please only use this version if you know that you need this version");
                this.realHardwarePanel.add((Component)firmwareFlasher.getButton(), "right, wrap");
            }
            JComponent updateHelp = ProgramSelector.createHelpButton();
            this.realHardwarePanel.add((Component)updateHelp, "right, wrap");
        }
        SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> {
            selector.apply(currentHardware);
            this.applyKnownPorts(currentHardware);
            this.frame.pack();
        }));
        JButton buttonLogViewer = new JButton();
        buttonLogViewer.setText("Start log viewer");
        buttonLogViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartupFrame.this.disposeFrameAndProceed();
                new ConsoleUI("log viewer");
            }
        });
        this.miscPanel.add((Component)buttonLogViewer, "wrap");
        this.miscPanel.add((Component)new HorizontalLine(), "wrap");
        this.miscPanel.add(SimulatorHelper.createSimulatorComponent(this));
        JPanel rightPanel = new JPanel(new VerticalFlowLayout());
        if (BundleUtil.readBundleFullNameNotNull().contains("proteus_f7")) {
            final String text = "WARNING: Proteus F7";
            final URLLabel urlLabel = new URLLabel(text, "https://github.com/rusefi/rusefi/wiki/F7-requires-full-erase");
            Color originalColor = urlLabel.getForeground();
            new Timer(500, new ActionListener(){
                int counter;

                @Override
                public void actionPerformed(ActionEvent e) {
                    urlLabel.setText(text, this.counter++ % 2 == 0);
                }
            }).start();
            rightPanel.add(urlLabel);
        }
        if ((logo = StartupFrame.createLogoLabel()) != null) {
            rightPanel.add(logo);
        }
        rightPanel.add(new URLLabel(LINK_TEXT, URI));
        rightPanel.add(new JLabel("Version 20230107"));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.leftPanel, "West");
        content.add((Component)rightPanel, "East");
        this.frame.add(content);
        this.frame.pack();
        StartupFrame.setFrameIcon(this.frame);
        this.frame.setVisible(true);
        UiUtils.centerWindow(this.frame);
        KeyListener hwTestEasterEgg = this.functionalTestEasterEgg();
        for (Component component : UiUtils.getAllComponents(this.frame)) {
            component.addKeyListener(hwTestEasterEgg);
        }
    }

    private void applyKnownPorts(SerialPortScanner.AvailableHardware currentHardware) {
        List<String> ports = currentHardware.getKnownPorts();
        log.info("Rendering available ports: " + ports);
        this.connectPanel.setVisible(!ports.isEmpty());
        this.noPortsMessage.setVisible(ports.isEmpty());
        this.applyPortSelectionToUIcontrol(ports);
        UiUtils.trueLayout(this.connectPanel);
    }

    public static void setFrameIcon(Frame frame) {
        ImageIcon icon = StartupFrame.getBundleIcon();
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
    }

    public static JLabel createLogoLabel() {
        ImageIcon logoIcon = StartupFrame.getBundleIcon();
        if (logoIcon == null) {
            return null;
        }
        JLabel logo = new JLabel(logoIcon);
        logo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        URLLabel.addUrlAction(logo, URLLabel.createUri(URI));
        logo.setCursor(new Cursor(12));
        return logo;
    }

    @Nullable
    private static ImageIcon getBundleIcon() {
        String bundle = BundleUtil.readBundleFullNameNotNull();
        String logoName = bundle.contains("proteus") ? "/com/rusefi/logo_proteus.png" : (bundle.contains("_alphax") ? "/com/rusefi/logo_alphax.png" : (bundle.contains("_mre") ? "/com/rusefi/logo_mre.png" : LOGO));
        return AutoupdateUtil.loadIcon(logoName);
    }

    private void connectButtonAction(JComboBox<String> comboSpeeds) {
        BaudRateHolder.INSTANCE.baudRate = Integer.parseInt((String)comboSpeeds.getSelectedItem());
        String selectedPort = this.comboPorts.getSelectedItem().toString();
        if ("Auto Serial".equals(selectedPort)) {
            String autoDetectedPort;
            SerialAutoChecker.AutoDetectResult detectResult = PortDetector.autoDetectPort(this.frame);
            String string = autoDetectedPort = detectResult == null ? null : detectResult.getSerialPort();
            if (autoDetectedPort == null) {
                return;
            }
            selectedPort = autoDetectedPort;
        }
        this.disposeFrameAndProceed();
        new ConsoleUI(selectedPort);
    }

    @NotNull
    private KeyListener functionalTestEasterEgg() {
        return new KeyAdapter(){
            private static final String TEST = "test";
            private String recentKeyStrokes = "";

            @Override
            public void keyTyped(KeyEvent e) {
                this.recentKeyStrokes = this.recentKeyStrokes + e.getKeyChar();
                if (this.recentKeyStrokes.toLowerCase().endsWith(TEST) && this.showTestConfirmation()) {
                    this.runFunctionalHardwareTest();
                }
            }

            private boolean showTestConfirmation() {
                return JOptionPane.showConfirmDialog(StartupFrame.this.frame, "Want to run functional test? This would freeze UI for the duration of the test", "Better do not run while connected to vehicle!!!", 0) == 0;
            }

            private void runFunctionalHardwareTest() {
                boolean isSuccess = RealHardwareTestLauncher.runHardwareTest();
                JOptionPane.showMessageDialog(null, "Function test passed: " + isSuccess + "\nSee log folder for details.");
            }
        };
    }

    private Component createPcanConnectorButton() {
        JButton button = new JButton("PCAN");
        button.setToolTipText("PCAN connector for TS");
        button.addActionListener(e -> PcanConnectorUI.show());
        return button;
    }

    private Component createShowDeviceManagerButton() {
        JButton showDeviceManager = new JButton(AutoupdateUtil.loadIcon("DeviceManager.png"));
        showDeviceManager.setMargin(new Insets(0, 0, 0, 0));
        showDeviceManager.setToolTipText("Show Device Manager");
        showDeviceManager.addActionListener(event -> {
            try {
                Runtime.getRuntime().exec(ExecHelper.getBatchCommand("devmgmt.msc"));
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        });
        return showDeviceManager;
    }

    private void installMessage(JComponent component, String s) {
        component.setToolTipText(s);
    }

    public void disposeFrameAndProceed() {
        this.isProceeding = true;
        this.frame.dispose();
        SerialPortScanner.INSTANCE.stopTimer();
    }

    private void applyPortSelectionToUIcontrol(List<String> ports) {
        this.comboPorts.removeAllItems();
        for (String port : ports) {
            this.comboPorts.addItem(port);
        }
        String defaultPort = PersistentConfiguration.getConfig().getRoot().getProperty("port");
        this.comboPorts.setSelectedItem(defaultPort);
        UiUtils.trueLayout(this.comboPorts);
    }

    private static JComboBox<String> createSpeedCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        String defaultSpeed = PersistentConfiguration.getConfig().getRoot().getProperty("speed", "115200");
        for (int speed : new int[]{9600, 14400, 19200, 38400, 57600, 115200, 460800, 921600}) {
            combo.addItem(Integer.toString(speed));
        }
        combo.setSelectedItem(defaultSpeed);
        return combo;
    }
}

