/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.sensor_logs;

import com.rusefi.FileLog;
import com.rusefi.sensor_logs.BinaryLogEntry;
import com.rusefi.sensor_logs.SensorLog;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;

public class BinarySensorLog<T extends BinaryLogEntry>
implements SensorLog {
    private final Function<T, Double> valueProvider;
    private final Collection<T> entries;
    private final TimeProvider timeProvider;
    private DataOutputStream stream;
    private String fileName;
    private int counter;

    public BinarySensorLog(Function<T, Double> valueProvider, Collection<T> sensors) {
        this(valueProvider, sensors, System::currentTimeMillis);
    }

    public BinarySensorLog(Function<T, Double> valueProvider, Collection<T> sensors, TimeProvider timeProvider) {
        this.valueProvider = Objects.requireNonNull(valueProvider, "valueProvider");
        this.entries = Objects.requireNonNull(sensors, "entries");
        this.timeProvider = timeProvider;
    }

    @Override
    public double getSecondsSinceFileStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSensorLogLine() {
        if (this.stream == null) {
            FileLog.createFolderIfNeeded();
            this.fileName = "logs/rusEFI_gauges_" + FileLog.getDate() + ".mlg";
            try {
                this.stream = new DataOutputStream(new FileOutputStream(this.fileName));
                this.writeHeader();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.stream = null;
            }
        }
        if (this.stream != null) {
            try {
                this.stream.write(0);
                this.stream.write(this.counter++);
                this.stream.writeShort((int)(this.timeProvider.currentTimestamp() * 100L));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                for (BinaryLogEntry sensor : this.entries) {
                    Double value = this.valueProvider.apply(sensor);
                    if (value == null) {
                        throw new NullPointerException("No value for " + sensor);
                    }
                    sensor.writeToLog(dos, value);
                }
                byte[] byteArray = baos.toByteArray();
                byte checkSum = 0;
                for (byte b : byteArray) {
                    checkSum = (byte)(checkSum + b);
                }
                this.stream.write(byteArray);
                this.stream.write(checkSum);
                if (this.counter % 20 == 0) {
                    this.stream.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeHeader() throws IOException {
        String headerText = "\"rusEFI 20230107\"\n\"Capture Date: " + new Date() + "\"\n";
        for (char c : "MLVLG\u0000".toCharArray()) {
            this.stream.write(c);
        }
        int fieldsDataSize = 0;
        for (BinaryLogEntry entry : this.entries) {
            fieldsDataSize += entry.getByteSize();
        }
        this.stream.write(0);
        this.stream.write(2);
        this.stream.writeInt((int)(System.currentTimeMillis() / 1000L));
        int headerSize = 24 + 89 * this.entries.size();
        this.stream.writeInt(headerSize);
        int headerWithTextSize = headerSize + headerText.length();
        this.stream.writeInt(headerSize);
        this.stream.writeShort(fieldsDataSize);
        this.stream.writeShort(this.entries.size());
        for (BinaryLogEntry sensor : this.entries) {
            String name = sensor.getName();
            String unit = sensor.getUnit();
            String category = sensor.getCategory().getName();
            this.stream.write(sensor.getByteSize());
            this.writeLine(this.stream, name, 34);
            this.writeLine(this.stream, unit, 11);
            this.stream.writeFloat(1.0f);
            this.stream.writeInt(0);
            this.stream.write(2);
            this.writeLine(this.stream, category, 34);
        }
        if (this.stream.size() != headerWithTextSize) {
            throw new IllegalStateException("We are doing something wrong :( stream.size=" + this.stream.size());
        }
        this.writeLine(this.stream, headerText, headerText.length());
    }

    @Override
    public void close() {
        BinarySensorLog.close(this.stream);
        this.stream = null;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private void writeLine(DataOutputStream stream, String name, int length) throws IOException {
        int i;
        for (i = 0; i < Math.min(name.length(), length); ++i) {
            stream.write(name.charAt(i));
        }
        for (i = name.length(); i < length; ++i) {
            stream.write(0);
        }
    }

    static interface TimeProvider {
        public long currentTimestamp();
    }
}

