/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.devexperts.logging.Logging;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.TsOutput;
import java.io.FileWriter;
import java.io.IOException;

public class OutputsSectionConsumer
implements ConfigurationConsumer {
    private static final Logging log = Logging.getLogging(OutputsSectionConsumer.class);
    private final String tsOutputsSectionFileName;
    private final TsOutput tsOutput;
    private int sensorTsPosition;

    public OutputsSectionConsumer(String tsOutputsSectionFileName) {
        this.tsOutputsSectionFileName = tsOutputsSectionFileName;
        this.tsOutput = new TsOutput(false);
    }

    public String getContent() {
        return this.tsOutput.getContent();
    }

    public int getBaseOffset() {
        return this.sensorTsPosition;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        log.info("handleEndStruct");
        this.sensorTsPosition = this.tsOutput.run(readerState, structure, this.sensorTsPosition);
        if (readerState.isStackEmpty() && this.tsOutputsSectionFileName != null) {
            FileWriter fos = new FileWriter(this.tsOutputsSectionFileName);
            fos.write(this.tsOutput.getContent());
            fos.close();
        }
    }
}

