/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.Launcher;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.HwPlatform;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.ui.StatusWindow;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class FirmwareFlasher {
    public static final String IMAGE_FILE = Launcher.INPUT_FILES_PATH + "/rusefi.bin";
    public static final String IMAGE_NO_ASSERTS_FILE = Launcher.INPUT_FILES_PATH + "/rusefi_no_asserts.bin";
    private static final String OPENOCD_EXE = Launcher.TOOLS_PATH + File.separator + "openocd/openocd.exe";
    private static final String OPENOCD_BINARY_LOCATION = ".";
    private static final String SUCCESS_MESSAGE_TAG = "shutdown command invoked";
    private static final String FAILED_MESSAGE_TAG = "failed";
    private static final String NO_DRIVER_MESSAGE_TAG = "failed with LIBUSB_ERROR_NOT_SUPPORTED";
    public static final String TITLE = "rusEFI ST-LINK Firmware Flasher";
    public static final String DONE = "DONE!";
    private final JButton button;

    public FirmwareFlasher(String fileName, String buttonTest, String tooltip) {
        this.button = new JButton(buttonTest);
        this.button.setToolTipText(tooltip);
        this.button.addActionListener(event -> FirmwareFlasher.doUpdateFirmware(fileName, this.button));
    }

    public static void doUpdateFirmware(String fileName, JComponent parent) {
        StatusWindow wnd = new StatusWindow();
        int dialogResult = JOptionPane.showConfirmDialog(parent, "Do you really want to update firmware? Please disconnect vehicle battery before erasing.", "Please disconnect from vehicle", 0);
        if (dialogResult != 0) {
            return;
        }
        wnd.getFrame().setLocationRelativeTo(parent);
        wnd.showFrame(TITLE);
        ExecHelper.submitAction(() -> FirmwareFlasher.doFlashFirmware(wnd, fileName), FirmwareFlasher.class + " extProcessThread");
    }

    public static String getOpenocdCommand() {
        String cfg = FirmwareFlasher.getHardwareKind().getOpenOcdName();
        return OPENOCD_EXE + " -f openocd/" + cfg;
    }

    protected static String executeOpenOCDCommand(String command, StatusWindow wnd) {
        return ExecHelper.executeCommand(OPENOCD_BINARY_LOCATION, OPENOCD_BINARY_LOCATION + File.separator + command, OPENOCD_EXE, wnd);
    }

    private static void doFlashFirmware(StatusWindow wnd, String fileName) {
        if (!new File(fileName).exists()) {
            wnd.append(fileName + " not found, cannot proceed !!!");
            wnd.setStatus("ERROR");
            return;
        }
        StatusAnimation sa = new StatusAnimation(wnd);
        String error = FirmwareFlasher.executeOpenOCDCommand(FirmwareFlasher.getOpenocdCommand() + " -c \"program " + fileName + " verify reset exit 0x08000000\"", wnd);
        if (error.contains(NO_DRIVER_MESSAGE_TAG)) {
            wnd.append(" !!! ERROR: looks like stm32 driver is not installed? The link is above !!!");
        } else if (error.contains(SUCCESS_MESSAGE_TAG) && !error.toLowerCase().contains(FAILED_MESSAGE_TAG)) {
            wnd.append("Flashing looks good!");
            sa.stop();
            wnd.setStatus(DONE);
        } else {
            wnd.setErrorState();
            wnd.append("!!! FIRMWARE FLASH: DOES NOT LOOK RIGHT !!!");
        }
    }

    public JButton getButton() {
        return this.button;
    }

    @NotNull
    public static HwPlatform getHardwareKind() {
        String value = PersistentConfiguration.getConfig().getRoot().getProperty("hardware", HwPlatform.F4.name());
        return HwPlatform.resolve(value);
    }
}

