/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.proteus;

import com.rusefi.IoUtil;
import com.rusefi.RusefiTestBase;
import com.rusefi.binaryprotocol.BinaryProtocolLogger;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.engine_type_e;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ProteusAnalogTest
extends RusefiTestBase {
    @Test
    public void testVbatt() {
        double vbatt = SensorCentral.getInstance().getValue(Sensor.VBATT);
        Assert.assertTrue(vbatt > 11.0);
        Assert.assertTrue(vbatt < 13.0);
    }

    @Test
    public void testTextPull() throws InterruptedException {
        this.requestText();
        final BinaryProtocolLogger logger = new BinaryProtocolLogger(this.ecu.getLinkManager());
        this.ecu.getLinkManager().submit(new Runnable(){

            @Override
            public void run() {
                logger.compositeLogic(ProteusAnalogTest.this.ecu.getLinkManager().getBinaryProtocol());
            }
        });
        this.requestText();
    }

    private void requestText() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference textReference = new AtomicReference();
        this.ecu.getLinkManager().submit(() -> {
            String pendingTextMessages = this.ecu.getLinkManager().getBinaryProtocol().requestPendingTextMessages();
            textReference.set(pendingTextMessages);
            latch.countDown();
        });
        latch.await(60L, TimeUnit.SECONDS);
        Assert.assertNotNull("Not null text protocol response expected", textReference.get());
    }

    private void setIdlePositionAndAssertTps(int idle, int expectedTps) {
        this.ecu.sendCommand("set idle_position " + idle);
        IoUtil.sleepSeconds(5);
        double actualTps = SensorCentral.getInstance().getValue(Sensor.TPS);
        Assert.assertEquals(expectedTps, actualTps, 2.0);
    }

    @Test
    public void testTpsAnalogInput() {
        this.ecu.setEngineType(engine_type_e.PROTEUS_ANALOG_PWM_TEST);
        this.ecu.changeRpm(1000);
        this.ecu.sendCommand(IoUtil.getEnableCommand("self_stimulation"));
        this.setIdlePositionAndAssertTps(2, 0);
        this.setIdlePositionAndAssertTps(20, 0);
        this.setIdlePositionAndAssertTps(35, 25);
        this.setIdlePositionAndAssertTps(50, 50);
        this.setIdlePositionAndAssertTps(65, 75);
        this.setIdlePositionAndAssertTps(80, 100);
        this.setIdlePositionAndAssertTps(98, 0);
    }

    void assertSensorValue(Sensor sensor, double expected) {
        double actual = SensorCentral.getInstance().getValue(sensor);
        Assert.assertEquals(sensor.toString(), expected, actual, 0.5);
    }

    @Test
    public void testUnconnectedInputs() {
        this.assertSensorValue(Sensor.rawClt, 5.0);
        this.assertSensorValue(Sensor.rawIat, 5.0);
    }
}

