/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.EnumPair;
import com.rusefi.EnumsReader;
import com.rusefi.PinType;
import com.rusefi.ReaderStateImpl;
import com.rusefi.VariableRegistry;
import com.rusefi.enum_reader.Value;
import com.rusefi.newparse.DefinitionsState;
import com.rusefi.newparse.parsing.Definition;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.util.SystemOut;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class PinoutLogic {
    private static final Logging log = Logging.getLogging(PinoutLogic.class);
    public static final String CONFIG_BOARDS = "config/boards/";
    private static final String CONNECTORS = "/connectors";
    private static final String NONE = "NONE";
    private static final String QUOTED_NONE = JavaSensorsConsumer.quote("NONE");
    public static final String QUOTED_INVALID = JavaSensorsConsumer.quote("INVALID");
    private final File[] boardYamlFiles;
    private final String boardName;
    private final ArrayList<PinState> globalList = new ArrayList();
    private final Map<String, String> tsNameById = new TreeMap<String, String>();
    private final StringBuilder header = new StringBuilder("//DO NOT EDIT MANUALLY, let automation work hard.\n\n");

    public PinoutLogic(String boardName, File[] boardYamlFiles) {
        log.info(boardName + ": " + Arrays.toString(boardYamlFiles));
        this.boardName = boardName;
        this.boardYamlFiles = boardYamlFiles;
    }

    private static Map.Entry<String, Value> find(EnumsReader.EnumState enumList, String id) {
        for (Map.Entry<String, Value> entry : enumList.entrySet()) {
            if (!entry.getKey().equals(id)) continue;
            return entry;
        }
        return null;
    }

    private static void registerPins(String boardName, ArrayList<PinState> listPins, VariableRegistry registry, ReaderStateImpl state, DefinitionsState parseState) {
        if (listPins == null || listPins.isEmpty()) {
            return;
        }
        HashMap names = new HashMap();
        names.put("outputs", new ArrayList());
        names.put("analog_inputs", new ArrayList());
        names.put("event_inputs", new ArrayList());
        names.put("switch_inputs", new ArrayList());
        for (PinState pinState : listPins) {
            String id = pinState.getId();
            String className = pinState.getPinClass();
            ArrayList classList = (ArrayList)names.get(className);
            if (classList == null) {
                throw new IllegalStateException("Class not found:  " + className);
            }
            PinType listPinType = PinType.find(className);
            String pinType = listPinType.getPinType();
            EnumsReader.EnumState enumList = state.getEnumsReader().getEnums().get(pinType);
            Objects.requireNonNull(enumList, "Enum for " + pinType);
            Map.Entry<String, Value> kv = PinoutLogic.find(enumList, id);
            if (kv == null) {
                throw new IllegalStateException(boardName + ": Not found " + id + " in " + className);
            }
            int index = kv.getValue().getIntValue();
            classList.ensureCapacity(index + 1);
            for (int ii = classList.size(); ii <= index; ++ii) {
                classList.add(null);
            }
            classList.set(index, pinState.getPinTsName());
        }
        for (Map.Entry entry : names.entrySet()) {
            EnumsReader.EnumState enumList;
            PinType namePinType = PinType.find((String)entry.getKey());
            String outputEnumName = namePinType.getOutputEnumName();
            String pinType = namePinType.getPinType();
            String nothingName = namePinType.getNothingName();
            EnumPair pair = PinoutLogic.enumToOptionsList(nothingName, enumList = state.getEnumsReader().getEnums().get(pinType), (ArrayList)entry.getValue());
            if (pair.getSimpleForm().length() > 0) {
                parseState.addDefinition(registry, outputEnumName + "_enum", pair.getShorterForm(), Definition.OverwritePolicy.IgnoreNew);
            }
            parseState.addDefinition(registry, outputEnumName + "_fullenum", pair.getSimpleForm(), Definition.OverwritePolicy.IgnoreNew);
        }
    }

    @NotNull
    public static EnumPair enumToOptionsList(String nothingName, EnumsReader.EnumState enumList, ArrayList<String> values) {
        StringBuilder simpleForm = new StringBuilder();
        HashMap<Integer, String> pinMap = new HashMap<Integer, String>();
        for (int i = 0; i < values.size(); ++i) {
            PinoutLogic.appendCommaIfNeeded(simpleForm);
            String key = PinoutLogic.findKey(enumList, i);
            String value = values.get(i);
            if (i == 0) {
                pinMap.put(i, NONE);
            } else if (value != null) {
                pinMap.put(i, value);
            }
            if (key.equals(nothingName)) {
                simpleForm.append(QUOTED_NONE);
                continue;
            }
            if (value == null) {
                simpleForm.append(QUOTED_INVALID);
                continue;
            }
            String quotedValue = JavaSensorsConsumer.quote(value);
            simpleForm.append(quotedValue);
        }
        String keyValueForm = VariableRegistry.getHumanSortedTsKeyValueString(pinMap);
        return new EnumPair(keyValueForm, simpleForm.toString());
    }

    private static void appendCommaIfNeeded(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(",");
        }
    }

    private static String findKey(EnumsReader.EnumState enumList, int i) {
        String key = "";
        for (Map.Entry<String, Value> entry : enumList.entrySet()) {
            if (entry.getValue().getIntValue() != i) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    private void readMetaInfo(File yamlFile) throws IOException {
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load((Reader)new FileReader(yamlFile));
        if (yamlData == null) {
            SystemOut.println("Null yaml for " + yamlFile);
            return;
        }
        List data = (List)yamlData.get("pins");
        if (data == null) {
            SystemOut.println("Null yaml for " + yamlFile);
            return;
        }
        log.info("Got from " + yamlFile + ": " + data);
        Objects.requireNonNull(data, "data");
        for (Map pin : data) {
            Object pinId = pin.get("id");
            Object pinClass = pin.get("class");
            Object pinName = pin.get("pin");
            String pinTsName = (String)pin.get("ts_name");
            if (pinId == null || pinClass == null || pinTsName == null) continue;
            if (pinId instanceof ArrayList) {
                ArrayList pinIds = (ArrayList)pinId;
                if (!(pinClass instanceof ArrayList)) {
                    throw new IllegalStateException("Expected multiple classes for " + pinIds);
                }
                ArrayList pinClassArray = (ArrayList)pinClass;
                if (pinIds.size() != pinClassArray.size()) {
                    throw new IllegalStateException(pinName + ": id array length should match class array length: " + pinId + " vs " + pinClassArray);
                }
                for (int i = 0; i < pinIds.size(); ++i) {
                    String id = (String)pinIds.get(i);
                    this.addPinToList(id, pinTsName, (String)pinClassArray.get(i));
                }
                continue;
            }
            if (pinId instanceof String) {
                String pinIdString = (String)pinId;
                if (pinIdString.length() == 0) {
                    throw new IllegalStateException("Unexpected empty ID field");
                }
                this.addPinToList(pinIdString, pinTsName, (String)pinClass);
                continue;
            }
            throw new IllegalStateException("Unexpected type of ID field: " + pinId.getClass().getSimpleName());
        }
    }

    private void addPinToList(String id, String pinTsName, String pinClass) {
        String existingTsName = this.tsNameById.get(id);
        if (existingTsName != null && !existingTsName.equals(pinTsName)) {
            throw new IllegalStateException("ID used multiple times with different ts_name: " + id);
        }
        this.tsNameById.put(id, pinTsName);
        PinState thisPin = new PinState(id, pinTsName, pinClass);
        this.globalList.add(thisPin);
    }

    public static PinoutLogic create(String boardName, String rootFolder) {
        FilenameFilter filter;
        String dirPath = rootFolder + boardName + CONNECTORS;
        File dirName = new File(dirPath);
        Object[] boardYamlFiles = dirName.listFiles(filter = (f, name) -> name.endsWith(".yaml"));
        if (boardYamlFiles == null) {
            log.info("No yaml files in " + dirPath);
            return null;
        }
        Arrays.sort(boardYamlFiles);
        return new PinoutLogic(boardName, (File[])boardYamlFiles);
    }

    public void registerBoardSpecificPinNames(VariableRegistry registry, ReaderStateImpl state, DefinitionsState parseState) throws IOException {
        this.readFiles();
        PinoutLogic.registerPins(this.boardName, this.globalList, registry, state, parseState);
        try (FileWriter getTsNameByIdFile = new FileWriter(CONFIG_BOARDS + this.boardName + CONNECTORS + File.separator + "generated_ts_name_by_pin.cpp");){
            getTsNameByIdFile.append(this.header);
            getTsNameByIdFile.append("#include \"pch.h\"\n\n");
            getTsNameByIdFile.append("// see comments at declaration in pin_repository.h\n");
            getTsNameByIdFile.append("const char * getBoardSpecificPinName(brain_pin_e brainPin) {\n");
            getTsNameByIdFile.append("\tswitch(brainPin) {\n");
            for (Map.Entry<String, String> e : this.tsNameById.entrySet()) {
                if (e.getKey().contains("ADC")) continue;
                getTsNameByIdFile.append("\t\tcase Gpio::" + e.getKey() + ": return " + JavaSensorsConsumer.quote(e.getValue()) + ";\n");
            }
            getTsNameByIdFile.append("\t\tdefault: return nullptr;\n");
            getTsNameByIdFile.append("\t}\n");
            getTsNameByIdFile.append("\treturn nullptr;\n}\n");
        }
    }

    private void readFiles() throws IOException {
        for (File yamlFile : this.boardYamlFiles) {
            this.header.append("// auto-generated by PinoutLogic.java based on " + yamlFile + "\n");
            this.readMetaInfo(yamlFile);
        }
        log.info("Got from " + this.boardYamlFiles.length + " file(s): " + this);
    }

    public List<String> getInputFiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (File yamlFile : this.boardYamlFiles) {
            result.add(CONFIG_BOARDS + this.boardName + CONNECTORS + File.separator + yamlFile.getName());
        }
        return result;
    }

    public String toString() {
        return "PinoutLogic{boardName='" + this.boardName + '\'' + ", globalList=" + this.globalList + ", tsNameById=" + this.tsNameById + '}';
    }

    private static class PinState {
        private final String id;
        private final String pinTsName;
        private final String pinClass;

        public PinState(String id, String pinName, String pinClass) {
            this.id = id;
            this.pinTsName = pinName;
            this.pinClass = pinClass;
        }

        public String getId() {
            return this.id;
        }

        public String getPinTsName() {
            return this.pinTsName;
        }

        public String getPinClass() {
            return this.pinClass;
        }

        public String toString() {
            return "PinState{id='" + this.id + '\'' + ", pinTsName='" + this.pinTsName + '\'' + ", pinClass='" + this.pinClass + '\'' + '}';
        }
    }
}

