/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.core.EngineState;
import com.rusefi.core.ISensorCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.trigger_type_e;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.waves.EngineReport;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class IoUtil {
    private static final Logging log = Logging.getLogging(IoUtil.class);

    static void sendBlockingCommand(String command, CommandQueue commandQueue) {
        IoUtil.sendBlockingCommand(command, 500, commandQueue);
    }

    public static String getSetCommand(String settingName) {
        return "set " + settingName;
    }

    public static String getEnableCommand(String settingName) {
        return "enable " + settingName;
    }

    public static String getDisableCommand(String settingName) {
        return "disable " + settingName;
    }

    public static void sendBlockingCommand(String command, int timeoutMs, CommandQueue commandQueue) {
        CountDownLatch responseLatch = new CountDownLatch(1);
        long time = System.currentTimeMillis();
        log.info("Sending command [" + command + "]");
        long begin = System.currentTimeMillis();
        commandQueue.write(command, timeoutMs, () -> {
            responseLatch.countDown();
            log.info("Got confirmation in " + (System.currentTimeMillis() - begin) + "ms");
        });
        IoUtil.wait(responseLatch, timeoutMs);
        if (responseLatch.getCount() > 0L) {
            log.info("No confirmation in " + timeoutMs);
        }
        log.info("Command [" + command + "] executed in " + (System.currentTimeMillis() - time));
    }

    static void wait(CountDownLatch responseLatch, int milliseconds) {
        try {
            responseLatch.await(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void changeRpm(CommandQueue commandQueue, int rpm) {
        log.info("AUTOTEST rpm EN " + rpm);
        IoUtil.sendBlockingCommand("rpm " + rpm, commandQueue);
        long time = System.currentTimeMillis();
        CountDownLatch rpmLatch = new CountDownLatch(1);
        ISensorCentral.ListenerToken listenerToken = SensorCentral.getInstance().addListener(Sensor.RPMValue, actualRpm -> {
            if (EngineReport.isCloseEnough(rpm, actualRpm)) {
                rpmLatch.countDown();
            }
        });
        try {
            rpmLatch.await(40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        listenerToken.remove();
        double actualRpm2 = SensorCentral.getInstance().getValue(Sensor.RPMValue);
        if (!EngineReport.isCloseEnough(rpm, actualRpm2)) {
            throw new IllegalStateException("rpm change did not happen: " + rpm + ", actual " + actualRpm2);
        }
        log.info("AUTOTEST RPM change [" + rpm + "] executed in " + (System.currentTimeMillis() - time));
    }

    static void waitForFirstResponse() throws InterruptedException {
        log.info("Let's give it some time to start...");
        CountDownLatch startup = new CountDownLatch(1);
        long waitStart = System.currentTimeMillis();
        ISensorCentral.ListenerToken listener = SensorCentral.getInstance().addListener(Sensor.RPMValue, value -> startup.countDown());
        startup.await(5L, TimeUnit.SECONDS);
        listener.remove();
        FileLog.MAIN.logLine("Got first signal in " + (System.currentTimeMillis() - waitStart));
    }

    static void connectToSimulator(LinkManager linkManager, boolean startProcess) throws InterruptedException {
        if (startProcess) {
            if (!TcpConnector.getAvailablePorts().isEmpty()) {
                throw new IllegalStateException("Port already binded on startup?");
            }
            SimulatorExecHelper.startSimulator();
        }
        linkManager.startAndConnect("29001", ConnectionStateListener.VOID);
        linkManager.getEngineState().registerStringValueAction("rusEfiVersion", EngineState.ValueCallback.VOID);
        IoUtil.waitForFirstResponse();
    }

    public static void sleepSeconds(int seconds) {
        FileLog.MAIN.logLine("Sleeping " + seconds + " seconds");
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void realHardwareConnect(LinkManager linkManager, String port) {
        linkManager.getEngineState().registerStringValueAction("outpin", EngineState.ValueCallback.VOID);
        linkManager.getEngineState().registerStringValueAction("analog_chart", EngineState.ValueCallback.VOID);
        try {
            linkManager.connect(port).await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Not connected in time");
        }
    }

    @NotNull
    public static String setTriggerType(trigger_type_e triggerType) {
        return "set trigger_type " + triggerType.ordinal();
    }
}

