/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIterator;
import java.util.List;

class PerFieldWithStructuresIterator
extends FieldIterator {
    private final ReaderState state;
    private final String prefix;
    private final Strategy strategy;
    private final String prefixSeparator;
    private final StringBuilder sb = new StringBuilder();

    public PerFieldWithStructuresIterator(ReaderState state, List<ConfigField> fields, String prefix, Strategy strategy, String prefixSeparator) {
        super(fields);
        this.state = state;
        this.prefix = prefix;
        this.strategy = strategy;
        this.prefixSeparator = prefixSeparator;
    }

    public PerFieldWithStructuresIterator(ReaderState state, List<ConfigField> fields, String prefix, Strategy strategy) {
        this(state, fields, prefix, strategy, "_");
    }

    @Override
    public void end() {
        String content;
        ConfigStructure cs = this.cf.getState().getStructures().get(this.cf.getType());
        if (cs != null) {
            if (this.cf.isFromIterate()) {
                content = "";
            } else {
                String extraPrefix = this.prefix + this.cf.getName() + this.prefixSeparator;
                PerFieldWithStructuresIterator fieldIterator = new PerFieldWithStructuresIterator(this.state, cs.getTsFields(), extraPrefix, this.strategy, this.prefixSeparator);
                fieldIterator.loop();
                content = fieldIterator.sb.toString();
            }
        } else {
            content = this.strategy.process(this.state, this.cf, this.prefix);
        }
        this.sb.append(content);
        super.end();
    }

    public String getContent() {
        return this.sb.toString();
    }

    static interface Strategy {
        public String process(ReaderState var1, ConfigField var2, String var3);
    }
}

