/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse.layout;

import com.rusefi.newparse.layout.ArrayLayout;
import com.rusefi.newparse.layout.Layout;
import com.rusefi.newparse.layout.ScalarLayout;
import com.rusefi.newparse.layout.StructNamePrefixer;
import com.rusefi.newparse.outputs.TsMetadata;
import com.rusefi.newparse.parsing.ArrayField;
import com.rusefi.newparse.parsing.Field;
import com.rusefi.newparse.parsing.ScalarField;
import com.rusefi.newparse.parsing.Union;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class UnionLayout
extends Layout {
    private final List<Layout> children = new ArrayList<Layout>();

    public UnionLayout(Union u) {
        for (Field f : u.fields) {
            if (f instanceof ArrayField) {
                ArrayField af = (ArrayField)f;
                assert (!af.iterate.booleanValue());
                ScalarField prototype = (ScalarField)af.prototype;
                this.children.add(new ArrayLayout(prototype, af.length));
                continue;
            }
            if (f instanceof ScalarField) {
                this.children.add(new ScalarLayout((ScalarField)f));
                continue;
            }
            throw new RuntimeException("Tried to create union with member type " + f.getClass().getSimpleName());
        }
    }

    @Override
    public void setOffset(int offset) {
        super.setOffset(offset);
        this.children.forEach(c -> c.setOffset(offset));
    }

    @Override
    public void setOffsetWithinStruct(int offset) {
        super.setOffsetWithinStruct(offset);
        this.children.forEach(c -> c.setOffsetWithinStruct(offset));
    }

    @Override
    public int getSize() {
        return this.children.stream().map(Layout::getSize).max(Integer::compare).get();
    }

    @Override
    public int getAlignment() {
        return this.children.stream().map(Layout::getAlignment).max(Integer::compare).get();
    }

    @Override
    protected void writeTunerstudioLayout(PrintStream ps, TsMetadata meta, StructNamePrefixer prefixer, int offsetAdd) {
        this.children.forEach(c -> c.writeTunerstudioLayout(ps, meta, prefixer, offsetAdd));
    }

    @Override
    public void writeCLayout(PrintStream ps) {
        this.writeCOffsetHeader(ps, "union size " + this.getSize() + ", " + this.children.size() + " members", null);
        ps.println("\tunion {");
        this.children.forEach(c -> c.writeCLayout(ps));
        ps.println("\t};");
    }
}

