/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.ReportLine;
import com.rusefi.models.Factory;
import com.rusefi.models.MafValue;
import com.rusefi.models.RpmValue;
import com.rusefi.models.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportReader {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\D*(\\d*);a0;(\\d*);a1;-1;rpm;(\\d*);wave;(\\d*).*");
    private static final int INVALID_RPM_DIFF = 200;
    private static int prevMaf = -1;
    private static int prevRpm = -1;
    private static int prevWave = -1;

    public static void main(String[] args) {
        ReportReader.readMap("200ohm.txt");
    }

    public static TreeMap<Integer, TreeMap<Integer, ReportLine>> readMap(String filename) {
        if (!new File(filename).exists()) {
            FileLog.MAIN.logLine("Error: not found " + filename);
            return new TreeMap<Integer, TreeMap<Integer, ReportLine>>();
        }
        List<ReportLine> lines = ReportReader.read(filename);
        FileLog.MAIN.logLine("Got " + lines.size() + " lines");
        lines = ReportReader.filter(Collections.unmodifiableList(lines));
        ReportReader.findMinMax(lines);
        return ReportReader.asMap(lines);
    }

    private static TreeMap<Integer, TreeMap<Integer, ReportLine>> asMap(List<ReportLine> lines) {
        TreeMap<Integer, TreeMap<Integer, ReportLine>> rpm2mapByMaf = new TreeMap<Integer, TreeMap<Integer, ReportLine>>();
        for (ReportLine cur : lines) {
            int rpmKey = cur.getRpm().getValue();
            rpmKey -= rpmKey % 100;
            TreeMap<Integer, ReportLine> maf2line = Utils.getOrCreate(rpm2mapByMaf, rpmKey, new Factory<Integer, TreeMap<Integer, ReportLine>>(){

                @Override
                public TreeMap<Integer, ReportLine> create(Integer key) {
                    return new TreeMap<Integer, ReportLine>();
                }
            });
            maf2line.put(cur.getMaf().getValue(), cur);
        }
        return rpm2mapByMaf;
    }

    private static void findMinMax(List<ReportLine> lines) {
        int minMaf = 100000;
        int maxMaf = 0;
        int minRpm = 100000;
        int maxRpm = 0;
        for (ReportLine cur : lines) {
            minMaf = Math.min(minMaf, cur.getMaf().getValue());
            maxMaf = Math.max(maxMaf, cur.getMaf().getValue());
            minRpm = Math.min(minRpm, cur.getRpm().getValue());
            maxRpm = Math.max(maxRpm, cur.getRpm().getValue());
        }
        FileLog.MAIN.logLine("MAF range from " + minMaf + " to " + maxMaf);
        FileLog.MAIN.logLine("RPM range from " + minRpm + " to " + maxRpm);
    }

    private static List<ReportLine> filter(List<ReportLine> lines) {
        ArrayList<ReportLine> result = new ArrayList<ReportLine>();
        int maxValidDiff = 0;
        int originalCount = lines.size();
        int removedCount = 0;
        result.add(lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            ReportLine prev = (ReportLine)result.get(result.size() - 1);
            ReportLine cur = lines.get(i);
            int rpmDiff = cur.getRpm().getValue() - prev.getRpm().getValue();
            int timeDiff = cur.getTime() - prev.getTime();
            if (Math.abs(rpmDiff) > 200) {
                FileLog.MAIN.logLine("Invalid diff: " + cur);
                ++removedCount;
                continue;
            }
            result.add(cur);
            maxValidDiff = Math.max(maxValidDiff, Math.abs(rpmDiff));
        }
        double percent = 100.0 * (double)removedCount / (double)originalCount;
        FileLog.MAIN.logLine(removedCount + " out of " + originalCount + " record(s) removed. " + percent + "%");
        FileLog.MAIN.logLine("Max valid diff: " + maxValidDiff);
        return result;
    }

    private static List<ReportLine> read(String filename) {
        LinkedList<ReportLine> result = new LinkedList<ReportLine>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                ReportLine rl = ReportReader.handleOneLine(line);
                if (rl == null) continue;
                result.add(rl);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private static ReportLine handleOneLine(String line) {
        Matcher m = LINE_PATTERN.matcher(line);
        if (m.matches()) {
            int time = Integer.parseInt(m.group(1));
            MafValue maf = MafValue.valueOf(m.group(2));
            RpmValue rpm = RpmValue.valueOf(m.group(3));
            int wave = Integer.parseInt(m.group(4));
            if (prevMaf == maf.getValue() && prevRpm == rpm.getValue() && prevWave == wave) {
                return null;
            }
            prevMaf = maf.getValue();
            prevRpm = rpm.getValue();
            prevWave = wave;
            return new ReportLine(time, maf, rpm, wave);
        }
        return null;
    }
}

