/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.util.SystemOut;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.zip.CRC32;

public class IoUtil2 {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readFile(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    String string = stringBuilder.toString();
                    return string;
                }
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
        }
        catch (IOException e) {
            return "";
        }
    }

    private static long getCrc32(String fileName) throws IOException {
        File file = new File(fileName);
        byte[] fileContent = Files.readAllBytes(file.toPath());
        for (int i = 0; i < fileContent.length; ++i) {
            byte aByte = fileContent[i];
            if (aByte != 13) continue;
            throw new IllegalStateException("CR \\r 0x0D byte not allowed in cacheable content " + fileName + " at index=" + i);
        }
        CRC32 c = new CRC32();
        c.update(fileContent, 0, fileContent.length);
        return c.getValue();
    }

    static long getCrc32(List<String> inputFileNames) throws IOException {
        long crc32 = 0L;
        for (String fileName : inputFileNames) {
            long c = IoUtil2.getCrc32(fileName) & 0xFFFFFFFFL;
            SystemOut.println("CRC32 from " + fileName + " = " + c);
            crc32 ^= c;
        }
        SystemOut.println("CRC32 from all input files = " + crc32);
        return crc32;
    }
}

