/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.Field;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.ui.UIContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.ByteBuffer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class BaseConfigField {
    private static final Logging log = Logging.getLogging(BaseConfigField.class);
    protected final JLabel status = new JLabel("P");
    private final JPanel panel = new JPanel(new BorderLayout());
    private final UIContext uiContext;
    protected final Field field;

    public BaseConfigField(UIContext uiContext, Field field) {
        this.uiContext = uiContext;
        this.field = field;
        this.status.setToolTipText("Pending...");
    }

    protected void requestInitialValue(Field field) {
        ConnectionStatusLogic.INSTANCE.executeOnceConnected(() -> this.processInitialValue(field));
    }

    private void processInitialValue(Field field) {
        BinaryProtocol bp = this.uiContext.getLinkManager().getCurrentStreamState();
        if (bp == null) {
            return;
        }
        ConfigurationImage ci = bp.getControllerConfiguration();
        if (ci == null) {
            return;
        }
        this.loadValue(ci);
    }

    protected abstract void loadValue(ConfigurationImage var1);

    protected void onValueArrived() {
        this.status.setText("");
        this.status.setToolTipText(null);
    }

    protected void sendValue(Field field, String newValue) {
        String msg = field.setCommand() + " " + newValue;
        log.info("Sending " + msg);
        this.uiContext.getCommandQueue().write(msg);
        this.status.setText("S");
        this.status.setToolTipText("Storing...");
    }

    protected void createUi(String topLabel, Component control) {
        JPanel center = new JPanel(new FlowLayout());
        control.setEnabled(false);
        center.add(this.status);
        center.add(control);
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.panel.add((Component)new JLabel(topLabel), "West");
        this.panel.add((Component)center, "Center");
    }

    public JPanel getContent() {
        return this.panel;
    }

    @NotNull
    protected ByteBuffer getByteBuffer(ConfigurationImage ci) {
        return this.field.getByteBuffer(ci);
    }
}

