/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.TestHelper;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.generated.Fields;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.BinaryProtocolProxy;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.ui.StatusConsumer;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class TcpCommunicationIntegrationTest {
    @Test
    public void testConnectionFailed() throws InterruptedException {
        int port = 6101;
        final CountDownLatch failedCountDownLatch = new CountDownLatch(1);
        LinkManager clientManager = new LinkManager();
        clientManager.startAndConnect(Integer.toString(port), new ConnectionStateListener(){

            @Override
            public void onConnectionEstablished() {
                System.out.println("Established");
            }

            @Override
            public void onConnectionFailed(String s) {
                System.out.println("onConnectionFailed");
                failedCountDownLatch.countDown();
            }
        });
        TestHelper.assertLatch(failedCountDownLatch);
    }

    @Test
    public void testConnectAndTransmitImageOverTcpIp() throws InterruptedException {
        ScalarIniField iniField = TestHelper.createIniField(Fields.CYLINDERSCOUNT);
        int value = 239;
        ConfigurationImage serverImage = TestHelper.prepareImage(value, iniField);
        int port = 6100;
        BinaryProtocolServer server = TestHelper.createVirtualController(port, serverImage, new BinaryProtocolServer.Context());
        final CountDownLatch connectionEstablishedCountDownLatch = new CountDownLatch(1);
        LinkManager clientManager = new LinkManager();
        clientManager.startAndConnect("localhost:" + port, new ConnectionStateListener(){

            @Override
            public void onConnectionEstablished() {
                connectionEstablishedCountDownLatch.countDown();
            }

            @Override
            public void onConnectionFailed(String s) {
                System.out.println("Failed");
            }
        });
        TestHelper.assertLatch("Connection established", connectionEstablishedCountDownLatch);
        Assert.assertEquals(0L, server.unknownCommands.get());
        BinaryProtocol clientStreamState = clientManager.getCurrentStreamState();
        Objects.requireNonNull(clientStreamState, "clientStreamState");
        ConfigurationImage clientImage = clientStreamState.getControllerConfiguration();
        String clientValue = iniField.getValue(clientImage);
        Assert.assertEquals(Double.toString(value), clientValue);
        clientManager.close();
    }

    @Test
    public void testProxy() throws InterruptedException, IOException {
        ConfigurationImage serverImage = TestHelper.prepareImage(239, TestHelper.createIniField(Fields.CYLINDERSCOUNT));
        int controllerPort = 6102;
        TestHelper.createVirtualController(controllerPort, serverImage, new BinaryProtocolServer.Context());
        int proxyPort = 6103;
        IoStream targetEcuSocket = TestHelper.connectToLocalhost(controllerPort);
        AtomicInteger relayCommandCounter = new AtomicInteger();
        BinaryProtocolProxy.createProxy(targetEcuSocket, proxyPort, () -> relayCommandCounter.incrementAndGet(), StatusConsumer.ANONYMOUS);
        final CountDownLatch connectionEstablishedCountDownLatch = new CountDownLatch(1);
        LinkManager clientManager = new LinkManager();
        clientManager.startAndConnect("localhost:" + proxyPort, new ConnectionStateListener(){

            @Override
            public void onConnectionEstablished() {
                connectionEstablishedCountDownLatch.countDown();
            }

            @Override
            public void onConnectionFailed(String s) {
                System.out.println("Failed");
            }
        });
        TestHelper.assertLatch("Connection established", connectionEstablishedCountDownLatch);
        clientManager.close();
    }
}

