/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.etb.EtbTarget;
import com.rusefi.etb.StandardTestSequence;
import com.rusefi.etb.TestSequenceStep;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.etb.EtbTestSequence;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class EtbMonteCarloSequence {
    private static final int TOTAL_CYCLES_COUNT = 15;
    private static final double DEFAULT_POSITION = 7.0;
    private static final int CLT_THRESHOLD = 75;
    private final JButton button = new JButton("ETB I feel lucky!");
    private final UIContext uiContext;
    private int counter;
    private double bestResultSoFar = 750.0;

    public EtbMonteCarloSequence(final UIContext uiContext) {
        this.uiContext = uiContext;
        this.button.addActionListener(e -> {
            this.counter = 0;
            EtbTestSequence.executor.execute(new Runnable(){

                @Override
                public void run() {
                    uiContext.getCommandQueue().write("set_etb_duty NaN");
                    BinaryProtocol.sleep(3000L);
                    StandardTestSequence.metric.start(30000, 10);
                    EtbTestSequence.executor.execute(() -> EtbMonteCarloSequence.this.runRandomCycle());
                }
            });
        });
    }

    private void runRandomCycle() {
        boolean offset = false;
        double pFactor = 6 + this.counter * 2;
        double iFactor = 0.0;
        double dFactor = 0.0;
        final String stats = "mcstats:offset:0:pFactor:" + pFactor + ":iFactor:" + 0.0 + ":dFactor:" + 0.0;
        MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, stats);
        this.uiContext.getCommandQueue().write("etbreset");
        this.uiContext.getCommandQueue().write("set etb_o 0");
        this.uiContext.getCommandQueue().write("set etb_p " + pFactor);
        this.uiContext.getCommandQueue().write("set etb_i 0.0");
        this.uiContext.getCommandQueue().write("set etb_d 0.0");
        MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, this.uiContext.sensorLogger.getSecondsSinceFileStart() + " running " + stats);
        EtbTarget firstStep = new EtbTarget(this.uiContext, 10000L, 7.0, null, TestSequenceStep.Condition.YES);
        TestSequenceStep.Condition condition = new TestSequenceStep.Condition(){

            @Override
            public boolean shouldRunTask() {
                boolean shouldRun;
                double currentValue = StandardTestSequence.metric.getStandardDeviation();
                boolean bl = shouldRun = currentValue < EtbMonteCarloSequence.this.bestResultSoFar;
                if (!shouldRun) {
                    MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, "Too much error accumulated, aborting! " + currentValue + " > " + EtbMonteCarloSequence.this.bestResultSoFar);
                }
                return shouldRun;
            }
        };
        AtomicInteger stepCounter = new AtomicInteger();
        AtomicInteger totalSteps = new AtomicInteger();
        Runnable onEachStep = () -> SwingUtilities.invokeLater(() -> {
            String state = stepCounter.incrementAndGet() + "/" + totalSteps.get();
            double value = StandardTestSequence.metric.getStandardDeviation();
            MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, "Running " + state + ", current=" + value);
        });
        TestSequenceStep last = StandardTestSequence.addSequence(this.uiContext, firstStep, onEachStep, condition);
        last.addNext(new TestSequenceStep(5000L, TestSequenceStep.Condition.YES){

            @Override
            protected void doJob() {
                double cycleResult;
                double clt = SensorCentral.getInstance().getValue(Sensor.CLT);
                if (clt > 75.0) {
                    EtbMonteCarloSequence.this.stopETB();
                    BinaryProtocol.sleep(10000L);
                    System.exit(-1);
                }
                if ((cycleResult = SensorCentral.getInstance().getValue(Sensor.ETB_CONTROL_QUALITY)) < EtbMonteCarloSequence.this.bestResultSoFar) {
                    EtbMonteCarloSequence.this.bestResultSoFar = cycleResult;
                    MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, ((EtbMonteCarloSequence)EtbMonteCarloSequence.this).uiContext.sensorLogger.getSecondsSinceFileStart() + ":" + stats + ":new_record:" + EtbMonteCarloSequence.this.bestResultSoFar);
                }
                MessagesCentral.getInstance().postMessage(EtbMonteCarloSequence.class, ((EtbMonteCarloSequence)EtbMonteCarloSequence.this).uiContext.sensorLogger.getSecondsSinceFileStart() + ":" + stats + ":result:" + cycleResult);
                if (EtbMonteCarloSequence.this.counter == 15) {
                    EtbMonteCarloSequence.this.stopETB();
                    MessagesCentral.getInstance().postMessage(EtbTestSequence.class, "ETB MC sequence done!");
                    return;
                }
                EtbMonteCarloSequence.this.counter++;
                MessagesCentral.getInstance().postMessage(EtbTestSequence.class, "Starting " + EtbMonteCarloSequence.this.counter + " of " + 15);
                EtbMonteCarloSequence.this.runRandomCycle();
            }
        });
        totalSteps.set(TestSequenceStep.count(firstStep));
        firstStep.execute(EtbTestSequence.executor);
    }

    public JButton getButton() {
        return this.button;
    }

    private void stopETB() {
        this.uiContext.getCommandQueue().write("set_etb_duty 0");
    }
}

