/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ConfigFieldImpl;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.abego.treelayout.internal.util.java.lang.string.StringUtil;

public class GaugeConsumer
implements ConfigurationConsumer {
    private final String fileName;
    private final LinkedHashMap<String, StringBuilder> byCategory = new LinkedHashMap();

    public GaugeConsumer(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        if (readerState.isStackEmpty()) {
            PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(readerState, structure.getTsFields(), "", (state, configField, prefix) -> this.handle(configField, prefix));
            iterator.loop();
        }
    }

    @Override
    public void endFile() throws IOException {
        if (this.fileName != null) {
            FileWriter fw = new FileWriter(this.fileName);
            fw.write(this.getContent());
            fw.close();
        }
    }

    private String handle(ConfigField configField, String prefix) {
        String comment = DataLogConsumer.getHumanGaugeName("", configField);
        comment = ConfigFieldImpl.unquote(comment);
        if (!prefix.isEmpty()) {
            comment = prefix + " " + comment;
        }
        comment = StringUtil.quote(comment);
        double min = configField.getMin();
        double max = configField.getMax();
        int digits = configField.getDigits();
        String category = configField.getCategory();
        if (category == null) {
            return "";
        }
        StringBuilder sb = this.byCategory.computeIfAbsent(category, s -> new StringBuilder());
        String fullName = prefix + configField.getName();
        String gaugeEntry = fullName + "Gauge = " + fullName + "," + comment + ", " + StringUtil.quote(configField.getUnits()) + ", " + min + "," + max + ", " + min + "," + max + ", " + min + "," + max + ", " + digits + "," + digits + "\n";
        sb.append(gaugeEntry);
        return "";
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, StringBuilder> e : this.byCategory.entrySet()) {
            sb.append("\t").append("gaugeCategory = ").append(e.getKey()).append("\n");
            sb.append((CharSequence)e.getValue());
        }
        return sb.toString();
    }
}

