/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ExtraUtil;
import com.rusefi.FirmwareVersion;
import com.rusefi.IoUtil2;
import com.rusefi.PinoutLogic;
import com.rusefi.ReaderStateImpl;
import com.rusefi.ToolUtil;
import com.rusefi.VariableRegistry;
import com.rusefi.newparse.ParseState;
import com.rusefi.output.GetConfigValueConsumer;
import com.rusefi.output.SignatureConsumer;
import com.rusefi.output.TSProjectConsumer;
import com.rusefi.trigger.TriggerWheelTSLogic;
import com.rusefi.util.SystemOut;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ConfigDefinition {
    public static final String SIGNATURE_HASH = "SIGNATURE_HASH";
    private static final String KEY_DEFINITION = "-definition";
    private static final String KEY_TS_DESTINATION = "-ts_destination";
    private static final String KEY_C_DESTINATION = "-c_destination";
    private static final String KEY_C_DEFINES = "-c_defines";
    public static final String KEY_WITH_C_DEFINES = "-with_c_defines";
    private static final String KEY_JAVA_DESTINATION = "-java_destination";
    private static final String KEY_FIRING = "-firing_order";
    public static final String KEY_PREPEND = "-prepend";
    private static final String KEY_SIGNATURE = "-signature";
    private static final String KEY_SIGNATURE_DESTINATION = "-signature_destination";
    private static final String KEY_ZERO_INIT = "-initialize_to_zero";
    private static final String KEY_BOARD_NAME = "-board";
    public static boolean needZeroInit = true;

    public static void main(String[] args) {
        try {
            ConfigDefinition.doJob(args, new ReaderStateImpl());
        }
        catch (Throwable e) {
            SystemOut.println(e);
            e.printStackTrace();
            SystemOut.close();
            System.exit(-1);
        }
        SystemOut.close();
    }

    public static void doJob(String[] args, ReaderStateImpl state) throws IOException {
        if (args.length < 2) {
            SystemOut.println("Please specify\r\n-definition x\r\n-ts_destination x\r\n-c_destination x\r\n-java_destination x\r\n");
            return;
        }
        SystemOut.println(ConfigDefinition.class + " Invoked with " + Arrays.toString(args));
        String tsInputFileFolder = null;
        String destCDefinesFileName = null;
        String firingEnumFileName = null;
        String triggersInputFolder = null;
        String signatureDestination = null;
        String signaturePrependFile = null;
        ArrayList<String> enumInputFiles = new ArrayList<String>();
        PinoutLogic pinoutLogic = null;
        block42: for (int i = 0; i < args.length - 1; i += 2) {
            String key = args[i];
            switch (key) {
                case "-tool": {
                    ToolUtil.TOOL = args[i + 1];
                    continue block42;
                }
                case "-definition": {
                    state.setDefinitionInputFile(args[i + 1]);
                    continue block42;
                }
                case "-ts_destination": {
                    tsInputFileFolder = args[i + 1];
                    continue block42;
                }
                case "-c_destination": {
                    state.addCHeaderDestination(args[i + 1]);
                    continue block42;
                }
                case "-initialize_to_zero": {
                    needZeroInit = Boolean.parseBoolean(args[i + 1]);
                    continue block42;
                }
                case "-with_c_defines": {
                    state.setWithC_Defines(Boolean.parseBoolean(args[i + 1]));
                    continue block42;
                }
                case "-c_defines": {
                    destCDefinesFileName = args[i + 1];
                    continue block42;
                }
                case "-java_destination": {
                    state.addJavaDestination(args[i + 1]);
                    continue block42;
                }
                case "-field_lookup_file": {
                    String cppFile = args[i + 1];
                    String mdFile = args[i + 2];
                    ++i;
                    state.addDestination(new GetConfigValueConsumer(cppFile, mdFile));
                    continue block42;
                }
                case "-readfile": {
                    String keyName = args[i + 1];
                    String fileName = args[++i + 1];
                    try {
                        state.getVariableRegistry().register(keyName, IoUtil2.readFile(fileName));
                    }
                    catch (RuntimeException e) {
                        throw new IllegalStateException("While processing " + fileName, e);
                    }
                    state.addInputFile(fileName);
                }
                case "-firing_order": {
                    firingEnumFileName = args[i + 1];
                    state.addInputFile(firingEnumFileName);
                    continue block42;
                }
                case "-triggerInputFolder": {
                    triggersInputFolder = args[i + 1];
                    continue block42;
                }
                case "-prepend": {
                    state.addPrepend(args[i + 1].trim());
                    continue block42;
                }
                case "-signature": {
                    signaturePrependFile = args[i + 1];
                    state.getPrependFiles().add(args[i + 1]);
                    continue block42;
                }
                case "-signature_destination": {
                    signatureDestination = args[i + 1];
                    continue block42;
                }
                case "-enumInputFile": {
                    enumInputFiles.add(args[i + 1]);
                    continue block42;
                }
                case "-ts_output_name": {
                    state.setTsFileOutputName(args[i + 1]);
                    continue block42;
                }
                case "-board": {
                    String boardName = args[i + 1];
                    pinoutLogic = PinoutLogic.create(boardName, "config/boards/");
                    if (pinoutLogic == null) continue block42;
                    for (String inputFile : pinoutLogic.getInputFiles()) {
                        state.addInputFile(inputFile);
                    }
                    continue block42;
                }
            }
        }
        if (tsInputFileFolder != null) {
            state.addInputFile(TSProjectConsumer.getTsFileInputName(tsInputFileFolder));
        }
        if (!enumInputFiles.isEmpty()) {
            for (String ef : enumInputFiles) {
                state.read(new FileReader(ef));
            }
            SystemOut.println(state.getEnumsReader().getEnums().size() + " total enumsReader");
        }
        ParseState parseState = new ParseState(state.getEnumsReader());
        FirmwareVersion uniqueId = new FirmwareVersion(IoUtil2.getCrc32(state.getInputFiles()));
        SignatureConsumer.storeUniqueBuildId(state, parseState, tsInputFileFolder, uniqueId);
        ExtraUtil.handleFiringOrder(firingEnumFileName, state.getVariableRegistry(), parseState);
        new TriggerWheelTSLogic().execute(triggersInputFolder, state.getVariableRegistry());
        if (pinoutLogic != null) {
            pinoutLogic.registerBoardSpecificPinNames(state.getVariableRegistry(), state, parseState);
        }
        for (String string : state.getPrependFiles()) {
        }
        if (tsInputFileFolder != null) {
            state.addDestination(new TSProjectConsumer(tsInputFileFolder, state));
            VariableRegistry tmpRegistry = new VariableRegistry();
            tmpRegistry.register(SIGNATURE_HASH, uniqueId.encode());
            tmpRegistry.readPrependValues(signaturePrependFile);
            state.addDestination(new SignatureConsumer(signatureDestination, tmpRegistry));
        }
        if (state.isDestinationsEmpty()) {
            throw new IllegalArgumentException("No destinations specified");
        }
        state.doJob();
        if (destCDefinesFileName != null) {
            ExtraUtil.writeDefinesToFile(state.getVariableRegistry(), destCDefinesFileName, state.getDefinitionInputFile());
        }
    }
}

